<?php
/**
 * PayrollAuApi
 * PHP version 5
 *
 * @category Class
 * @package  XeroAPI\XeroPHP PayrollAu
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Xero Payroll AU API
 *
 * This is the Xero Payroll API for orgs in Australia region.
 *
 * OpenAPI spec version: 2.10.4
 * Contact: api@xero.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 4.3.1
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace XeroAPI\XeroPHP\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use XeroAPI\XeroPHP\ApiException;
use XeroAPI\XeroPHP\Configuration;
use XeroAPI\XeroPHP\HeaderSelector;
use XeroAPI\XeroPHP\PayrollAuObjectSerializer;

/**
 * PayrollAuApi Class Doc Comment
 *
 * @category Class
 * @package  XeroAPI\XeroPHP
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class PayrollAuApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation createEmployee
     * Creates a payroll employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollAu\Employee[] $employee employee (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollAu\Employees
     */
    public function createEmployee($xero_tenant_id, $employee)
    {
        list($response) = $this->createEmployeeWithHttpInfo($xero_tenant_id, $employee);
        return $response;
    }
    /**
     * Operation createEmployeeWithHttpInfo
     * Creates a payroll employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollAu\Employee[] $employee (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollAu\Employees, HTTP status code, HTTP response headers (array of strings)
     */
    public function createEmployeeWithHttpInfo($xero_tenant_id, $employee)
    {
        $request = $this->createEmployeeRequest($xero_tenant_id, $employee);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollAu\Employees' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollAuObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollAu\Employees', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollAu\Employees';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollAuObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollAuObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollAu\Employees',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation createEmployeeAsync
     * Creates a payroll employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollAu\Employee[] $employee (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createEmployeeAsync($xero_tenant_id, $employee)
    {
        return $this->createEmployeeAsyncWithHttpInfo($xero_tenant_id, $employee)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation createEmployeeAsyncWithHttpInfo
     * Creates a payroll employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollAu\Employee[] $employee (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function createEmployeeAsyncWithHttpInfo($xero_tenant_id, $employee)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollAu\Employees';
        $request = $this->createEmployeeRequest($xero_tenant_id, $employee);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollAuObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createEmployee'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollAu\Employee[] $employee (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function createEmployeeRequest($xero_tenant_id, $employee)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createEmployee'
            );
        }
        // verify the required parameter 'employee' is set
        if ($employee === null || (is_array($employee) && count($employee) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $employee when calling createEmployee'
            );
        }
        $resourcePath = '/Employees';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollAuObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // body params
        $_tempBody = null;
        if (isset($employee)) {
            $_tempBody = $employee;
        }
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollAuObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'POST',
            $this->config->getHostPayrollAu() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createLeaveApplication
     * Creates a leave application
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollAu\LeaveApplication[] $leave_application leave_application (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollAu\LeaveApplications
     */
    public function createLeaveApplication($xero_tenant_id, $leave_application)
    {
        list($response) = $this->createLeaveApplicationWithHttpInfo($xero_tenant_id, $leave_application);
        return $response;
    }
    /**
     * Operation createLeaveApplicationWithHttpInfo
     * Creates a leave application
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollAu\LeaveApplication[] $leave_application (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollAu\LeaveApplications, HTTP status code, HTTP response headers (array of strings)
     */
    public function createLeaveApplicationWithHttpInfo($xero_tenant_id, $leave_application)
    {
        $request = $this->createLeaveApplicationRequest($xero_tenant_id, $leave_application);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollAu\LeaveApplications' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollAuObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollAu\LeaveApplications', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollAu\LeaveApplications';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollAuObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollAuObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollAu\LeaveApplications',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation createLeaveApplicationAsync
     * Creates a leave application
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollAu\LeaveApplication[] $leave_application (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createLeaveApplicationAsync($xero_tenant_id, $leave_application)
    {
        return $this->createLeaveApplicationAsyncWithHttpInfo($xero_tenant_id, $leave_application)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation createLeaveApplicationAsyncWithHttpInfo
     * Creates a leave application
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollAu\LeaveApplication[] $leave_application (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function createLeaveApplicationAsyncWithHttpInfo($xero_tenant_id, $leave_application)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollAu\LeaveApplications';
        $request = $this->createLeaveApplicationRequest($xero_tenant_id, $leave_application);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollAuObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createLeaveApplication'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollAu\LeaveApplication[] $leave_application (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function createLeaveApplicationRequest($xero_tenant_id, $leave_application)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createLeaveApplication'
            );
        }
        // verify the required parameter 'leave_application' is set
        if ($leave_application === null || (is_array($leave_application) && count($leave_application) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $leave_application when calling createLeaveApplication'
            );
        }
        $resourcePath = '/LeaveApplications';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollAuObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // body params
        $_tempBody = null;
        if (isset($leave_application)) {
            $_tempBody = $leave_application;
        }
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollAuObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'POST',
            $this->config->getHostPayrollAu() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createPayItem
     * Creates a pay item
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollAu\PayItem $pay_item pay_item (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollAu\PayItems
     */
    public function createPayItem($xero_tenant_id, $pay_item)
    {
        list($response) = $this->createPayItemWithHttpInfo($xero_tenant_id, $pay_item);
        return $response;
    }
    /**
     * Operation createPayItemWithHttpInfo
     * Creates a pay item
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollAu\PayItem $pay_item (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollAu\PayItems, HTTP status code, HTTP response headers (array of strings)
     */
    public function createPayItemWithHttpInfo($xero_tenant_id, $pay_item)
    {
        $request = $this->createPayItemRequest($xero_tenant_id, $pay_item);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollAu\PayItems' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollAuObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollAu\PayItems', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollAu\PayItems';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollAuObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollAuObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollAu\PayItems',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation createPayItemAsync
     * Creates a pay item
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollAu\PayItem $pay_item (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createPayItemAsync($xero_tenant_id, $pay_item)
    {
        return $this->createPayItemAsyncWithHttpInfo($xero_tenant_id, $pay_item)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation createPayItemAsyncWithHttpInfo
     * Creates a pay item
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollAu\PayItem $pay_item (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function createPayItemAsyncWithHttpInfo($xero_tenant_id, $pay_item)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollAu\PayItems';
        $request = $this->createPayItemRequest($xero_tenant_id, $pay_item);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollAuObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createPayItem'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollAu\PayItem $pay_item (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function createPayItemRequest($xero_tenant_id, $pay_item)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createPayItem'
            );
        }
        // verify the required parameter 'pay_item' is set
        if ($pay_item === null || (is_array($pay_item) && count($pay_item) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $pay_item when calling createPayItem'
            );
        }
        $resourcePath = '/PayItems';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollAuObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // body params
        $_tempBody = null;
        if (isset($pay_item)) {
            $_tempBody = $pay_item;
        }
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollAuObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'POST',
            $this->config->getHostPayrollAu() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createPayRun
     * Creates a pay run
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollAu\PayRun[] $pay_run pay_run (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollAu\PayRuns
     */
    public function createPayRun($xero_tenant_id, $pay_run)
    {
        list($response) = $this->createPayRunWithHttpInfo($xero_tenant_id, $pay_run);
        return $response;
    }
    /**
     * Operation createPayRunWithHttpInfo
     * Creates a pay run
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollAu\PayRun[] $pay_run (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollAu\PayRuns, HTTP status code, HTTP response headers (array of strings)
     */
    public function createPayRunWithHttpInfo($xero_tenant_id, $pay_run)
    {
        $request = $this->createPayRunRequest($xero_tenant_id, $pay_run);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollAu\PayRuns' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollAuObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollAu\PayRuns', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollAu\PayRuns';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollAuObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollAuObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollAu\PayRuns',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation createPayRunAsync
     * Creates a pay run
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollAu\PayRun[] $pay_run (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createPayRunAsync($xero_tenant_id, $pay_run)
    {
        return $this->createPayRunAsyncWithHttpInfo($xero_tenant_id, $pay_run)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation createPayRunAsyncWithHttpInfo
     * Creates a pay run
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollAu\PayRun[] $pay_run (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function createPayRunAsyncWithHttpInfo($xero_tenant_id, $pay_run)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollAu\PayRuns';
        $request = $this->createPayRunRequest($xero_tenant_id, $pay_run);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollAuObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createPayRun'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollAu\PayRun[] $pay_run (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function createPayRunRequest($xero_tenant_id, $pay_run)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createPayRun'
            );
        }
        // verify the required parameter 'pay_run' is set
        if ($pay_run === null || (is_array($pay_run) && count($pay_run) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $pay_run when calling createPayRun'
            );
        }
        $resourcePath = '/PayRuns';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollAuObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // body params
        $_tempBody = null;
        if (isset($pay_run)) {
            $_tempBody = $pay_run;
        }
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollAuObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'POST',
            $this->config->getHostPayrollAu() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createPayrollCalendar
     * Creates a Payroll Calendar
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollAu\PayrollCalendar[] $payroll_calendar payroll_calendar (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollAu\PayrollCalendars
     */
    public function createPayrollCalendar($xero_tenant_id, $payroll_calendar)
    {
        list($response) = $this->createPayrollCalendarWithHttpInfo($xero_tenant_id, $payroll_calendar);
        return $response;
    }
    /**
     * Operation createPayrollCalendarWithHttpInfo
     * Creates a Payroll Calendar
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollAu\PayrollCalendar[] $payroll_calendar (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollAu\PayrollCalendars, HTTP status code, HTTP response headers (array of strings)
     */
    public function createPayrollCalendarWithHttpInfo($xero_tenant_id, $payroll_calendar)
    {
        $request = $this->createPayrollCalendarRequest($xero_tenant_id, $payroll_calendar);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollAu\PayrollCalendars' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollAuObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollAu\PayrollCalendars', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollAu\PayrollCalendars';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollAuObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollAuObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollAu\PayrollCalendars',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation createPayrollCalendarAsync
     * Creates a Payroll Calendar
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollAu\PayrollCalendar[] $payroll_calendar (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createPayrollCalendarAsync($xero_tenant_id, $payroll_calendar)
    {
        return $this->createPayrollCalendarAsyncWithHttpInfo($xero_tenant_id, $payroll_calendar)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation createPayrollCalendarAsyncWithHttpInfo
     * Creates a Payroll Calendar
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollAu\PayrollCalendar[] $payroll_calendar (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function createPayrollCalendarAsyncWithHttpInfo($xero_tenant_id, $payroll_calendar)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollAu\PayrollCalendars';
        $request = $this->createPayrollCalendarRequest($xero_tenant_id, $payroll_calendar);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollAuObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createPayrollCalendar'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollAu\PayrollCalendar[] $payroll_calendar (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function createPayrollCalendarRequest($xero_tenant_id, $payroll_calendar)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createPayrollCalendar'
            );
        }
        // verify the required parameter 'payroll_calendar' is set
        if ($payroll_calendar === null || (is_array($payroll_calendar) && count($payroll_calendar) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $payroll_calendar when calling createPayrollCalendar'
            );
        }
        $resourcePath = '/PayrollCalendars';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollAuObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // body params
        $_tempBody = null;
        if (isset($payroll_calendar)) {
            $_tempBody = $payroll_calendar;
        }
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollAuObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'POST',
            $this->config->getHostPayrollAu() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createSuperfund
     * Creates a superfund
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollAu\SuperFund[] $super_fund super_fund (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollAu\SuperFunds
     */
    public function createSuperfund($xero_tenant_id, $super_fund)
    {
        list($response) = $this->createSuperfundWithHttpInfo($xero_tenant_id, $super_fund);
        return $response;
    }
    /**
     * Operation createSuperfundWithHttpInfo
     * Creates a superfund
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollAu\SuperFund[] $super_fund (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollAu\SuperFunds, HTTP status code, HTTP response headers (array of strings)
     */
    public function createSuperfundWithHttpInfo($xero_tenant_id, $super_fund)
    {
        $request = $this->createSuperfundRequest($xero_tenant_id, $super_fund);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollAu\SuperFunds' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollAuObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollAu\SuperFunds', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollAu\SuperFunds';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollAuObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollAuObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollAu\SuperFunds',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation createSuperfundAsync
     * Creates a superfund
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollAu\SuperFund[] $super_fund (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createSuperfundAsync($xero_tenant_id, $super_fund)
    {
        return $this->createSuperfundAsyncWithHttpInfo($xero_tenant_id, $super_fund)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation createSuperfundAsyncWithHttpInfo
     * Creates a superfund
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollAu\SuperFund[] $super_fund (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function createSuperfundAsyncWithHttpInfo($xero_tenant_id, $super_fund)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollAu\SuperFunds';
        $request = $this->createSuperfundRequest($xero_tenant_id, $super_fund);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollAuObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createSuperfund'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollAu\SuperFund[] $super_fund (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function createSuperfundRequest($xero_tenant_id, $super_fund)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createSuperfund'
            );
        }
        // verify the required parameter 'super_fund' is set
        if ($super_fund === null || (is_array($super_fund) && count($super_fund) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $super_fund when calling createSuperfund'
            );
        }
        $resourcePath = '/Superfunds';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollAuObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // body params
        $_tempBody = null;
        if (isset($super_fund)) {
            $_tempBody = $super_fund;
        }
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollAuObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'POST',
            $this->config->getHostPayrollAu() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createTimesheet
     * Creates a timesheet
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollAu\Timesheet[] $timesheet timesheet (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollAu\Timesheets
     */
    public function createTimesheet($xero_tenant_id, $timesheet)
    {
        list($response) = $this->createTimesheetWithHttpInfo($xero_tenant_id, $timesheet);
        return $response;
    }
    /**
     * Operation createTimesheetWithHttpInfo
     * Creates a timesheet
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollAu\Timesheet[] $timesheet (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollAu\Timesheets, HTTP status code, HTTP response headers (array of strings)
     */
    public function createTimesheetWithHttpInfo($xero_tenant_id, $timesheet)
    {
        $request = $this->createTimesheetRequest($xero_tenant_id, $timesheet);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollAu\Timesheets' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollAuObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollAu\Timesheets', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollAu\Timesheets';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollAuObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollAuObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollAu\Timesheets',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation createTimesheetAsync
     * Creates a timesheet
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollAu\Timesheet[] $timesheet (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createTimesheetAsync($xero_tenant_id, $timesheet)
    {
        return $this->createTimesheetAsyncWithHttpInfo($xero_tenant_id, $timesheet)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation createTimesheetAsyncWithHttpInfo
     * Creates a timesheet
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollAu\Timesheet[] $timesheet (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function createTimesheetAsyncWithHttpInfo($xero_tenant_id, $timesheet)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollAu\Timesheets';
        $request = $this->createTimesheetRequest($xero_tenant_id, $timesheet);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollAuObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createTimesheet'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollAu\Timesheet[] $timesheet (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function createTimesheetRequest($xero_tenant_id, $timesheet)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createTimesheet'
            );
        }
        // verify the required parameter 'timesheet' is set
        if ($timesheet === null || (is_array($timesheet) && count($timesheet) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $timesheet when calling createTimesheet'
            );
        }
        $resourcePath = '/Timesheets';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollAuObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // body params
        $_tempBody = null;
        if (isset($timesheet)) {
            $_tempBody = $timesheet;
        }
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollAuObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'POST',
            $this->config->getHostPayrollAu() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getEmployee
     * Retrieves an employee's detail by unique employee id
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollAu\Employees
     */
    public function getEmployee($xero_tenant_id, $employee_id)
    {
        list($response) = $this->getEmployeeWithHttpInfo($xero_tenant_id, $employee_id);
        return $response;
    }
    /**
     * Operation getEmployeeWithHttpInfo
     * Retrieves an employee's detail by unique employee id
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollAu\Employees, HTTP status code, HTTP response headers (array of strings)
     */
    public function getEmployeeWithHttpInfo($xero_tenant_id, $employee_id)
    {
        $request = $this->getEmployeeRequest($xero_tenant_id, $employee_id);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollAu\Employees' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollAuObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollAu\Employees', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollAu\Employees';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollAuObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollAuObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollAu\Employees',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getEmployeeAsync
     * Retrieves an employee's detail by unique employee id
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getEmployeeAsync($xero_tenant_id, $employee_id)
    {
        return $this->getEmployeeAsyncWithHttpInfo($xero_tenant_id, $employee_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getEmployeeAsyncWithHttpInfo
     * Retrieves an employee's detail by unique employee id
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getEmployeeAsyncWithHttpInfo($xero_tenant_id, $employee_id)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollAu\Employees';
        $request = $this->getEmployeeRequest($xero_tenant_id, $employee_id);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollAuObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getEmployee'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getEmployeeRequest($xero_tenant_id, $employee_id)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getEmployee'
            );
        }
        // verify the required parameter 'employee_id' is set
        if ($employee_id === null || (is_array($employee_id) && count($employee_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $employee_id when calling getEmployee'
            );
        }
        $resourcePath = '/Employees/{EmployeeID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollAuObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // path params
        if ($employee_id !== null) {
            $resourcePath = str_replace(
                '{' . 'EmployeeID' . '}',
                PayrollAuObjectSerializer::toPathValue($employee_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollAuObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHostPayrollAu() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getEmployees
     * Searches payroll employees
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $if_modified_since Only records created or modified since this timestamp will be returned (optional)
     * @param  string $where Filter by an any element (optional)
     * @param  string $order Order by an any element (optional)
     * @param  int $page e.g. page&#x3D;1 – Up to 100 employees will be returned in a single API call (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollAu\Employees|\XeroAPI\XeroPHP\Models\PayrollAu\APIException
     */
    public function getEmployees($xero_tenant_id, $if_modified_since = null, $where = null, $order = null, $page = null)
    {
        list($response) = $this->getEmployeesWithHttpInfo($xero_tenant_id, $if_modified_since, $where, $order, $page);
        return $response;
    }
    /**
     * Operation getEmployeesWithHttpInfo
     * Searches payroll employees
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $if_modified_since Only records created or modified since this timestamp will be returned (optional)
     * @param  string $where Filter by an any element (optional)
     * @param  string $order Order by an any element (optional)
     * @param  int $page e.g. page&#x3D;1 – Up to 100 employees will be returned in a single API call (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollAu\Employees|\XeroAPI\XeroPHP\Models\PayrollAu\APIException, HTTP status code, HTTP response headers (array of strings)
     */
    public function getEmployeesWithHttpInfo($xero_tenant_id, $if_modified_since = null, $where = null, $order = null, $page = null)
    {
        $request = $this->getEmployeesRequest($xero_tenant_id, $if_modified_since, $where, $order, $page);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollAu\Employees' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollAuObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollAu\Employees', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\XeroAPI\XeroPHP\Models\PayrollAu\APIException' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollAuObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollAu\APIException', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollAu\Employees';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollAuObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollAuObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollAu\Employees',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = PayrollAuObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollAu\APIException',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getEmployeesAsync
     * Searches payroll employees
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $if_modified_since Only records created or modified since this timestamp will be returned (optional)
     * @param  string $where Filter by an any element (optional)
     * @param  string $order Order by an any element (optional)
     * @param  int $page e.g. page&#x3D;1 – Up to 100 employees will be returned in a single API call (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getEmployeesAsync($xero_tenant_id, $if_modified_since = null, $where = null, $order = null, $page = null)
    {
        return $this->getEmployeesAsyncWithHttpInfo($xero_tenant_id, $if_modified_since, $where, $order, $page)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getEmployeesAsyncWithHttpInfo
     * Searches payroll employees
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $if_modified_since Only records created or modified since this timestamp will be returned (optional)
     * @param  string $where Filter by an any element (optional)
     * @param  string $order Order by an any element (optional)
     * @param  int $page e.g. page&#x3D;1 – Up to 100 employees will be returned in a single API call (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getEmployeesAsyncWithHttpInfo($xero_tenant_id, $if_modified_since = null, $where = null, $order = null, $page = null)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollAu\Employees';
        $request = $this->getEmployeesRequest($xero_tenant_id, $if_modified_since, $where, $order, $page);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollAuObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getEmployees'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $if_modified_since Only records created or modified since this timestamp will be returned (optional)
     * @param  string $where Filter by an any element (optional)
     * @param  string $order Order by an any element (optional)
     * @param  int $page e.g. page&#x3D;1 – Up to 100 employees will be returned in a single API call (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getEmployeesRequest($xero_tenant_id, $if_modified_since = null, $where = null, $order = null, $page = null)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getEmployees'
            );
        }
        $resourcePath = '/Employees';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // query params
        if ($where !== null) {
            $queryParams['where'] = PayrollAuObjectSerializer::toQueryValue($where);
        }
        // query params
        if ($order !== null) {
            $queryParams['order'] = PayrollAuObjectSerializer::toQueryValue($order);
        }
        // query params
        if ($page !== null) {
            $queryParams['page'] = PayrollAuObjectSerializer::toQueryValue($page);
        }
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollAuObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // header params
        if ($if_modified_since !== null) {
            $headerParams['If-Modified-Since'] = PayrollAuObjectSerializer::toHeaderValue($if_modified_since);
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollAuObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHostPayrollAu() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getLeaveApplication
     * Retrieves a leave application by a unique leave application id
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $leave_application_id Leave Application id for single object (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollAu\LeaveApplications
     */
    public function getLeaveApplication($xero_tenant_id, $leave_application_id)
    {
        list($response) = $this->getLeaveApplicationWithHttpInfo($xero_tenant_id, $leave_application_id);
        return $response;
    }
    /**
     * Operation getLeaveApplicationWithHttpInfo
     * Retrieves a leave application by a unique leave application id
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $leave_application_id Leave Application id for single object (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollAu\LeaveApplications, HTTP status code, HTTP response headers (array of strings)
     */
    public function getLeaveApplicationWithHttpInfo($xero_tenant_id, $leave_application_id)
    {
        $request = $this->getLeaveApplicationRequest($xero_tenant_id, $leave_application_id);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollAu\LeaveApplications' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollAuObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollAu\LeaveApplications', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollAu\LeaveApplications';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollAuObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollAuObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollAu\LeaveApplications',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getLeaveApplicationAsync
     * Retrieves a leave application by a unique leave application id
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $leave_application_id Leave Application id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getLeaveApplicationAsync($xero_tenant_id, $leave_application_id)
    {
        return $this->getLeaveApplicationAsyncWithHttpInfo($xero_tenant_id, $leave_application_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getLeaveApplicationAsyncWithHttpInfo
     * Retrieves a leave application by a unique leave application id
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $leave_application_id Leave Application id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getLeaveApplicationAsyncWithHttpInfo($xero_tenant_id, $leave_application_id)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollAu\LeaveApplications';
        $request = $this->getLeaveApplicationRequest($xero_tenant_id, $leave_application_id);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollAuObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getLeaveApplication'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $leave_application_id Leave Application id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getLeaveApplicationRequest($xero_tenant_id, $leave_application_id)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getLeaveApplication'
            );
        }
        // verify the required parameter 'leave_application_id' is set
        if ($leave_application_id === null || (is_array($leave_application_id) && count($leave_application_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $leave_application_id when calling getLeaveApplication'
            );
        }
        $resourcePath = '/LeaveApplications/{LeaveApplicationID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollAuObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // path params
        if ($leave_application_id !== null) {
            $resourcePath = str_replace(
                '{' . 'LeaveApplicationID' . '}',
                PayrollAuObjectSerializer::toPathValue($leave_application_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollAuObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHostPayrollAu() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getLeaveApplications
     * Retrieves leave applications
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $if_modified_since Only records created or modified since this timestamp will be returned (optional)
     * @param  string $where Filter by an any element (optional)
     * @param  string $order Order by an any element (optional)
     * @param  int $page e.g. page&#x3D;1 – Up to 100 objects will be returned in a single API call (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollAu\LeaveApplications|\XeroAPI\XeroPHP\Models\PayrollAu\APIException
     */
    public function getLeaveApplications($xero_tenant_id, $if_modified_since = null, $where = null, $order = null, $page = null)
    {
        list($response) = $this->getLeaveApplicationsWithHttpInfo($xero_tenant_id, $if_modified_since, $where, $order, $page);
        return $response;
    }
    /**
     * Operation getLeaveApplicationsWithHttpInfo
     * Retrieves leave applications
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $if_modified_since Only records created or modified since this timestamp will be returned (optional)
     * @param  string $where Filter by an any element (optional)
     * @param  string $order Order by an any element (optional)
     * @param  int $page e.g. page&#x3D;1 – Up to 100 objects will be returned in a single API call (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollAu\LeaveApplications|\XeroAPI\XeroPHP\Models\PayrollAu\APIException, HTTP status code, HTTP response headers (array of strings)
     */
    public function getLeaveApplicationsWithHttpInfo($xero_tenant_id, $if_modified_since = null, $where = null, $order = null, $page = null)
    {
        $request = $this->getLeaveApplicationsRequest($xero_tenant_id, $if_modified_since, $where, $order, $page);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollAu\LeaveApplications' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollAuObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollAu\LeaveApplications', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\XeroAPI\XeroPHP\Models\PayrollAu\APIException' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollAuObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollAu\APIException', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollAu\LeaveApplications';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollAuObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollAuObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollAu\LeaveApplications',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = PayrollAuObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollAu\APIException',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getLeaveApplicationsAsync
     * Retrieves leave applications
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $if_modified_since Only records created or modified since this timestamp will be returned (optional)
     * @param  string $where Filter by an any element (optional)
     * @param  string $order Order by an any element (optional)
     * @param  int $page e.g. page&#x3D;1 – Up to 100 objects will be returned in a single API call (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getLeaveApplicationsAsync($xero_tenant_id, $if_modified_since = null, $where = null, $order = null, $page = null)
    {
        return $this->getLeaveApplicationsAsyncWithHttpInfo($xero_tenant_id, $if_modified_since, $where, $order, $page)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getLeaveApplicationsAsyncWithHttpInfo
     * Retrieves leave applications
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $if_modified_since Only records created or modified since this timestamp will be returned (optional)
     * @param  string $where Filter by an any element (optional)
     * @param  string $order Order by an any element (optional)
     * @param  int $page e.g. page&#x3D;1 – Up to 100 objects will be returned in a single API call (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getLeaveApplicationsAsyncWithHttpInfo($xero_tenant_id, $if_modified_since = null, $where = null, $order = null, $page = null)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollAu\LeaveApplications';
        $request = $this->getLeaveApplicationsRequest($xero_tenant_id, $if_modified_since, $where, $order, $page);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollAuObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getLeaveApplications'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $if_modified_since Only records created or modified since this timestamp will be returned (optional)
     * @param  string $where Filter by an any element (optional)
     * @param  string $order Order by an any element (optional)
     * @param  int $page e.g. page&#x3D;1 – Up to 100 objects will be returned in a single API call (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getLeaveApplicationsRequest($xero_tenant_id, $if_modified_since = null, $where = null, $order = null, $page = null)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getLeaveApplications'
            );
        }
        $resourcePath = '/LeaveApplications';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // query params
        if ($where !== null) {
            $queryParams['where'] = PayrollAuObjectSerializer::toQueryValue($where);
        }
        // query params
        if ($order !== null) {
            $queryParams['order'] = PayrollAuObjectSerializer::toQueryValue($order);
        }
        // query params
        if ($page !== null) {
            $queryParams['page'] = PayrollAuObjectSerializer::toQueryValue($page);
        }
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollAuObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // header params
        if ($if_modified_since !== null) {
            $headerParams['If-Modified-Since'] = PayrollAuObjectSerializer::toHeaderValue($if_modified_since);
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollAuObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHostPayrollAu() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getPayItems
     * Retrieves pay items
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $if_modified_since Only records created or modified since this timestamp will be returned (optional)
     * @param  string $where Filter by an any element (optional)
     * @param  string $order Order by an any element (optional)
     * @param  int $page e.g. page&#x3D;1 – Up to 100 objects will be returned in a single API call (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollAu\PayItems|\XeroAPI\XeroPHP\Models\PayrollAu\APIException
     */
    public function getPayItems($xero_tenant_id, $if_modified_since = null, $where = null, $order = null, $page = null)
    {
        list($response) = $this->getPayItemsWithHttpInfo($xero_tenant_id, $if_modified_since, $where, $order, $page);
        return $response;
    }
    /**
     * Operation getPayItemsWithHttpInfo
     * Retrieves pay items
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $if_modified_since Only records created or modified since this timestamp will be returned (optional)
     * @param  string $where Filter by an any element (optional)
     * @param  string $order Order by an any element (optional)
     * @param  int $page e.g. page&#x3D;1 – Up to 100 objects will be returned in a single API call (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollAu\PayItems|\XeroAPI\XeroPHP\Models\PayrollAu\APIException, HTTP status code, HTTP response headers (array of strings)
     */
    public function getPayItemsWithHttpInfo($xero_tenant_id, $if_modified_since = null, $where = null, $order = null, $page = null)
    {
        $request = $this->getPayItemsRequest($xero_tenant_id, $if_modified_since, $where, $order, $page);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollAu\PayItems' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollAuObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollAu\PayItems', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\XeroAPI\XeroPHP\Models\PayrollAu\APIException' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollAuObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollAu\APIException', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollAu\PayItems';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollAuObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollAuObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollAu\PayItems',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = PayrollAuObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollAu\APIException',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getPayItemsAsync
     * Retrieves pay items
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $if_modified_since Only records created or modified since this timestamp will be returned (optional)
     * @param  string $where Filter by an any element (optional)
     * @param  string $order Order by an any element (optional)
     * @param  int $page e.g. page&#x3D;1 – Up to 100 objects will be returned in a single API call (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getPayItemsAsync($xero_tenant_id, $if_modified_since = null, $where = null, $order = null, $page = null)
    {
        return $this->getPayItemsAsyncWithHttpInfo($xero_tenant_id, $if_modified_since, $where, $order, $page)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getPayItemsAsyncWithHttpInfo
     * Retrieves pay items
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $if_modified_since Only records created or modified since this timestamp will be returned (optional)
     * @param  string $where Filter by an any element (optional)
     * @param  string $order Order by an any element (optional)
     * @param  int $page e.g. page&#x3D;1 – Up to 100 objects will be returned in a single API call (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getPayItemsAsyncWithHttpInfo($xero_tenant_id, $if_modified_since = null, $where = null, $order = null, $page = null)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollAu\PayItems';
        $request = $this->getPayItemsRequest($xero_tenant_id, $if_modified_since, $where, $order, $page);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollAuObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getPayItems'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $if_modified_since Only records created or modified since this timestamp will be returned (optional)
     * @param  string $where Filter by an any element (optional)
     * @param  string $order Order by an any element (optional)
     * @param  int $page e.g. page&#x3D;1 – Up to 100 objects will be returned in a single API call (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getPayItemsRequest($xero_tenant_id, $if_modified_since = null, $where = null, $order = null, $page = null)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getPayItems'
            );
        }
        $resourcePath = '/PayItems';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // query params
        if ($where !== null) {
            $queryParams['where'] = PayrollAuObjectSerializer::toQueryValue($where);
        }
        // query params
        if ($order !== null) {
            $queryParams['order'] = PayrollAuObjectSerializer::toQueryValue($order);
        }
        // query params
        if ($page !== null) {
            $queryParams['page'] = PayrollAuObjectSerializer::toQueryValue($page);
        }
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollAuObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // header params
        if ($if_modified_since !== null) {
            $headerParams['If-Modified-Since'] = PayrollAuObjectSerializer::toHeaderValue($if_modified_since);
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollAuObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHostPayrollAu() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getPayRun
     * Retrieves a pay run by using a unique pay run id
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $pay_run_id PayRun id for single object (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollAu\PayRuns
     */
    public function getPayRun($xero_tenant_id, $pay_run_id)
    {
        list($response) = $this->getPayRunWithHttpInfo($xero_tenant_id, $pay_run_id);
        return $response;
    }
    /**
     * Operation getPayRunWithHttpInfo
     * Retrieves a pay run by using a unique pay run id
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $pay_run_id PayRun id for single object (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollAu\PayRuns, HTTP status code, HTTP response headers (array of strings)
     */
    public function getPayRunWithHttpInfo($xero_tenant_id, $pay_run_id)
    {
        $request = $this->getPayRunRequest($xero_tenant_id, $pay_run_id);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollAu\PayRuns' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollAuObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollAu\PayRuns', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollAu\PayRuns';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollAuObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollAuObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollAu\PayRuns',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getPayRunAsync
     * Retrieves a pay run by using a unique pay run id
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $pay_run_id PayRun id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getPayRunAsync($xero_tenant_id, $pay_run_id)
    {
        return $this->getPayRunAsyncWithHttpInfo($xero_tenant_id, $pay_run_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getPayRunAsyncWithHttpInfo
     * Retrieves a pay run by using a unique pay run id
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $pay_run_id PayRun id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getPayRunAsyncWithHttpInfo($xero_tenant_id, $pay_run_id)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollAu\PayRuns';
        $request = $this->getPayRunRequest($xero_tenant_id, $pay_run_id);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollAuObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getPayRun'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $pay_run_id PayRun id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getPayRunRequest($xero_tenant_id, $pay_run_id)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getPayRun'
            );
        }
        // verify the required parameter 'pay_run_id' is set
        if ($pay_run_id === null || (is_array($pay_run_id) && count($pay_run_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $pay_run_id when calling getPayRun'
            );
        }
        $resourcePath = '/PayRuns/{PayRunID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollAuObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // path params
        if ($pay_run_id !== null) {
            $resourcePath = str_replace(
                '{' . 'PayRunID' . '}',
                PayrollAuObjectSerializer::toPathValue($pay_run_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollAuObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHostPayrollAu() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getPayRuns
     * Retrieves pay runs
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $if_modified_since Only records created or modified since this timestamp will be returned (optional)
     * @param  string $where Filter by an any element (optional)
     * @param  string $order Order by an any element (optional)
     * @param  int $page e.g. page&#x3D;1 – Up to 100 PayRuns will be returned in a single API call (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollAu\PayRuns|\XeroAPI\XeroPHP\Models\PayrollAu\APIException
     */
    public function getPayRuns($xero_tenant_id, $if_modified_since = null, $where = null, $order = null, $page = null)
    {
        list($response) = $this->getPayRunsWithHttpInfo($xero_tenant_id, $if_modified_since, $where, $order, $page);
        return $response;
    }
    /**
     * Operation getPayRunsWithHttpInfo
     * Retrieves pay runs
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $if_modified_since Only records created or modified since this timestamp will be returned (optional)
     * @param  string $where Filter by an any element (optional)
     * @param  string $order Order by an any element (optional)
     * @param  int $page e.g. page&#x3D;1 – Up to 100 PayRuns will be returned in a single API call (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollAu\PayRuns|\XeroAPI\XeroPHP\Models\PayrollAu\APIException, HTTP status code, HTTP response headers (array of strings)
     */
    public function getPayRunsWithHttpInfo($xero_tenant_id, $if_modified_since = null, $where = null, $order = null, $page = null)
    {
        $request = $this->getPayRunsRequest($xero_tenant_id, $if_modified_since, $where, $order, $page);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollAu\PayRuns' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollAuObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollAu\PayRuns', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\XeroAPI\XeroPHP\Models\PayrollAu\APIException' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollAuObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollAu\APIException', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollAu\PayRuns';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollAuObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollAuObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollAu\PayRuns',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = PayrollAuObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollAu\APIException',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getPayRunsAsync
     * Retrieves pay runs
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $if_modified_since Only records created or modified since this timestamp will be returned (optional)
     * @param  string $where Filter by an any element (optional)
     * @param  string $order Order by an any element (optional)
     * @param  int $page e.g. page&#x3D;1 – Up to 100 PayRuns will be returned in a single API call (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getPayRunsAsync($xero_tenant_id, $if_modified_since = null, $where = null, $order = null, $page = null)
    {
        return $this->getPayRunsAsyncWithHttpInfo($xero_tenant_id, $if_modified_since, $where, $order, $page)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getPayRunsAsyncWithHttpInfo
     * Retrieves pay runs
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $if_modified_since Only records created or modified since this timestamp will be returned (optional)
     * @param  string $where Filter by an any element (optional)
     * @param  string $order Order by an any element (optional)
     * @param  int $page e.g. page&#x3D;1 – Up to 100 PayRuns will be returned in a single API call (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getPayRunsAsyncWithHttpInfo($xero_tenant_id, $if_modified_since = null, $where = null, $order = null, $page = null)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollAu\PayRuns';
        $request = $this->getPayRunsRequest($xero_tenant_id, $if_modified_since, $where, $order, $page);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollAuObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getPayRuns'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $if_modified_since Only records created or modified since this timestamp will be returned (optional)
     * @param  string $where Filter by an any element (optional)
     * @param  string $order Order by an any element (optional)
     * @param  int $page e.g. page&#x3D;1 – Up to 100 PayRuns will be returned in a single API call (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getPayRunsRequest($xero_tenant_id, $if_modified_since = null, $where = null, $order = null, $page = null)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getPayRuns'
            );
        }
        $resourcePath = '/PayRuns';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // query params
        if ($where !== null) {
            $queryParams['where'] = PayrollAuObjectSerializer::toQueryValue($where);
        }
        // query params
        if ($order !== null) {
            $queryParams['order'] = PayrollAuObjectSerializer::toQueryValue($order);
        }
        // query params
        if ($page !== null) {
            $queryParams['page'] = PayrollAuObjectSerializer::toQueryValue($page);
        }
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollAuObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // header params
        if ($if_modified_since !== null) {
            $headerParams['If-Modified-Since'] = PayrollAuObjectSerializer::toHeaderValue($if_modified_since);
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollAuObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHostPayrollAu() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getPayrollCalendar
     * Retrieves payroll calendar by using a unique payroll calendar ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $payroll_calendar_id Payroll Calendar id for single object (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollAu\PayrollCalendars|\XeroAPI\XeroPHP\Models\PayrollAu\APIException
     */
    public function getPayrollCalendar($xero_tenant_id, $payroll_calendar_id)
    {
        list($response) = $this->getPayrollCalendarWithHttpInfo($xero_tenant_id, $payroll_calendar_id);
        return $response;
    }
    /**
     * Operation getPayrollCalendarWithHttpInfo
     * Retrieves payroll calendar by using a unique payroll calendar ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $payroll_calendar_id Payroll Calendar id for single object (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollAu\PayrollCalendars|\XeroAPI\XeroPHP\Models\PayrollAu\APIException, HTTP status code, HTTP response headers (array of strings)
     */
    public function getPayrollCalendarWithHttpInfo($xero_tenant_id, $payroll_calendar_id)
    {
        $request = $this->getPayrollCalendarRequest($xero_tenant_id, $payroll_calendar_id);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollAu\PayrollCalendars' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollAuObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollAu\PayrollCalendars', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\XeroAPI\XeroPHP\Models\PayrollAu\APIException' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollAuObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollAu\APIException', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollAu\PayrollCalendars';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollAuObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollAuObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollAu\PayrollCalendars',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = PayrollAuObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollAu\APIException',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getPayrollCalendarAsync
     * Retrieves payroll calendar by using a unique payroll calendar ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $payroll_calendar_id Payroll Calendar id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getPayrollCalendarAsync($xero_tenant_id, $payroll_calendar_id)
    {
        return $this->getPayrollCalendarAsyncWithHttpInfo($xero_tenant_id, $payroll_calendar_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getPayrollCalendarAsyncWithHttpInfo
     * Retrieves payroll calendar by using a unique payroll calendar ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $payroll_calendar_id Payroll Calendar id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getPayrollCalendarAsyncWithHttpInfo($xero_tenant_id, $payroll_calendar_id)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollAu\PayrollCalendars';
        $request = $this->getPayrollCalendarRequest($xero_tenant_id, $payroll_calendar_id);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollAuObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getPayrollCalendar'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $payroll_calendar_id Payroll Calendar id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getPayrollCalendarRequest($xero_tenant_id, $payroll_calendar_id)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getPayrollCalendar'
            );
        }
        // verify the required parameter 'payroll_calendar_id' is set
        if ($payroll_calendar_id === null || (is_array($payroll_calendar_id) && count($payroll_calendar_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $payroll_calendar_id when calling getPayrollCalendar'
            );
        }
        $resourcePath = '/PayrollCalendars/{PayrollCalendarID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollAuObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // path params
        if ($payroll_calendar_id !== null) {
            $resourcePath = str_replace(
                '{' . 'PayrollCalendarID' . '}',
                PayrollAuObjectSerializer::toPathValue($payroll_calendar_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollAuObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHostPayrollAu() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getPayrollCalendars
     * Retrieves payroll calendars
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $if_modified_since Only records created or modified since this timestamp will be returned (optional)
     * @param  string $where Filter by an any element (optional)
     * @param  string $order Order by an any element (optional)
     * @param  int $page e.g. page&#x3D;1 – Up to 100 objects will be returned in a single API call (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollAu\PayrollCalendars|\XeroAPI\XeroPHP\Models\PayrollAu\APIException
     */
    public function getPayrollCalendars($xero_tenant_id, $if_modified_since = null, $where = null, $order = null, $page = null)
    {
        list($response) = $this->getPayrollCalendarsWithHttpInfo($xero_tenant_id, $if_modified_since, $where, $order, $page);
        return $response;
    }
    /**
     * Operation getPayrollCalendarsWithHttpInfo
     * Retrieves payroll calendars
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $if_modified_since Only records created or modified since this timestamp will be returned (optional)
     * @param  string $where Filter by an any element (optional)
     * @param  string $order Order by an any element (optional)
     * @param  int $page e.g. page&#x3D;1 – Up to 100 objects will be returned in a single API call (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollAu\PayrollCalendars|\XeroAPI\XeroPHP\Models\PayrollAu\APIException, HTTP status code, HTTP response headers (array of strings)
     */
    public function getPayrollCalendarsWithHttpInfo($xero_tenant_id, $if_modified_since = null, $where = null, $order = null, $page = null)
    {
        $request = $this->getPayrollCalendarsRequest($xero_tenant_id, $if_modified_since, $where, $order, $page);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollAu\PayrollCalendars' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollAuObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollAu\PayrollCalendars', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\XeroAPI\XeroPHP\Models\PayrollAu\APIException' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollAuObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollAu\APIException', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollAu\PayrollCalendars';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollAuObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollAuObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollAu\PayrollCalendars',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = PayrollAuObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollAu\APIException',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getPayrollCalendarsAsync
     * Retrieves payroll calendars
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $if_modified_since Only records created or modified since this timestamp will be returned (optional)
     * @param  string $where Filter by an any element (optional)
     * @param  string $order Order by an any element (optional)
     * @param  int $page e.g. page&#x3D;1 – Up to 100 objects will be returned in a single API call (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getPayrollCalendarsAsync($xero_tenant_id, $if_modified_since = null, $where = null, $order = null, $page = null)
    {
        return $this->getPayrollCalendarsAsyncWithHttpInfo($xero_tenant_id, $if_modified_since, $where, $order, $page)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getPayrollCalendarsAsyncWithHttpInfo
     * Retrieves payroll calendars
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $if_modified_since Only records created or modified since this timestamp will be returned (optional)
     * @param  string $where Filter by an any element (optional)
     * @param  string $order Order by an any element (optional)
     * @param  int $page e.g. page&#x3D;1 – Up to 100 objects will be returned in a single API call (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getPayrollCalendarsAsyncWithHttpInfo($xero_tenant_id, $if_modified_since = null, $where = null, $order = null, $page = null)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollAu\PayrollCalendars';
        $request = $this->getPayrollCalendarsRequest($xero_tenant_id, $if_modified_since, $where, $order, $page);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollAuObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getPayrollCalendars'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $if_modified_since Only records created or modified since this timestamp will be returned (optional)
     * @param  string $where Filter by an any element (optional)
     * @param  string $order Order by an any element (optional)
     * @param  int $page e.g. page&#x3D;1 – Up to 100 objects will be returned in a single API call (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getPayrollCalendarsRequest($xero_tenant_id, $if_modified_since = null, $where = null, $order = null, $page = null)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getPayrollCalendars'
            );
        }
        $resourcePath = '/PayrollCalendars';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // query params
        if ($where !== null) {
            $queryParams['where'] = PayrollAuObjectSerializer::toQueryValue($where);
        }
        // query params
        if ($order !== null) {
            $queryParams['order'] = PayrollAuObjectSerializer::toQueryValue($order);
        }
        // query params
        if ($page !== null) {
            $queryParams['page'] = PayrollAuObjectSerializer::toQueryValue($page);
        }
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollAuObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // header params
        if ($if_modified_since !== null) {
            $headerParams['If-Modified-Since'] = PayrollAuObjectSerializer::toHeaderValue($if_modified_since);
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollAuObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHostPayrollAu() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getPayslip
     * Retrieves for a payslip by a unique payslip id
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $payslip_id Payslip id for single object (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollAu\PayslipObject
     */
    public function getPayslip($xero_tenant_id, $payslip_id)
    {
        list($response) = $this->getPayslipWithHttpInfo($xero_tenant_id, $payslip_id);
        return $response;
    }
    /**
     * Operation getPayslipWithHttpInfo
     * Retrieves for a payslip by a unique payslip id
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $payslip_id Payslip id for single object (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollAu\PayslipObject, HTTP status code, HTTP response headers (array of strings)
     */
    public function getPayslipWithHttpInfo($xero_tenant_id, $payslip_id)
    {
        $request = $this->getPayslipRequest($xero_tenant_id, $payslip_id);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollAu\PayslipObject' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollAuObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollAu\PayslipObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollAu\PayslipObject';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollAuObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollAuObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollAu\PayslipObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getPayslipAsync
     * Retrieves for a payslip by a unique payslip id
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $payslip_id Payslip id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getPayslipAsync($xero_tenant_id, $payslip_id)
    {
        return $this->getPayslipAsyncWithHttpInfo($xero_tenant_id, $payslip_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getPayslipAsyncWithHttpInfo
     * Retrieves for a payslip by a unique payslip id
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $payslip_id Payslip id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getPayslipAsyncWithHttpInfo($xero_tenant_id, $payslip_id)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollAu\PayslipObject';
        $request = $this->getPayslipRequest($xero_tenant_id, $payslip_id);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollAuObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getPayslip'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $payslip_id Payslip id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getPayslipRequest($xero_tenant_id, $payslip_id)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getPayslip'
            );
        }
        // verify the required parameter 'payslip_id' is set
        if ($payslip_id === null || (is_array($payslip_id) && count($payslip_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $payslip_id when calling getPayslip'
            );
        }
        $resourcePath = '/Payslip/{PayslipID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollAuObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // path params
        if ($payslip_id !== null) {
            $resourcePath = str_replace(
                '{' . 'PayslipID' . '}',
                PayrollAuObjectSerializer::toPathValue($payslip_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollAuObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHostPayrollAu() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getSettings
     * Retrieves payroll settings
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollAu\SettingsObject
     */
    public function getSettings($xero_tenant_id)
    {
        list($response) = $this->getSettingsWithHttpInfo($xero_tenant_id);
        return $response;
    }
    /**
     * Operation getSettingsWithHttpInfo
     * Retrieves payroll settings
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollAu\SettingsObject, HTTP status code, HTTP response headers (array of strings)
     */
    public function getSettingsWithHttpInfo($xero_tenant_id)
    {
        $request = $this->getSettingsRequest($xero_tenant_id);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollAu\SettingsObject' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollAuObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollAu\SettingsObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollAu\SettingsObject';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollAuObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollAuObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollAu\SettingsObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getSettingsAsync
     * Retrieves payroll settings
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSettingsAsync($xero_tenant_id)
    {
        return $this->getSettingsAsyncWithHttpInfo($xero_tenant_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getSettingsAsyncWithHttpInfo
     * Retrieves payroll settings
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getSettingsAsyncWithHttpInfo($xero_tenant_id)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollAu\SettingsObject';
        $request = $this->getSettingsRequest($xero_tenant_id);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollAuObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getSettings'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getSettingsRequest($xero_tenant_id)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getSettings'
            );
        }
        $resourcePath = '/Settings';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollAuObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollAuObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHostPayrollAu() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getSuperfund
     * Retrieves a superfund by using a unique superfund ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $super_fund_id Superfund id for single object (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollAu\SuperFunds
     */
    public function getSuperfund($xero_tenant_id, $super_fund_id)
    {
        list($response) = $this->getSuperfundWithHttpInfo($xero_tenant_id, $super_fund_id);
        return $response;
    }
    /**
     * Operation getSuperfundWithHttpInfo
     * Retrieves a superfund by using a unique superfund ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $super_fund_id Superfund id for single object (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollAu\SuperFunds, HTTP status code, HTTP response headers (array of strings)
     */
    public function getSuperfundWithHttpInfo($xero_tenant_id, $super_fund_id)
    {
        $request = $this->getSuperfundRequest($xero_tenant_id, $super_fund_id);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollAu\SuperFunds' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollAuObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollAu\SuperFunds', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollAu\SuperFunds';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollAuObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollAuObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollAu\SuperFunds',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getSuperfundAsync
     * Retrieves a superfund by using a unique superfund ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $super_fund_id Superfund id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSuperfundAsync($xero_tenant_id, $super_fund_id)
    {
        return $this->getSuperfundAsyncWithHttpInfo($xero_tenant_id, $super_fund_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getSuperfundAsyncWithHttpInfo
     * Retrieves a superfund by using a unique superfund ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $super_fund_id Superfund id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getSuperfundAsyncWithHttpInfo($xero_tenant_id, $super_fund_id)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollAu\SuperFunds';
        $request = $this->getSuperfundRequest($xero_tenant_id, $super_fund_id);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollAuObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getSuperfund'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $super_fund_id Superfund id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getSuperfundRequest($xero_tenant_id, $super_fund_id)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getSuperfund'
            );
        }
        // verify the required parameter 'super_fund_id' is set
        if ($super_fund_id === null || (is_array($super_fund_id) && count($super_fund_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $super_fund_id when calling getSuperfund'
            );
        }
        $resourcePath = '/Superfunds/{SuperFundID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollAuObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // path params
        if ($super_fund_id !== null) {
            $resourcePath = str_replace(
                '{' . 'SuperFundID' . '}',
                PayrollAuObjectSerializer::toPathValue($super_fund_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollAuObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHostPayrollAu() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getSuperfundProducts
     * Retrieves superfund products
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $abn The ABN of the Regulated SuperFund (optional)
     * @param  string $usi The USI of the Regulated SuperFund (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollAu\SuperFundProducts|\XeroAPI\XeroPHP\Models\PayrollAu\APIException
     */
    public function getSuperfundProducts($xero_tenant_id, $abn = null, $usi = null)
    {
        list($response) = $this->getSuperfundProductsWithHttpInfo($xero_tenant_id, $abn, $usi);
        return $response;
    }
    /**
     * Operation getSuperfundProductsWithHttpInfo
     * Retrieves superfund products
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $abn The ABN of the Regulated SuperFund (optional)
     * @param  string $usi The USI of the Regulated SuperFund (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollAu\SuperFundProducts|\XeroAPI\XeroPHP\Models\PayrollAu\APIException, HTTP status code, HTTP response headers (array of strings)
     */
    public function getSuperfundProductsWithHttpInfo($xero_tenant_id, $abn = null, $usi = null)
    {
        $request = $this->getSuperfundProductsRequest($xero_tenant_id, $abn, $usi);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollAu\SuperFundProducts' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollAuObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollAu\SuperFundProducts', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\XeroAPI\XeroPHP\Models\PayrollAu\APIException' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollAuObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollAu\APIException', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollAu\SuperFundProducts';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollAuObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollAuObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollAu\SuperFundProducts',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = PayrollAuObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollAu\APIException',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getSuperfundProductsAsync
     * Retrieves superfund products
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $abn The ABN of the Regulated SuperFund (optional)
     * @param  string $usi The USI of the Regulated SuperFund (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSuperfundProductsAsync($xero_tenant_id, $abn = null, $usi = null)
    {
        return $this->getSuperfundProductsAsyncWithHttpInfo($xero_tenant_id, $abn, $usi)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getSuperfundProductsAsyncWithHttpInfo
     * Retrieves superfund products
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $abn The ABN of the Regulated SuperFund (optional)
     * @param  string $usi The USI of the Regulated SuperFund (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getSuperfundProductsAsyncWithHttpInfo($xero_tenant_id, $abn = null, $usi = null)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollAu\SuperFundProducts';
        $request = $this->getSuperfundProductsRequest($xero_tenant_id, $abn, $usi);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollAuObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getSuperfundProducts'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $abn The ABN of the Regulated SuperFund (optional)
     * @param  string $usi The USI of the Regulated SuperFund (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getSuperfundProductsRequest($xero_tenant_id, $abn = null, $usi = null)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getSuperfundProducts'
            );
        }
        $resourcePath = '/SuperfundProducts';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // query params
        if ($abn !== null) {
            $queryParams['ABN'] = PayrollAuObjectSerializer::toQueryValue($abn);
        }
        // query params
        if ($usi !== null) {
            $queryParams['USI'] = PayrollAuObjectSerializer::toQueryValue($usi);
        }
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollAuObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollAuObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHostPayrollAu() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getSuperfunds
     * Retrieves superfunds
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $if_modified_since Only records created or modified since this timestamp will be returned (optional)
     * @param  string $where Filter by an any element (optional)
     * @param  string $order Order by an any element (optional)
     * @param  int $page e.g. page&#x3D;1 – Up to 100 SuperFunds will be returned in a single API call (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollAu\SuperFunds|\XeroAPI\XeroPHP\Models\PayrollAu\APIException
     */
    public function getSuperfunds($xero_tenant_id, $if_modified_since = null, $where = null, $order = null, $page = null)
    {
        list($response) = $this->getSuperfundsWithHttpInfo($xero_tenant_id, $if_modified_since, $where, $order, $page);
        return $response;
    }
    /**
     * Operation getSuperfundsWithHttpInfo
     * Retrieves superfunds
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $if_modified_since Only records created or modified since this timestamp will be returned (optional)
     * @param  string $where Filter by an any element (optional)
     * @param  string $order Order by an any element (optional)
     * @param  int $page e.g. page&#x3D;1 – Up to 100 SuperFunds will be returned in a single API call (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollAu\SuperFunds|\XeroAPI\XeroPHP\Models\PayrollAu\APIException, HTTP status code, HTTP response headers (array of strings)
     */
    public function getSuperfundsWithHttpInfo($xero_tenant_id, $if_modified_since = null, $where = null, $order = null, $page = null)
    {
        $request = $this->getSuperfundsRequest($xero_tenant_id, $if_modified_since, $where, $order, $page);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollAu\SuperFunds' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollAuObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollAu\SuperFunds', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\XeroAPI\XeroPHP\Models\PayrollAu\APIException' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollAuObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollAu\APIException', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollAu\SuperFunds';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollAuObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollAuObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollAu\SuperFunds',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = PayrollAuObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollAu\APIException',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getSuperfundsAsync
     * Retrieves superfunds
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $if_modified_since Only records created or modified since this timestamp will be returned (optional)
     * @param  string $where Filter by an any element (optional)
     * @param  string $order Order by an any element (optional)
     * @param  int $page e.g. page&#x3D;1 – Up to 100 SuperFunds will be returned in a single API call (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSuperfundsAsync($xero_tenant_id, $if_modified_since = null, $where = null, $order = null, $page = null)
    {
        return $this->getSuperfundsAsyncWithHttpInfo($xero_tenant_id, $if_modified_since, $where, $order, $page)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getSuperfundsAsyncWithHttpInfo
     * Retrieves superfunds
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $if_modified_since Only records created or modified since this timestamp will be returned (optional)
     * @param  string $where Filter by an any element (optional)
     * @param  string $order Order by an any element (optional)
     * @param  int $page e.g. page&#x3D;1 – Up to 100 SuperFunds will be returned in a single API call (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getSuperfundsAsyncWithHttpInfo($xero_tenant_id, $if_modified_since = null, $where = null, $order = null, $page = null)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollAu\SuperFunds';
        $request = $this->getSuperfundsRequest($xero_tenant_id, $if_modified_since, $where, $order, $page);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollAuObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getSuperfunds'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $if_modified_since Only records created or modified since this timestamp will be returned (optional)
     * @param  string $where Filter by an any element (optional)
     * @param  string $order Order by an any element (optional)
     * @param  int $page e.g. page&#x3D;1 – Up to 100 SuperFunds will be returned in a single API call (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getSuperfundsRequest($xero_tenant_id, $if_modified_since = null, $where = null, $order = null, $page = null)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getSuperfunds'
            );
        }
        $resourcePath = '/Superfunds';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // query params
        if ($where !== null) {
            $queryParams['where'] = PayrollAuObjectSerializer::toQueryValue($where);
        }
        // query params
        if ($order !== null) {
            $queryParams['order'] = PayrollAuObjectSerializer::toQueryValue($order);
        }
        // query params
        if ($page !== null) {
            $queryParams['page'] = PayrollAuObjectSerializer::toQueryValue($page);
        }
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollAuObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // header params
        if ($if_modified_since !== null) {
            $headerParams['If-Modified-Since'] = PayrollAuObjectSerializer::toHeaderValue($if_modified_since);
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollAuObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHostPayrollAu() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getTimesheet
     * Retrieves a timesheet by using a unique timesheet id
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $timesheet_id Timesheet id for single object (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollAu\TimesheetObject
     */
    public function getTimesheet($xero_tenant_id, $timesheet_id)
    {
        list($response) = $this->getTimesheetWithHttpInfo($xero_tenant_id, $timesheet_id);
        return $response;
    }
    /**
     * Operation getTimesheetWithHttpInfo
     * Retrieves a timesheet by using a unique timesheet id
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $timesheet_id Timesheet id for single object (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollAu\TimesheetObject, HTTP status code, HTTP response headers (array of strings)
     */
    public function getTimesheetWithHttpInfo($xero_tenant_id, $timesheet_id)
    {
        $request = $this->getTimesheetRequest($xero_tenant_id, $timesheet_id);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollAu\TimesheetObject' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollAuObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollAu\TimesheetObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollAu\TimesheetObject';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollAuObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollAuObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollAu\TimesheetObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getTimesheetAsync
     * Retrieves a timesheet by using a unique timesheet id
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $timesheet_id Timesheet id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getTimesheetAsync($xero_tenant_id, $timesheet_id)
    {
        return $this->getTimesheetAsyncWithHttpInfo($xero_tenant_id, $timesheet_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getTimesheetAsyncWithHttpInfo
     * Retrieves a timesheet by using a unique timesheet id
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $timesheet_id Timesheet id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getTimesheetAsyncWithHttpInfo($xero_tenant_id, $timesheet_id)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollAu\TimesheetObject';
        $request = $this->getTimesheetRequest($xero_tenant_id, $timesheet_id);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollAuObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getTimesheet'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $timesheet_id Timesheet id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getTimesheetRequest($xero_tenant_id, $timesheet_id)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getTimesheet'
            );
        }
        // verify the required parameter 'timesheet_id' is set
        if ($timesheet_id === null || (is_array($timesheet_id) && count($timesheet_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $timesheet_id when calling getTimesheet'
            );
        }
        $resourcePath = '/Timesheets/{TimesheetID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollAuObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // path params
        if ($timesheet_id !== null) {
            $resourcePath = str_replace(
                '{' . 'TimesheetID' . '}',
                PayrollAuObjectSerializer::toPathValue($timesheet_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollAuObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHostPayrollAu() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getTimesheets
     * Retrieves timesheets
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $if_modified_since Only records created or modified since this timestamp will be returned (optional)
     * @param  string $where Filter by an any element (optional)
     * @param  string $order Order by an any element (optional)
     * @param  int $page e.g. page&#x3D;1 – Up to 100 timesheets will be returned in a single API call (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollAu\Timesheets|\XeroAPI\XeroPHP\Models\PayrollAu\APIException
     */
    public function getTimesheets($xero_tenant_id, $if_modified_since = null, $where = null, $order = null, $page = null)
    {
        list($response) = $this->getTimesheetsWithHttpInfo($xero_tenant_id, $if_modified_since, $where, $order, $page);
        return $response;
    }
    /**
     * Operation getTimesheetsWithHttpInfo
     * Retrieves timesheets
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $if_modified_since Only records created or modified since this timestamp will be returned (optional)
     * @param  string $where Filter by an any element (optional)
     * @param  string $order Order by an any element (optional)
     * @param  int $page e.g. page&#x3D;1 – Up to 100 timesheets will be returned in a single API call (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollAu\Timesheets|\XeroAPI\XeroPHP\Models\PayrollAu\APIException, HTTP status code, HTTP response headers (array of strings)
     */
    public function getTimesheetsWithHttpInfo($xero_tenant_id, $if_modified_since = null, $where = null, $order = null, $page = null)
    {
        $request = $this->getTimesheetsRequest($xero_tenant_id, $if_modified_since, $where, $order, $page);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollAu\Timesheets' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollAuObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollAu\Timesheets', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\XeroAPI\XeroPHP\Models\PayrollAu\APIException' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollAuObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollAu\APIException', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollAu\Timesheets';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollAuObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollAuObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollAu\Timesheets',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = PayrollAuObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollAu\APIException',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getTimesheetsAsync
     * Retrieves timesheets
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $if_modified_since Only records created or modified since this timestamp will be returned (optional)
     * @param  string $where Filter by an any element (optional)
     * @param  string $order Order by an any element (optional)
     * @param  int $page e.g. page&#x3D;1 – Up to 100 timesheets will be returned in a single API call (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getTimesheetsAsync($xero_tenant_id, $if_modified_since = null, $where = null, $order = null, $page = null)
    {
        return $this->getTimesheetsAsyncWithHttpInfo($xero_tenant_id, $if_modified_since, $where, $order, $page)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getTimesheetsAsyncWithHttpInfo
     * Retrieves timesheets
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $if_modified_since Only records created or modified since this timestamp will be returned (optional)
     * @param  string $where Filter by an any element (optional)
     * @param  string $order Order by an any element (optional)
     * @param  int $page e.g. page&#x3D;1 – Up to 100 timesheets will be returned in a single API call (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getTimesheetsAsyncWithHttpInfo($xero_tenant_id, $if_modified_since = null, $where = null, $order = null, $page = null)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollAu\Timesheets';
        $request = $this->getTimesheetsRequest($xero_tenant_id, $if_modified_since, $where, $order, $page);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollAuObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getTimesheets'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $if_modified_since Only records created or modified since this timestamp will be returned (optional)
     * @param  string $where Filter by an any element (optional)
     * @param  string $order Order by an any element (optional)
     * @param  int $page e.g. page&#x3D;1 – Up to 100 timesheets will be returned in a single API call (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getTimesheetsRequest($xero_tenant_id, $if_modified_since = null, $where = null, $order = null, $page = null)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getTimesheets'
            );
        }
        $resourcePath = '/Timesheets';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // query params
        if ($where !== null) {
            $queryParams['where'] = PayrollAuObjectSerializer::toQueryValue($where);
        }
        // query params
        if ($order !== null) {
            $queryParams['order'] = PayrollAuObjectSerializer::toQueryValue($order);
        }
        // query params
        if ($page !== null) {
            $queryParams['page'] = PayrollAuObjectSerializer::toQueryValue($page);
        }
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollAuObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // header params
        if ($if_modified_since !== null) {
            $headerParams['If-Modified-Since'] = PayrollAuObjectSerializer::toHeaderValue($if_modified_since);
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollAuObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHostPayrollAu() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateEmployee
     * Updates an employee's detail
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollAu\Employee[] $employee employee (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollAu\Employees
     */
    public function updateEmployee($xero_tenant_id, $employee_id, $employee = null)
    {
        list($response) = $this->updateEmployeeWithHttpInfo($xero_tenant_id, $employee_id, $employee);
        return $response;
    }
    /**
     * Operation updateEmployeeWithHttpInfo
     * Updates an employee's detail
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollAu\Employee[] $employee (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollAu\Employees, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateEmployeeWithHttpInfo($xero_tenant_id, $employee_id, $employee = null)
    {
        $request = $this->updateEmployeeRequest($xero_tenant_id, $employee_id, $employee);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollAu\Employees' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollAuObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollAu\Employees', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollAu\Employees';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollAuObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollAuObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollAu\Employees',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation updateEmployeeAsync
     * Updates an employee's detail
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollAu\Employee[] $employee (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateEmployeeAsync($xero_tenant_id, $employee_id, $employee = null)
    {
        return $this->updateEmployeeAsyncWithHttpInfo($xero_tenant_id, $employee_id, $employee)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation updateEmployeeAsyncWithHttpInfo
     * Updates an employee's detail
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollAu\Employee[] $employee (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function updateEmployeeAsyncWithHttpInfo($xero_tenant_id, $employee_id, $employee = null)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollAu\Employees';
        $request = $this->updateEmployeeRequest($xero_tenant_id, $employee_id, $employee);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollAuObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateEmployee'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollAu\Employee[] $employee (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function updateEmployeeRequest($xero_tenant_id, $employee_id, $employee = null)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling updateEmployee'
            );
        }
        // verify the required parameter 'employee_id' is set
        if ($employee_id === null || (is_array($employee_id) && count($employee_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $employee_id when calling updateEmployee'
            );
        }
        $resourcePath = '/Employees/{EmployeeID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollAuObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // path params
        if ($employee_id !== null) {
            $resourcePath = str_replace(
                '{' . 'EmployeeID' . '}',
                PayrollAuObjectSerializer::toPathValue($employee_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if (isset($employee)) {
            $_tempBody = $employee;
        }
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollAuObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'POST',
            $this->config->getHostPayrollAu() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateLeaveApplication
     * Updates a specific leave application
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $leave_application_id Leave Application id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollAu\LeaveApplication[] $leave_application leave_application (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollAu\LeaveApplications
     */
    public function updateLeaveApplication($xero_tenant_id, $leave_application_id, $leave_application)
    {
        list($response) = $this->updateLeaveApplicationWithHttpInfo($xero_tenant_id, $leave_application_id, $leave_application);
        return $response;
    }
    /**
     * Operation updateLeaveApplicationWithHttpInfo
     * Updates a specific leave application
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $leave_application_id Leave Application id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollAu\LeaveApplication[] $leave_application (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollAu\LeaveApplications, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateLeaveApplicationWithHttpInfo($xero_tenant_id, $leave_application_id, $leave_application)
    {
        $request = $this->updateLeaveApplicationRequest($xero_tenant_id, $leave_application_id, $leave_application);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollAu\LeaveApplications' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollAuObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollAu\LeaveApplications', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollAu\LeaveApplications';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollAuObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollAuObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollAu\LeaveApplications',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation updateLeaveApplicationAsync
     * Updates a specific leave application
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $leave_application_id Leave Application id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollAu\LeaveApplication[] $leave_application (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateLeaveApplicationAsync($xero_tenant_id, $leave_application_id, $leave_application)
    {
        return $this->updateLeaveApplicationAsyncWithHttpInfo($xero_tenant_id, $leave_application_id, $leave_application)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation updateLeaveApplicationAsyncWithHttpInfo
     * Updates a specific leave application
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $leave_application_id Leave Application id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollAu\LeaveApplication[] $leave_application (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function updateLeaveApplicationAsyncWithHttpInfo($xero_tenant_id, $leave_application_id, $leave_application)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollAu\LeaveApplications';
        $request = $this->updateLeaveApplicationRequest($xero_tenant_id, $leave_application_id, $leave_application);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollAuObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateLeaveApplication'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $leave_application_id Leave Application id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollAu\LeaveApplication[] $leave_application (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function updateLeaveApplicationRequest($xero_tenant_id, $leave_application_id, $leave_application)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling updateLeaveApplication'
            );
        }
        // verify the required parameter 'leave_application_id' is set
        if ($leave_application_id === null || (is_array($leave_application_id) && count($leave_application_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $leave_application_id when calling updateLeaveApplication'
            );
        }
        // verify the required parameter 'leave_application' is set
        if ($leave_application === null || (is_array($leave_application) && count($leave_application) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $leave_application when calling updateLeaveApplication'
            );
        }
        $resourcePath = '/LeaveApplications/{LeaveApplicationID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollAuObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // path params
        if ($leave_application_id !== null) {
            $resourcePath = str_replace(
                '{' . 'LeaveApplicationID' . '}',
                PayrollAuObjectSerializer::toPathValue($leave_application_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if (isset($leave_application)) {
            $_tempBody = $leave_application;
        }
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollAuObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'POST',
            $this->config->getHostPayrollAu() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updatePayRun
     * Updates a pay run
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $pay_run_id PayRun id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollAu\PayRun[] $pay_run pay_run (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollAu\PayRuns
     */
    public function updatePayRun($xero_tenant_id, $pay_run_id, $pay_run = null)
    {
        list($response) = $this->updatePayRunWithHttpInfo($xero_tenant_id, $pay_run_id, $pay_run);
        return $response;
    }
    /**
     * Operation updatePayRunWithHttpInfo
     * Updates a pay run
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $pay_run_id PayRun id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollAu\PayRun[] $pay_run (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollAu\PayRuns, HTTP status code, HTTP response headers (array of strings)
     */
    public function updatePayRunWithHttpInfo($xero_tenant_id, $pay_run_id, $pay_run = null)
    {
        $request = $this->updatePayRunRequest($xero_tenant_id, $pay_run_id, $pay_run);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollAu\PayRuns' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollAuObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollAu\PayRuns', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollAu\PayRuns';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollAuObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollAuObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollAu\PayRuns',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation updatePayRunAsync
     * Updates a pay run
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $pay_run_id PayRun id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollAu\PayRun[] $pay_run (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updatePayRunAsync($xero_tenant_id, $pay_run_id, $pay_run = null)
    {
        return $this->updatePayRunAsyncWithHttpInfo($xero_tenant_id, $pay_run_id, $pay_run)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation updatePayRunAsyncWithHttpInfo
     * Updates a pay run
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $pay_run_id PayRun id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollAu\PayRun[] $pay_run (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function updatePayRunAsyncWithHttpInfo($xero_tenant_id, $pay_run_id, $pay_run = null)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollAu\PayRuns';
        $request = $this->updatePayRunRequest($xero_tenant_id, $pay_run_id, $pay_run);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollAuObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updatePayRun'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $pay_run_id PayRun id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollAu\PayRun[] $pay_run (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function updatePayRunRequest($xero_tenant_id, $pay_run_id, $pay_run = null)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling updatePayRun'
            );
        }
        // verify the required parameter 'pay_run_id' is set
        if ($pay_run_id === null || (is_array($pay_run_id) && count($pay_run_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $pay_run_id when calling updatePayRun'
            );
        }
        $resourcePath = '/PayRuns/{PayRunID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollAuObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // path params
        if ($pay_run_id !== null) {
            $resourcePath = str_replace(
                '{' . 'PayRunID' . '}',
                PayrollAuObjectSerializer::toPathValue($pay_run_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if (isset($pay_run)) {
            $_tempBody = $pay_run;
        }
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollAuObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'POST',
            $this->config->getHostPayrollAu() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updatePayslip
     * Updates a payslip
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $payslip_id Payslip id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollAu\PayslipLines[] $payslip_lines payslip_lines (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollAu\Payslips
     */
    public function updatePayslip($xero_tenant_id, $payslip_id, $payslip_lines = null)
    {
        list($response) = $this->updatePayslipWithHttpInfo($xero_tenant_id, $payslip_id, $payslip_lines);
        return $response;
    }
    /**
     * Operation updatePayslipWithHttpInfo
     * Updates a payslip
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $payslip_id Payslip id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollAu\PayslipLines[] $payslip_lines (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollAu\Payslips, HTTP status code, HTTP response headers (array of strings)
     */
    public function updatePayslipWithHttpInfo($xero_tenant_id, $payslip_id, $payslip_lines = null)
    {
        $request = $this->updatePayslipRequest($xero_tenant_id, $payslip_id, $payslip_lines);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollAu\Payslips' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollAuObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollAu\Payslips', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollAu\Payslips';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollAuObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollAuObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollAu\Payslips',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation updatePayslipAsync
     * Updates a payslip
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $payslip_id Payslip id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollAu\PayslipLines[] $payslip_lines (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updatePayslipAsync($xero_tenant_id, $payslip_id, $payslip_lines = null)
    {
        return $this->updatePayslipAsyncWithHttpInfo($xero_tenant_id, $payslip_id, $payslip_lines)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation updatePayslipAsyncWithHttpInfo
     * Updates a payslip
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $payslip_id Payslip id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollAu\PayslipLines[] $payslip_lines (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function updatePayslipAsyncWithHttpInfo($xero_tenant_id, $payslip_id, $payslip_lines = null)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollAu\Payslips';
        $request = $this->updatePayslipRequest($xero_tenant_id, $payslip_id, $payslip_lines);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollAuObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updatePayslip'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $payslip_id Payslip id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollAu\PayslipLines[] $payslip_lines (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function updatePayslipRequest($xero_tenant_id, $payslip_id, $payslip_lines = null)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling updatePayslip'
            );
        }
        // verify the required parameter 'payslip_id' is set
        if ($payslip_id === null || (is_array($payslip_id) && count($payslip_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $payslip_id when calling updatePayslip'
            );
        }
        $resourcePath = '/Payslip/{PayslipID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollAuObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // path params
        if ($payslip_id !== null) {
            $resourcePath = str_replace(
                '{' . 'PayslipID' . '}',
                PayrollAuObjectSerializer::toPathValue($payslip_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if (isset($payslip_lines)) {
            $_tempBody = $payslip_lines;
        }
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollAuObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'POST',
            $this->config->getHostPayrollAu() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateSuperfund
     * Updates a superfund
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $super_fund_id Superfund id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollAu\SuperFund[] $super_fund super_fund (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollAu\SuperFunds
     */
    public function updateSuperfund($xero_tenant_id, $super_fund_id, $super_fund = null)
    {
        list($response) = $this->updateSuperfundWithHttpInfo($xero_tenant_id, $super_fund_id, $super_fund);
        return $response;
    }
    /**
     * Operation updateSuperfundWithHttpInfo
     * Updates a superfund
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $super_fund_id Superfund id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollAu\SuperFund[] $super_fund (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollAu\SuperFunds, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateSuperfundWithHttpInfo($xero_tenant_id, $super_fund_id, $super_fund = null)
    {
        $request = $this->updateSuperfundRequest($xero_tenant_id, $super_fund_id, $super_fund);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollAu\SuperFunds' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollAuObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollAu\SuperFunds', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollAu\SuperFunds';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollAuObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollAuObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollAu\SuperFunds',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation updateSuperfundAsync
     * Updates a superfund
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $super_fund_id Superfund id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollAu\SuperFund[] $super_fund (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateSuperfundAsync($xero_tenant_id, $super_fund_id, $super_fund = null)
    {
        return $this->updateSuperfundAsyncWithHttpInfo($xero_tenant_id, $super_fund_id, $super_fund)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation updateSuperfundAsyncWithHttpInfo
     * Updates a superfund
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $super_fund_id Superfund id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollAu\SuperFund[] $super_fund (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function updateSuperfundAsyncWithHttpInfo($xero_tenant_id, $super_fund_id, $super_fund = null)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollAu\SuperFunds';
        $request = $this->updateSuperfundRequest($xero_tenant_id, $super_fund_id, $super_fund);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollAuObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateSuperfund'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $super_fund_id Superfund id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollAu\SuperFund[] $super_fund (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function updateSuperfundRequest($xero_tenant_id, $super_fund_id, $super_fund = null)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling updateSuperfund'
            );
        }
        // verify the required parameter 'super_fund_id' is set
        if ($super_fund_id === null || (is_array($super_fund_id) && count($super_fund_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $super_fund_id when calling updateSuperfund'
            );
        }
        $resourcePath = '/Superfunds/{SuperFundID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollAuObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // path params
        if ($super_fund_id !== null) {
            $resourcePath = str_replace(
                '{' . 'SuperFundID' . '}',
                PayrollAuObjectSerializer::toPathValue($super_fund_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if (isset($super_fund)) {
            $_tempBody = $super_fund;
        }
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollAuObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'POST',
            $this->config->getHostPayrollAu() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateTimesheet
     * Updates a timesheet
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $timesheet_id Timesheet id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollAu\Timesheet[] $timesheet timesheet (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollAu\Timesheets
     */
    public function updateTimesheet($xero_tenant_id, $timesheet_id, $timesheet = null)
    {
        list($response) = $this->updateTimesheetWithHttpInfo($xero_tenant_id, $timesheet_id, $timesheet);
        return $response;
    }
    /**
     * Operation updateTimesheetWithHttpInfo
     * Updates a timesheet
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $timesheet_id Timesheet id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollAu\Timesheet[] $timesheet (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollAu\Timesheets, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateTimesheetWithHttpInfo($xero_tenant_id, $timesheet_id, $timesheet = null)
    {
        $request = $this->updateTimesheetRequest($xero_tenant_id, $timesheet_id, $timesheet);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollAu\Timesheets' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollAuObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollAu\Timesheets', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollAu\Timesheets';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollAuObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollAuObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollAu\Timesheets',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation updateTimesheetAsync
     * Updates a timesheet
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $timesheet_id Timesheet id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollAu\Timesheet[] $timesheet (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateTimesheetAsync($xero_tenant_id, $timesheet_id, $timesheet = null)
    {
        return $this->updateTimesheetAsyncWithHttpInfo($xero_tenant_id, $timesheet_id, $timesheet)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation updateTimesheetAsyncWithHttpInfo
     * Updates a timesheet
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $timesheet_id Timesheet id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollAu\Timesheet[] $timesheet (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function updateTimesheetAsyncWithHttpInfo($xero_tenant_id, $timesheet_id, $timesheet = null)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollAu\Timesheets';
        $request = $this->updateTimesheetRequest($xero_tenant_id, $timesheet_id, $timesheet);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollAuObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateTimesheet'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $timesheet_id Timesheet id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollAu\Timesheet[] $timesheet (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function updateTimesheetRequest($xero_tenant_id, $timesheet_id, $timesheet = null)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling updateTimesheet'
            );
        }
        // verify the required parameter 'timesheet_id' is set
        if ($timesheet_id === null || (is_array($timesheet_id) && count($timesheet_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $timesheet_id when calling updateTimesheet'
            );
        }
        $resourcePath = '/Timesheets/{TimesheetID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollAuObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // path params
        if ($timesheet_id !== null) {
            $resourcePath = str_replace(
                '{' . 'TimesheetID' . '}',
                PayrollAuObjectSerializer::toPathValue($timesheet_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if (isset($timesheet)) {
            $_tempBody = $timesheet;
        }
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollAuObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'POST',
            $this->config->getHostPayrollAu() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
