<?php
/**
 * PayrollUkApi
 * PHP version 5
 *
 * @category Class
 * @package  XeroAPI\XeroPHP PayrollUk
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Xero Payroll UK
 *
 * This is the Xero Payroll API for orgs in the UK region.
 *
 * OpenAPI spec version: 2.10.4
 * Contact: api@xero.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 4.3.1
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace XeroAPI\XeroPHP\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use XeroAPI\XeroPHP\ApiException;
use XeroAPI\XeroPHP\Configuration;
use XeroAPI\XeroPHP\HeaderSelector;
use XeroAPI\XeroPHP\PayrollUkObjectSerializer;

/**
 * PayrollUkApi Class Doc Comment
 *
 * @category Class
 * @package  XeroAPI\XeroPHP
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class PayrollUkApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation approveTimesheet
     * Approves a specific timesheet
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $timesheet_id Identifier for the timesheet (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollUk\TimesheetObject|\XeroAPI\XeroPHP\Models\PayrollUk\Problem
     */
    public function approveTimesheet($xero_tenant_id, $timesheet_id)
    {
        list($response) = $this->approveTimesheetWithHttpInfo($xero_tenant_id, $timesheet_id);
        return $response;
    }
    /**
     * Operation approveTimesheetWithHttpInfo
     * Approves a specific timesheet
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $timesheet_id Identifier for the timesheet (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollUk\TimesheetObject|\XeroAPI\XeroPHP\Models\PayrollUk\Problem, HTTP status code, HTTP response headers (array of strings)
     */
    public function approveTimesheetWithHttpInfo($xero_tenant_id, $timesheet_id)
    {
        $request = $this->approveTimesheetRequest($xero_tenant_id, $timesheet_id);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollUk\TimesheetObject' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollUk\TimesheetObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\XeroAPI\XeroPHP\Models\PayrollUk\Problem' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollUk\Problem', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\TimesheetObject';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollUkObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollUk\TimesheetObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = PayrollUkObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollUk\Problem',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation approveTimesheetAsync
     * Approves a specific timesheet
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $timesheet_id Identifier for the timesheet (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function approveTimesheetAsync($xero_tenant_id, $timesheet_id)
    {
        return $this->approveTimesheetAsyncWithHttpInfo($xero_tenant_id, $timesheet_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation approveTimesheetAsyncWithHttpInfo
     * Approves a specific timesheet
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $timesheet_id Identifier for the timesheet (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function approveTimesheetAsyncWithHttpInfo($xero_tenant_id, $timesheet_id)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\TimesheetObject';
        $request = $this->approveTimesheetRequest($xero_tenant_id, $timesheet_id);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'approveTimesheet'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $timesheet_id Identifier for the timesheet (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function approveTimesheetRequest($xero_tenant_id, $timesheet_id)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling approveTimesheet'
            );
        }
        // verify the required parameter 'timesheet_id' is set
        if ($timesheet_id === null || (is_array($timesheet_id) && count($timesheet_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $timesheet_id when calling approveTimesheet'
            );
        }
        $resourcePath = '/Timesheets/{TimesheetID}/Approve';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollUkObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // path params
        if ($timesheet_id !== null) {
            $resourcePath = str_replace(
                '{' . 'TimesheetID' . '}',
                PayrollUkObjectSerializer::toPathValue($timesheet_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollUkObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'POST',
            $this->config->getHostPayrollUk() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createBenefit
     * Creates a new employee benefit
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\Benefit $benefit benefit (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollUk\BenefitObject|\XeroAPI\XeroPHP\Models\PayrollUk\Problem
     */
    public function createBenefit($xero_tenant_id, $benefit)
    {
        list($response) = $this->createBenefitWithHttpInfo($xero_tenant_id, $benefit);
        return $response;
    }
    /**
     * Operation createBenefitWithHttpInfo
     * Creates a new employee benefit
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\Benefit $benefit (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollUk\BenefitObject|\XeroAPI\XeroPHP\Models\PayrollUk\Problem, HTTP status code, HTTP response headers (array of strings)
     */
    public function createBenefitWithHttpInfo($xero_tenant_id, $benefit)
    {
        $request = $this->createBenefitRequest($xero_tenant_id, $benefit);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollUk\BenefitObject' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollUk\BenefitObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\XeroAPI\XeroPHP\Models\PayrollUk\Problem' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollUk\Problem', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\BenefitObject';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollUkObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollUk\BenefitObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = PayrollUkObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollUk\Problem',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation createBenefitAsync
     * Creates a new employee benefit
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\Benefit $benefit (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createBenefitAsync($xero_tenant_id, $benefit)
    {
        return $this->createBenefitAsyncWithHttpInfo($xero_tenant_id, $benefit)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation createBenefitAsyncWithHttpInfo
     * Creates a new employee benefit
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\Benefit $benefit (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function createBenefitAsyncWithHttpInfo($xero_tenant_id, $benefit)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\BenefitObject';
        $request = $this->createBenefitRequest($xero_tenant_id, $benefit);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createBenefit'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\Benefit $benefit (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function createBenefitRequest($xero_tenant_id, $benefit)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createBenefit'
            );
        }
        // verify the required parameter 'benefit' is set
        if ($benefit === null || (is_array($benefit) && count($benefit) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $benefit when calling createBenefit'
            );
        }
        $resourcePath = '/Benefits';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollUkObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // body params
        $_tempBody = null;
        if (isset($benefit)) {
            $_tempBody = $benefit;
        }
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollUkObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'POST',
            $this->config->getHostPayrollUk() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createDeduction
     * Creates a new deduction
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\Deduction $deduction deduction (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollUk\DeductionObject|\XeroAPI\XeroPHP\Models\PayrollUk\Problem
     */
    public function createDeduction($xero_tenant_id, $deduction)
    {
        list($response) = $this->createDeductionWithHttpInfo($xero_tenant_id, $deduction);
        return $response;
    }
    /**
     * Operation createDeductionWithHttpInfo
     * Creates a new deduction
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\Deduction $deduction (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollUk\DeductionObject|\XeroAPI\XeroPHP\Models\PayrollUk\Problem, HTTP status code, HTTP response headers (array of strings)
     */
    public function createDeductionWithHttpInfo($xero_tenant_id, $deduction)
    {
        $request = $this->createDeductionRequest($xero_tenant_id, $deduction);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollUk\DeductionObject' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollUk\DeductionObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\XeroAPI\XeroPHP\Models\PayrollUk\Problem' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollUk\Problem', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\DeductionObject';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollUkObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollUk\DeductionObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = PayrollUkObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollUk\Problem',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation createDeductionAsync
     * Creates a new deduction
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\Deduction $deduction (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createDeductionAsync($xero_tenant_id, $deduction)
    {
        return $this->createDeductionAsyncWithHttpInfo($xero_tenant_id, $deduction)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation createDeductionAsyncWithHttpInfo
     * Creates a new deduction
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\Deduction $deduction (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function createDeductionAsyncWithHttpInfo($xero_tenant_id, $deduction)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\DeductionObject';
        $request = $this->createDeductionRequest($xero_tenant_id, $deduction);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createDeduction'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\Deduction $deduction (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function createDeductionRequest($xero_tenant_id, $deduction)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createDeduction'
            );
        }
        // verify the required parameter 'deduction' is set
        if ($deduction === null || (is_array($deduction) && count($deduction) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $deduction when calling createDeduction'
            );
        }
        $resourcePath = '/Deductions';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollUkObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // body params
        $_tempBody = null;
        if (isset($deduction)) {
            $_tempBody = $deduction;
        }
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollUkObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'POST',
            $this->config->getHostPayrollUk() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createEarningsRate
     * Creates a new earnings rate
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\EarningsRate $earnings_rate earnings_rate (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollUk\EarningsRateObject|\XeroAPI\XeroPHP\Models\PayrollUk\Problem
     */
    public function createEarningsRate($xero_tenant_id, $earnings_rate)
    {
        list($response) = $this->createEarningsRateWithHttpInfo($xero_tenant_id, $earnings_rate);
        return $response;
    }
    /**
     * Operation createEarningsRateWithHttpInfo
     * Creates a new earnings rate
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\EarningsRate $earnings_rate (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollUk\EarningsRateObject|\XeroAPI\XeroPHP\Models\PayrollUk\Problem, HTTP status code, HTTP response headers (array of strings)
     */
    public function createEarningsRateWithHttpInfo($xero_tenant_id, $earnings_rate)
    {
        $request = $this->createEarningsRateRequest($xero_tenant_id, $earnings_rate);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollUk\EarningsRateObject' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollUk\EarningsRateObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\XeroAPI\XeroPHP\Models\PayrollUk\Problem' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollUk\Problem', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\EarningsRateObject';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollUkObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollUk\EarningsRateObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = PayrollUkObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollUk\Problem',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation createEarningsRateAsync
     * Creates a new earnings rate
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\EarningsRate $earnings_rate (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createEarningsRateAsync($xero_tenant_id, $earnings_rate)
    {
        return $this->createEarningsRateAsyncWithHttpInfo($xero_tenant_id, $earnings_rate)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation createEarningsRateAsyncWithHttpInfo
     * Creates a new earnings rate
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\EarningsRate $earnings_rate (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function createEarningsRateAsyncWithHttpInfo($xero_tenant_id, $earnings_rate)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\EarningsRateObject';
        $request = $this->createEarningsRateRequest($xero_tenant_id, $earnings_rate);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createEarningsRate'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\EarningsRate $earnings_rate (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function createEarningsRateRequest($xero_tenant_id, $earnings_rate)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createEarningsRate'
            );
        }
        // verify the required parameter 'earnings_rate' is set
        if ($earnings_rate === null || (is_array($earnings_rate) && count($earnings_rate) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $earnings_rate when calling createEarningsRate'
            );
        }
        $resourcePath = '/EarningsRates';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollUkObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // body params
        $_tempBody = null;
        if (isset($earnings_rate)) {
            $_tempBody = $earnings_rate;
        }
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollUkObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'POST',
            $this->config->getHostPayrollUk() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createEmployee
     * Creates employees
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\Employee $employee employee (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollUk\EmployeeObject|\XeroAPI\XeroPHP\Models\PayrollUk\Problem
     */
    public function createEmployee($xero_tenant_id, $employee)
    {
        list($response) = $this->createEmployeeWithHttpInfo($xero_tenant_id, $employee);
        return $response;
    }
    /**
     * Operation createEmployeeWithHttpInfo
     * Creates employees
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\Employee $employee (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollUk\EmployeeObject|\XeroAPI\XeroPHP\Models\PayrollUk\Problem, HTTP status code, HTTP response headers (array of strings)
     */
    public function createEmployeeWithHttpInfo($xero_tenant_id, $employee)
    {
        $request = $this->createEmployeeRequest($xero_tenant_id, $employee);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollUk\EmployeeObject' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollUk\EmployeeObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\XeroAPI\XeroPHP\Models\PayrollUk\Problem' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollUk\Problem', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\EmployeeObject';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollUkObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollUk\EmployeeObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = PayrollUkObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollUk\Problem',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation createEmployeeAsync
     * Creates employees
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\Employee $employee (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createEmployeeAsync($xero_tenant_id, $employee)
    {
        return $this->createEmployeeAsyncWithHttpInfo($xero_tenant_id, $employee)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation createEmployeeAsyncWithHttpInfo
     * Creates employees
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\Employee $employee (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function createEmployeeAsyncWithHttpInfo($xero_tenant_id, $employee)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\EmployeeObject';
        $request = $this->createEmployeeRequest($xero_tenant_id, $employee);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createEmployee'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\Employee $employee (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function createEmployeeRequest($xero_tenant_id, $employee)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createEmployee'
            );
        }
        // verify the required parameter 'employee' is set
        if ($employee === null || (is_array($employee) && count($employee) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $employee when calling createEmployee'
            );
        }
        $resourcePath = '/Employees';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollUkObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // body params
        $_tempBody = null;
        if (isset($employee)) {
            $_tempBody = $employee;
        }
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollUkObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'POST',
            $this->config->getHostPayrollUk() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createEmployeeEarningsTemplate
     * Creates an earnings template records for a specific employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\EarningsTemplate $earnings_template earnings_template (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollUk\EarningsTemplateObject|\XeroAPI\XeroPHP\Models\PayrollUk\Problem
     */
    public function createEmployeeEarningsTemplate($xero_tenant_id, $employee_id, $earnings_template)
    {
        list($response) = $this->createEmployeeEarningsTemplateWithHttpInfo($xero_tenant_id, $employee_id, $earnings_template);
        return $response;
    }
    /**
     * Operation createEmployeeEarningsTemplateWithHttpInfo
     * Creates an earnings template records for a specific employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\EarningsTemplate $earnings_template (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollUk\EarningsTemplateObject|\XeroAPI\XeroPHP\Models\PayrollUk\Problem, HTTP status code, HTTP response headers (array of strings)
     */
    public function createEmployeeEarningsTemplateWithHttpInfo($xero_tenant_id, $employee_id, $earnings_template)
    {
        $request = $this->createEmployeeEarningsTemplateRequest($xero_tenant_id, $employee_id, $earnings_template);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollUk\EarningsTemplateObject' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollUk\EarningsTemplateObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\XeroAPI\XeroPHP\Models\PayrollUk\Problem' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollUk\Problem', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\EarningsTemplateObject';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollUkObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollUk\EarningsTemplateObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = PayrollUkObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollUk\Problem',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation createEmployeeEarningsTemplateAsync
     * Creates an earnings template records for a specific employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\EarningsTemplate $earnings_template (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createEmployeeEarningsTemplateAsync($xero_tenant_id, $employee_id, $earnings_template)
    {
        return $this->createEmployeeEarningsTemplateAsyncWithHttpInfo($xero_tenant_id, $employee_id, $earnings_template)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation createEmployeeEarningsTemplateAsyncWithHttpInfo
     * Creates an earnings template records for a specific employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\EarningsTemplate $earnings_template (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function createEmployeeEarningsTemplateAsyncWithHttpInfo($xero_tenant_id, $employee_id, $earnings_template)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\EarningsTemplateObject';
        $request = $this->createEmployeeEarningsTemplateRequest($xero_tenant_id, $employee_id, $earnings_template);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createEmployeeEarningsTemplate'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\EarningsTemplate $earnings_template (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function createEmployeeEarningsTemplateRequest($xero_tenant_id, $employee_id, $earnings_template)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createEmployeeEarningsTemplate'
            );
        }
        // verify the required parameter 'employee_id' is set
        if ($employee_id === null || (is_array($employee_id) && count($employee_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $employee_id when calling createEmployeeEarningsTemplate'
            );
        }
        // verify the required parameter 'earnings_template' is set
        if ($earnings_template === null || (is_array($earnings_template) && count($earnings_template) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $earnings_template when calling createEmployeeEarningsTemplate'
            );
        }
        $resourcePath = '/Employees/{EmployeeID}/PayTemplates/earnings';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollUkObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // path params
        if ($employee_id !== null) {
            $resourcePath = str_replace(
                '{' . 'EmployeeID' . '}',
                PayrollUkObjectSerializer::toPathValue($employee_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if (isset($earnings_template)) {
            $_tempBody = $earnings_template;
        }
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollUkObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'POST',
            $this->config->getHostPayrollUk() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createEmployeeLeave
     * Creates leave records for a specific employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\EmployeeLeave $employee_leave employee_leave (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollUk\EmployeeLeaveObject|\XeroAPI\XeroPHP\Models\PayrollUk\Problem
     */
    public function createEmployeeLeave($xero_tenant_id, $employee_id, $employee_leave)
    {
        list($response) = $this->createEmployeeLeaveWithHttpInfo($xero_tenant_id, $employee_id, $employee_leave);
        return $response;
    }
    /**
     * Operation createEmployeeLeaveWithHttpInfo
     * Creates leave records for a specific employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\EmployeeLeave $employee_leave (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollUk\EmployeeLeaveObject|\XeroAPI\XeroPHP\Models\PayrollUk\Problem, HTTP status code, HTTP response headers (array of strings)
     */
    public function createEmployeeLeaveWithHttpInfo($xero_tenant_id, $employee_id, $employee_leave)
    {
        $request = $this->createEmployeeLeaveRequest($xero_tenant_id, $employee_id, $employee_leave);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollUk\EmployeeLeaveObject' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollUk\EmployeeLeaveObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\XeroAPI\XeroPHP\Models\PayrollUk\Problem' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollUk\Problem', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\EmployeeLeaveObject';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollUkObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollUk\EmployeeLeaveObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = PayrollUkObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollUk\Problem',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation createEmployeeLeaveAsync
     * Creates leave records for a specific employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\EmployeeLeave $employee_leave (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createEmployeeLeaveAsync($xero_tenant_id, $employee_id, $employee_leave)
    {
        return $this->createEmployeeLeaveAsyncWithHttpInfo($xero_tenant_id, $employee_id, $employee_leave)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation createEmployeeLeaveAsyncWithHttpInfo
     * Creates leave records for a specific employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\EmployeeLeave $employee_leave (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function createEmployeeLeaveAsyncWithHttpInfo($xero_tenant_id, $employee_id, $employee_leave)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\EmployeeLeaveObject';
        $request = $this->createEmployeeLeaveRequest($xero_tenant_id, $employee_id, $employee_leave);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createEmployeeLeave'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\EmployeeLeave $employee_leave (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function createEmployeeLeaveRequest($xero_tenant_id, $employee_id, $employee_leave)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createEmployeeLeave'
            );
        }
        // verify the required parameter 'employee_id' is set
        if ($employee_id === null || (is_array($employee_id) && count($employee_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $employee_id when calling createEmployeeLeave'
            );
        }
        // verify the required parameter 'employee_leave' is set
        if ($employee_leave === null || (is_array($employee_leave) && count($employee_leave) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $employee_leave when calling createEmployeeLeave'
            );
        }
        $resourcePath = '/Employees/{EmployeeID}/Leave';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollUkObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // path params
        if ($employee_id !== null) {
            $resourcePath = str_replace(
                '{' . 'EmployeeID' . '}',
                PayrollUkObjectSerializer::toPathValue($employee_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if (isset($employee_leave)) {
            $_tempBody = $employee_leave;
        }
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollUkObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'POST',
            $this->config->getHostPayrollUk() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createEmployeeLeaveType
     * Creates employee leave type records
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\EmployeeLeaveType $employee_leave_type employee_leave_type (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollUk\EmployeeLeaveTypeObject|\XeroAPI\XeroPHP\Models\PayrollUk\Problem
     */
    public function createEmployeeLeaveType($xero_tenant_id, $employee_id, $employee_leave_type)
    {
        list($response) = $this->createEmployeeLeaveTypeWithHttpInfo($xero_tenant_id, $employee_id, $employee_leave_type);
        return $response;
    }
    /**
     * Operation createEmployeeLeaveTypeWithHttpInfo
     * Creates employee leave type records
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\EmployeeLeaveType $employee_leave_type (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollUk\EmployeeLeaveTypeObject|\XeroAPI\XeroPHP\Models\PayrollUk\Problem, HTTP status code, HTTP response headers (array of strings)
     */
    public function createEmployeeLeaveTypeWithHttpInfo($xero_tenant_id, $employee_id, $employee_leave_type)
    {
        $request = $this->createEmployeeLeaveTypeRequest($xero_tenant_id, $employee_id, $employee_leave_type);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollUk\EmployeeLeaveTypeObject' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollUk\EmployeeLeaveTypeObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\XeroAPI\XeroPHP\Models\PayrollUk\Problem' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollUk\Problem', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\EmployeeLeaveTypeObject';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollUkObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollUk\EmployeeLeaveTypeObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = PayrollUkObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollUk\Problem',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation createEmployeeLeaveTypeAsync
     * Creates employee leave type records
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\EmployeeLeaveType $employee_leave_type (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createEmployeeLeaveTypeAsync($xero_tenant_id, $employee_id, $employee_leave_type)
    {
        return $this->createEmployeeLeaveTypeAsyncWithHttpInfo($xero_tenant_id, $employee_id, $employee_leave_type)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation createEmployeeLeaveTypeAsyncWithHttpInfo
     * Creates employee leave type records
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\EmployeeLeaveType $employee_leave_type (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function createEmployeeLeaveTypeAsyncWithHttpInfo($xero_tenant_id, $employee_id, $employee_leave_type)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\EmployeeLeaveTypeObject';
        $request = $this->createEmployeeLeaveTypeRequest($xero_tenant_id, $employee_id, $employee_leave_type);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createEmployeeLeaveType'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\EmployeeLeaveType $employee_leave_type (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function createEmployeeLeaveTypeRequest($xero_tenant_id, $employee_id, $employee_leave_type)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createEmployeeLeaveType'
            );
        }
        // verify the required parameter 'employee_id' is set
        if ($employee_id === null || (is_array($employee_id) && count($employee_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $employee_id when calling createEmployeeLeaveType'
            );
        }
        // verify the required parameter 'employee_leave_type' is set
        if ($employee_leave_type === null || (is_array($employee_leave_type) && count($employee_leave_type) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $employee_leave_type when calling createEmployeeLeaveType'
            );
        }
        $resourcePath = '/Employees/{EmployeeID}/LeaveTypes';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollUkObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // path params
        if ($employee_id !== null) {
            $resourcePath = str_replace(
                '{' . 'EmployeeID' . '}',
                PayrollUkObjectSerializer::toPathValue($employee_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if (isset($employee_leave_type)) {
            $_tempBody = $employee_leave_type;
        }
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollUkObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'POST',
            $this->config->getHostPayrollUk() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createEmployeeOpeningBalances
     * Creates an opening balance for a specific employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\EmployeeOpeningBalances $employee_opening_balances employee_opening_balances (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollUk\EmployeeOpeningBalancesObject|\XeroAPI\XeroPHP\Models\PayrollUk\Problem
     */
    public function createEmployeeOpeningBalances($xero_tenant_id, $employee_id, $employee_opening_balances)
    {
        list($response) = $this->createEmployeeOpeningBalancesWithHttpInfo($xero_tenant_id, $employee_id, $employee_opening_balances);
        return $response;
    }
    /**
     * Operation createEmployeeOpeningBalancesWithHttpInfo
     * Creates an opening balance for a specific employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\EmployeeOpeningBalances $employee_opening_balances (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollUk\EmployeeOpeningBalancesObject|\XeroAPI\XeroPHP\Models\PayrollUk\Problem, HTTP status code, HTTP response headers (array of strings)
     */
    public function createEmployeeOpeningBalancesWithHttpInfo($xero_tenant_id, $employee_id, $employee_opening_balances)
    {
        $request = $this->createEmployeeOpeningBalancesRequest($xero_tenant_id, $employee_id, $employee_opening_balances);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollUk\EmployeeOpeningBalancesObject' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollUk\EmployeeOpeningBalancesObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\XeroAPI\XeroPHP\Models\PayrollUk\Problem' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollUk\Problem', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\EmployeeOpeningBalancesObject';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollUkObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollUk\EmployeeOpeningBalancesObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = PayrollUkObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollUk\Problem',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation createEmployeeOpeningBalancesAsync
     * Creates an opening balance for a specific employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\EmployeeOpeningBalances $employee_opening_balances (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createEmployeeOpeningBalancesAsync($xero_tenant_id, $employee_id, $employee_opening_balances)
    {
        return $this->createEmployeeOpeningBalancesAsyncWithHttpInfo($xero_tenant_id, $employee_id, $employee_opening_balances)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation createEmployeeOpeningBalancesAsyncWithHttpInfo
     * Creates an opening balance for a specific employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\EmployeeOpeningBalances $employee_opening_balances (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function createEmployeeOpeningBalancesAsyncWithHttpInfo($xero_tenant_id, $employee_id, $employee_opening_balances)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\EmployeeOpeningBalancesObject';
        $request = $this->createEmployeeOpeningBalancesRequest($xero_tenant_id, $employee_id, $employee_opening_balances);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createEmployeeOpeningBalances'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\EmployeeOpeningBalances $employee_opening_balances (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function createEmployeeOpeningBalancesRequest($xero_tenant_id, $employee_id, $employee_opening_balances)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createEmployeeOpeningBalances'
            );
        }
        // verify the required parameter 'employee_id' is set
        if ($employee_id === null || (is_array($employee_id) && count($employee_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $employee_id when calling createEmployeeOpeningBalances'
            );
        }
        // verify the required parameter 'employee_opening_balances' is set
        if ($employee_opening_balances === null || (is_array($employee_opening_balances) && count($employee_opening_balances) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $employee_opening_balances when calling createEmployeeOpeningBalances'
            );
        }
        $resourcePath = '/Employees/{EmployeeID}/ukopeningbalances';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollUkObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // path params
        if ($employee_id !== null) {
            $resourcePath = str_replace(
                '{' . 'EmployeeID' . '}',
                PayrollUkObjectSerializer::toPathValue($employee_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if (isset($employee_opening_balances)) {
            $_tempBody = $employee_opening_balances;
        }
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollUkObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'POST',
            $this->config->getHostPayrollUk() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createEmployeePaymentMethod
     * Creates an employee payment method
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\PaymentMethod $payment_method payment_method (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollUk\PaymentMethodObject|\XeroAPI\XeroPHP\Models\PayrollUk\Problem
     */
    public function createEmployeePaymentMethod($xero_tenant_id, $employee_id, $payment_method)
    {
        list($response) = $this->createEmployeePaymentMethodWithHttpInfo($xero_tenant_id, $employee_id, $payment_method);
        return $response;
    }
    /**
     * Operation createEmployeePaymentMethodWithHttpInfo
     * Creates an employee payment method
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\PaymentMethod $payment_method (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollUk\PaymentMethodObject|\XeroAPI\XeroPHP\Models\PayrollUk\Problem, HTTP status code, HTTP response headers (array of strings)
     */
    public function createEmployeePaymentMethodWithHttpInfo($xero_tenant_id, $employee_id, $payment_method)
    {
        $request = $this->createEmployeePaymentMethodRequest($xero_tenant_id, $employee_id, $payment_method);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollUk\PaymentMethodObject' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollUk\PaymentMethodObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\XeroAPI\XeroPHP\Models\PayrollUk\Problem' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollUk\Problem', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\PaymentMethodObject';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollUkObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollUk\PaymentMethodObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = PayrollUkObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollUk\Problem',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation createEmployeePaymentMethodAsync
     * Creates an employee payment method
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\PaymentMethod $payment_method (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createEmployeePaymentMethodAsync($xero_tenant_id, $employee_id, $payment_method)
    {
        return $this->createEmployeePaymentMethodAsyncWithHttpInfo($xero_tenant_id, $employee_id, $payment_method)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation createEmployeePaymentMethodAsyncWithHttpInfo
     * Creates an employee payment method
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\PaymentMethod $payment_method (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function createEmployeePaymentMethodAsyncWithHttpInfo($xero_tenant_id, $employee_id, $payment_method)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\PaymentMethodObject';
        $request = $this->createEmployeePaymentMethodRequest($xero_tenant_id, $employee_id, $payment_method);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createEmployeePaymentMethod'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\PaymentMethod $payment_method (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function createEmployeePaymentMethodRequest($xero_tenant_id, $employee_id, $payment_method)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createEmployeePaymentMethod'
            );
        }
        // verify the required parameter 'employee_id' is set
        if ($employee_id === null || (is_array($employee_id) && count($employee_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $employee_id when calling createEmployeePaymentMethod'
            );
        }
        // verify the required parameter 'payment_method' is set
        if ($payment_method === null || (is_array($payment_method) && count($payment_method) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $payment_method when calling createEmployeePaymentMethod'
            );
        }
        $resourcePath = '/Employees/{EmployeeID}/PaymentMethods';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollUkObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // path params
        if ($employee_id !== null) {
            $resourcePath = str_replace(
                '{' . 'EmployeeID' . '}',
                PayrollUkObjectSerializer::toPathValue($employee_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if (isset($payment_method)) {
            $_tempBody = $payment_method;
        }
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollUkObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'POST',
            $this->config->getHostPayrollUk() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createEmployeeSalaryAndWage
     * Creates a salary and wage record for a specific employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\SalaryAndWage $salary_and_wage salary_and_wage (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollUk\SalaryAndWageObject|\XeroAPI\XeroPHP\Models\PayrollUk\Problem
     */
    public function createEmployeeSalaryAndWage($xero_tenant_id, $employee_id, $salary_and_wage)
    {
        list($response) = $this->createEmployeeSalaryAndWageWithHttpInfo($xero_tenant_id, $employee_id, $salary_and_wage);
        return $response;
    }
    /**
     * Operation createEmployeeSalaryAndWageWithHttpInfo
     * Creates a salary and wage record for a specific employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\SalaryAndWage $salary_and_wage (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollUk\SalaryAndWageObject|\XeroAPI\XeroPHP\Models\PayrollUk\Problem, HTTP status code, HTTP response headers (array of strings)
     */
    public function createEmployeeSalaryAndWageWithHttpInfo($xero_tenant_id, $employee_id, $salary_and_wage)
    {
        $request = $this->createEmployeeSalaryAndWageRequest($xero_tenant_id, $employee_id, $salary_and_wage);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollUk\SalaryAndWageObject' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollUk\SalaryAndWageObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\XeroAPI\XeroPHP\Models\PayrollUk\Problem' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollUk\Problem', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\SalaryAndWageObject';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollUkObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollUk\SalaryAndWageObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = PayrollUkObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollUk\Problem',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation createEmployeeSalaryAndWageAsync
     * Creates a salary and wage record for a specific employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\SalaryAndWage $salary_and_wage (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createEmployeeSalaryAndWageAsync($xero_tenant_id, $employee_id, $salary_and_wage)
    {
        return $this->createEmployeeSalaryAndWageAsyncWithHttpInfo($xero_tenant_id, $employee_id, $salary_and_wage)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation createEmployeeSalaryAndWageAsyncWithHttpInfo
     * Creates a salary and wage record for a specific employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\SalaryAndWage $salary_and_wage (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function createEmployeeSalaryAndWageAsyncWithHttpInfo($xero_tenant_id, $employee_id, $salary_and_wage)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\SalaryAndWageObject';
        $request = $this->createEmployeeSalaryAndWageRequest($xero_tenant_id, $employee_id, $salary_and_wage);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createEmployeeSalaryAndWage'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\SalaryAndWage $salary_and_wage (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function createEmployeeSalaryAndWageRequest($xero_tenant_id, $employee_id, $salary_and_wage)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createEmployeeSalaryAndWage'
            );
        }
        // verify the required parameter 'employee_id' is set
        if ($employee_id === null || (is_array($employee_id) && count($employee_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $employee_id when calling createEmployeeSalaryAndWage'
            );
        }
        // verify the required parameter 'salary_and_wage' is set
        if ($salary_and_wage === null || (is_array($salary_and_wage) && count($salary_and_wage) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $salary_and_wage when calling createEmployeeSalaryAndWage'
            );
        }
        $resourcePath = '/Employees/{EmployeeID}/SalaryAndWages';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollUkObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // path params
        if ($employee_id !== null) {
            $resourcePath = str_replace(
                '{' . 'EmployeeID' . '}',
                PayrollUkObjectSerializer::toPathValue($employee_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if (isset($salary_and_wage)) {
            $_tempBody = $salary_and_wage;
        }
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollUkObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'POST',
            $this->config->getHostPayrollUk() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createEmployeeStatutorySickLeave
     * Creates statutory sick leave records
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\EmployeeStatutorySickLeave $employee_statutory_sick_leave employee_statutory_sick_leave (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollUk\EmployeeStatutorySickLeaveObject|\XeroAPI\XeroPHP\Models\PayrollUk\Problem
     */
    public function createEmployeeStatutorySickLeave($xero_tenant_id, $employee_statutory_sick_leave)
    {
        list($response) = $this->createEmployeeStatutorySickLeaveWithHttpInfo($xero_tenant_id, $employee_statutory_sick_leave);
        return $response;
    }
    /**
     * Operation createEmployeeStatutorySickLeaveWithHttpInfo
     * Creates statutory sick leave records
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\EmployeeStatutorySickLeave $employee_statutory_sick_leave (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollUk\EmployeeStatutorySickLeaveObject|\XeroAPI\XeroPHP\Models\PayrollUk\Problem, HTTP status code, HTTP response headers (array of strings)
     */
    public function createEmployeeStatutorySickLeaveWithHttpInfo($xero_tenant_id, $employee_statutory_sick_leave)
    {
        $request = $this->createEmployeeStatutorySickLeaveRequest($xero_tenant_id, $employee_statutory_sick_leave);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollUk\EmployeeStatutorySickLeaveObject' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollUk\EmployeeStatutorySickLeaveObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\XeroAPI\XeroPHP\Models\PayrollUk\Problem' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollUk\Problem', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\EmployeeStatutorySickLeaveObject';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollUkObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollUk\EmployeeStatutorySickLeaveObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = PayrollUkObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollUk\Problem',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation createEmployeeStatutorySickLeaveAsync
     * Creates statutory sick leave records
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\EmployeeStatutorySickLeave $employee_statutory_sick_leave (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createEmployeeStatutorySickLeaveAsync($xero_tenant_id, $employee_statutory_sick_leave)
    {
        return $this->createEmployeeStatutorySickLeaveAsyncWithHttpInfo($xero_tenant_id, $employee_statutory_sick_leave)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation createEmployeeStatutorySickLeaveAsyncWithHttpInfo
     * Creates statutory sick leave records
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\EmployeeStatutorySickLeave $employee_statutory_sick_leave (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function createEmployeeStatutorySickLeaveAsyncWithHttpInfo($xero_tenant_id, $employee_statutory_sick_leave)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\EmployeeStatutorySickLeaveObject';
        $request = $this->createEmployeeStatutorySickLeaveRequest($xero_tenant_id, $employee_statutory_sick_leave);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createEmployeeStatutorySickLeave'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\EmployeeStatutorySickLeave $employee_statutory_sick_leave (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function createEmployeeStatutorySickLeaveRequest($xero_tenant_id, $employee_statutory_sick_leave)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createEmployeeStatutorySickLeave'
            );
        }
        // verify the required parameter 'employee_statutory_sick_leave' is set
        if ($employee_statutory_sick_leave === null || (is_array($employee_statutory_sick_leave) && count($employee_statutory_sick_leave) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $employee_statutory_sick_leave when calling createEmployeeStatutorySickLeave'
            );
        }
        $resourcePath = '/StatutoryLeaves/Sick';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollUkObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // body params
        $_tempBody = null;
        if (isset($employee_statutory_sick_leave)) {
            $_tempBody = $employee_statutory_sick_leave;
        }
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollUkObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'POST',
            $this->config->getHostPayrollUk() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createEmployment
     * Creates employment detail for a specific employee using a unique employee ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\Employment $employment employment (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollUk\EmploymentObject|\XeroAPI\XeroPHP\Models\PayrollUk\Problem
     */
    public function createEmployment($xero_tenant_id, $employee_id, $employment)
    {
        list($response) = $this->createEmploymentWithHttpInfo($xero_tenant_id, $employee_id, $employment);
        return $response;
    }
    /**
     * Operation createEmploymentWithHttpInfo
     * Creates employment detail for a specific employee using a unique employee ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\Employment $employment (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollUk\EmploymentObject|\XeroAPI\XeroPHP\Models\PayrollUk\Problem, HTTP status code, HTTP response headers (array of strings)
     */
    public function createEmploymentWithHttpInfo($xero_tenant_id, $employee_id, $employment)
    {
        $request = $this->createEmploymentRequest($xero_tenant_id, $employee_id, $employment);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollUk\EmploymentObject' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollUk\EmploymentObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\XeroAPI\XeroPHP\Models\PayrollUk\Problem' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollUk\Problem', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\EmploymentObject';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollUkObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollUk\EmploymentObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = PayrollUkObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollUk\Problem',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation createEmploymentAsync
     * Creates employment detail for a specific employee using a unique employee ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\Employment $employment (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createEmploymentAsync($xero_tenant_id, $employee_id, $employment)
    {
        return $this->createEmploymentAsyncWithHttpInfo($xero_tenant_id, $employee_id, $employment)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation createEmploymentAsyncWithHttpInfo
     * Creates employment detail for a specific employee using a unique employee ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\Employment $employment (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function createEmploymentAsyncWithHttpInfo($xero_tenant_id, $employee_id, $employment)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\EmploymentObject';
        $request = $this->createEmploymentRequest($xero_tenant_id, $employee_id, $employment);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createEmployment'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\Employment $employment (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function createEmploymentRequest($xero_tenant_id, $employee_id, $employment)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createEmployment'
            );
        }
        // verify the required parameter 'employee_id' is set
        if ($employee_id === null || (is_array($employee_id) && count($employee_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $employee_id when calling createEmployment'
            );
        }
        // verify the required parameter 'employment' is set
        if ($employment === null || (is_array($employment) && count($employment) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $employment when calling createEmployment'
            );
        }
        $resourcePath = '/Employees/{EmployeeID}/Employment';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollUkObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // path params
        if ($employee_id !== null) {
            $resourcePath = str_replace(
                '{' . 'EmployeeID' . '}',
                PayrollUkObjectSerializer::toPathValue($employee_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if (isset($employment)) {
            $_tempBody = $employment;
        }
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollUkObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'POST',
            $this->config->getHostPayrollUk() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createLeaveType
     * Creates a new leave type
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\LeaveType $leave_type leave_type (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollUk\LeaveTypeObject|\XeroAPI\XeroPHP\Models\PayrollUk\Problem
     */
    public function createLeaveType($xero_tenant_id, $leave_type)
    {
        list($response) = $this->createLeaveTypeWithHttpInfo($xero_tenant_id, $leave_type);
        return $response;
    }
    /**
     * Operation createLeaveTypeWithHttpInfo
     * Creates a new leave type
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\LeaveType $leave_type (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollUk\LeaveTypeObject|\XeroAPI\XeroPHP\Models\PayrollUk\Problem, HTTP status code, HTTP response headers (array of strings)
     */
    public function createLeaveTypeWithHttpInfo($xero_tenant_id, $leave_type)
    {
        $request = $this->createLeaveTypeRequest($xero_tenant_id, $leave_type);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollUk\LeaveTypeObject' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollUk\LeaveTypeObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\XeroAPI\XeroPHP\Models\PayrollUk\Problem' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollUk\Problem', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\LeaveTypeObject';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollUkObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollUk\LeaveTypeObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = PayrollUkObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollUk\Problem',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation createLeaveTypeAsync
     * Creates a new leave type
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\LeaveType $leave_type (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createLeaveTypeAsync($xero_tenant_id, $leave_type)
    {
        return $this->createLeaveTypeAsyncWithHttpInfo($xero_tenant_id, $leave_type)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation createLeaveTypeAsyncWithHttpInfo
     * Creates a new leave type
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\LeaveType $leave_type (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function createLeaveTypeAsyncWithHttpInfo($xero_tenant_id, $leave_type)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\LeaveTypeObject';
        $request = $this->createLeaveTypeRequest($xero_tenant_id, $leave_type);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createLeaveType'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\LeaveType $leave_type (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function createLeaveTypeRequest($xero_tenant_id, $leave_type)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createLeaveType'
            );
        }
        // verify the required parameter 'leave_type' is set
        if ($leave_type === null || (is_array($leave_type) && count($leave_type) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $leave_type when calling createLeaveType'
            );
        }
        $resourcePath = '/LeaveTypes';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollUkObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // body params
        $_tempBody = null;
        if (isset($leave_type)) {
            $_tempBody = $leave_type;
        }
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollUkObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'POST',
            $this->config->getHostPayrollUk() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createMultipleEmployeeEarningsTemplate
     * Creates multiple earnings template records for a specific employee using a unique employee ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\EarningsTemplate[] $earnings_template earnings_template (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollUk\EmployeePayTemplates|\XeroAPI\XeroPHP\Models\PayrollUk\Problem
     */
    public function createMultipleEmployeeEarningsTemplate($xero_tenant_id, $employee_id, $earnings_template)
    {
        list($response) = $this->createMultipleEmployeeEarningsTemplateWithHttpInfo($xero_tenant_id, $employee_id, $earnings_template);
        return $response;
    }
    /**
     * Operation createMultipleEmployeeEarningsTemplateWithHttpInfo
     * Creates multiple earnings template records for a specific employee using a unique employee ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\EarningsTemplate[] $earnings_template (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollUk\EmployeePayTemplates|\XeroAPI\XeroPHP\Models\PayrollUk\Problem, HTTP status code, HTTP response headers (array of strings)
     */
    public function createMultipleEmployeeEarningsTemplateWithHttpInfo($xero_tenant_id, $employee_id, $earnings_template)
    {
        $request = $this->createMultipleEmployeeEarningsTemplateRequest($xero_tenant_id, $employee_id, $earnings_template);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollUk\EmployeePayTemplates' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollUk\EmployeePayTemplates', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\XeroAPI\XeroPHP\Models\PayrollUk\Problem' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollUk\Problem', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\EmployeePayTemplates';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollUkObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollUk\EmployeePayTemplates',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = PayrollUkObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollUk\Problem',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation createMultipleEmployeeEarningsTemplateAsync
     * Creates multiple earnings template records for a specific employee using a unique employee ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\EarningsTemplate[] $earnings_template (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createMultipleEmployeeEarningsTemplateAsync($xero_tenant_id, $employee_id, $earnings_template)
    {
        return $this->createMultipleEmployeeEarningsTemplateAsyncWithHttpInfo($xero_tenant_id, $employee_id, $earnings_template)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation createMultipleEmployeeEarningsTemplateAsyncWithHttpInfo
     * Creates multiple earnings template records for a specific employee using a unique employee ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\EarningsTemplate[] $earnings_template (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function createMultipleEmployeeEarningsTemplateAsyncWithHttpInfo($xero_tenant_id, $employee_id, $earnings_template)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\EmployeePayTemplates';
        $request = $this->createMultipleEmployeeEarningsTemplateRequest($xero_tenant_id, $employee_id, $earnings_template);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createMultipleEmployeeEarningsTemplate'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\EarningsTemplate[] $earnings_template (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function createMultipleEmployeeEarningsTemplateRequest($xero_tenant_id, $employee_id, $earnings_template)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createMultipleEmployeeEarningsTemplate'
            );
        }
        // verify the required parameter 'employee_id' is set
        if ($employee_id === null || (is_array($employee_id) && count($employee_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $employee_id when calling createMultipleEmployeeEarningsTemplate'
            );
        }
        // verify the required parameter 'earnings_template' is set
        if ($earnings_template === null || (is_array($earnings_template) && count($earnings_template) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $earnings_template when calling createMultipleEmployeeEarningsTemplate'
            );
        }
        $resourcePath = '/Employees/{EmployeeID}/paytemplateearnings';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollUkObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // path params
        if ($employee_id !== null) {
            $resourcePath = str_replace(
                '{' . 'EmployeeID' . '}',
                PayrollUkObjectSerializer::toPathValue($employee_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if (isset($earnings_template)) {
            $_tempBody = $earnings_template;
        }
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollUkObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'POST',
            $this->config->getHostPayrollUk() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createPayRunCalendar
     * Creates a new payrun calendar
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\PayRunCalendar $pay_run_calendar pay_run_calendar (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollUk\PayRunCalendarObject|\XeroAPI\XeroPHP\Models\PayrollUk\Problem
     */
    public function createPayRunCalendar($xero_tenant_id, $pay_run_calendar)
    {
        list($response) = $this->createPayRunCalendarWithHttpInfo($xero_tenant_id, $pay_run_calendar);
        return $response;
    }
    /**
     * Operation createPayRunCalendarWithHttpInfo
     * Creates a new payrun calendar
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\PayRunCalendar $pay_run_calendar (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollUk\PayRunCalendarObject|\XeroAPI\XeroPHP\Models\PayrollUk\Problem, HTTP status code, HTTP response headers (array of strings)
     */
    public function createPayRunCalendarWithHttpInfo($xero_tenant_id, $pay_run_calendar)
    {
        $request = $this->createPayRunCalendarRequest($xero_tenant_id, $pay_run_calendar);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollUk\PayRunCalendarObject' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollUk\PayRunCalendarObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\XeroAPI\XeroPHP\Models\PayrollUk\Problem' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollUk\Problem', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\PayRunCalendarObject';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollUkObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollUk\PayRunCalendarObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = PayrollUkObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollUk\Problem',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation createPayRunCalendarAsync
     * Creates a new payrun calendar
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\PayRunCalendar $pay_run_calendar (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createPayRunCalendarAsync($xero_tenant_id, $pay_run_calendar)
    {
        return $this->createPayRunCalendarAsyncWithHttpInfo($xero_tenant_id, $pay_run_calendar)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation createPayRunCalendarAsyncWithHttpInfo
     * Creates a new payrun calendar
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\PayRunCalendar $pay_run_calendar (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function createPayRunCalendarAsyncWithHttpInfo($xero_tenant_id, $pay_run_calendar)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\PayRunCalendarObject';
        $request = $this->createPayRunCalendarRequest($xero_tenant_id, $pay_run_calendar);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createPayRunCalendar'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\PayRunCalendar $pay_run_calendar (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function createPayRunCalendarRequest($xero_tenant_id, $pay_run_calendar)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createPayRunCalendar'
            );
        }
        // verify the required parameter 'pay_run_calendar' is set
        if ($pay_run_calendar === null || (is_array($pay_run_calendar) && count($pay_run_calendar) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $pay_run_calendar when calling createPayRunCalendar'
            );
        }
        $resourcePath = '/PayRunCalendars';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollUkObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // body params
        $_tempBody = null;
        if (isset($pay_run_calendar)) {
            $_tempBody = $pay_run_calendar;
        }
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollUkObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'POST',
            $this->config->getHostPayrollUk() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createReimbursement
     * Creates a new reimbursement
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\Reimbursement $reimbursement reimbursement (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollUk\ReimbursementObject|\XeroAPI\XeroPHP\Models\PayrollUk\Problem
     */
    public function createReimbursement($xero_tenant_id, $reimbursement)
    {
        list($response) = $this->createReimbursementWithHttpInfo($xero_tenant_id, $reimbursement);
        return $response;
    }
    /**
     * Operation createReimbursementWithHttpInfo
     * Creates a new reimbursement
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\Reimbursement $reimbursement (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollUk\ReimbursementObject|\XeroAPI\XeroPHP\Models\PayrollUk\Problem, HTTP status code, HTTP response headers (array of strings)
     */
    public function createReimbursementWithHttpInfo($xero_tenant_id, $reimbursement)
    {
        $request = $this->createReimbursementRequest($xero_tenant_id, $reimbursement);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollUk\ReimbursementObject' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollUk\ReimbursementObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\XeroAPI\XeroPHP\Models\PayrollUk\Problem' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollUk\Problem', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\ReimbursementObject';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollUkObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollUk\ReimbursementObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = PayrollUkObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollUk\Problem',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation createReimbursementAsync
     * Creates a new reimbursement
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\Reimbursement $reimbursement (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createReimbursementAsync($xero_tenant_id, $reimbursement)
    {
        return $this->createReimbursementAsyncWithHttpInfo($xero_tenant_id, $reimbursement)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation createReimbursementAsyncWithHttpInfo
     * Creates a new reimbursement
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\Reimbursement $reimbursement (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function createReimbursementAsyncWithHttpInfo($xero_tenant_id, $reimbursement)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\ReimbursementObject';
        $request = $this->createReimbursementRequest($xero_tenant_id, $reimbursement);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createReimbursement'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\Reimbursement $reimbursement (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function createReimbursementRequest($xero_tenant_id, $reimbursement)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createReimbursement'
            );
        }
        // verify the required parameter 'reimbursement' is set
        if ($reimbursement === null || (is_array($reimbursement) && count($reimbursement) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $reimbursement when calling createReimbursement'
            );
        }
        $resourcePath = '/Reimbursements';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollUkObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // body params
        $_tempBody = null;
        if (isset($reimbursement)) {
            $_tempBody = $reimbursement;
        }
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollUkObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'POST',
            $this->config->getHostPayrollUk() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createTimesheet
     * Creates a new timesheet
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\Timesheet $timesheet timesheet (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollUk\TimesheetObject|\XeroAPI\XeroPHP\Models\PayrollUk\Problem
     */
    public function createTimesheet($xero_tenant_id, $timesheet)
    {
        list($response) = $this->createTimesheetWithHttpInfo($xero_tenant_id, $timesheet);
        return $response;
    }
    /**
     * Operation createTimesheetWithHttpInfo
     * Creates a new timesheet
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\Timesheet $timesheet (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollUk\TimesheetObject|\XeroAPI\XeroPHP\Models\PayrollUk\Problem, HTTP status code, HTTP response headers (array of strings)
     */
    public function createTimesheetWithHttpInfo($xero_tenant_id, $timesheet)
    {
        $request = $this->createTimesheetRequest($xero_tenant_id, $timesheet);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollUk\TimesheetObject' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollUk\TimesheetObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\XeroAPI\XeroPHP\Models\PayrollUk\Problem' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollUk\Problem', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\TimesheetObject';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollUkObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollUk\TimesheetObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = PayrollUkObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollUk\Problem',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation createTimesheetAsync
     * Creates a new timesheet
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\Timesheet $timesheet (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createTimesheetAsync($xero_tenant_id, $timesheet)
    {
        return $this->createTimesheetAsyncWithHttpInfo($xero_tenant_id, $timesheet)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation createTimesheetAsyncWithHttpInfo
     * Creates a new timesheet
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\Timesheet $timesheet (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function createTimesheetAsyncWithHttpInfo($xero_tenant_id, $timesheet)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\TimesheetObject';
        $request = $this->createTimesheetRequest($xero_tenant_id, $timesheet);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createTimesheet'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\Timesheet $timesheet (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function createTimesheetRequest($xero_tenant_id, $timesheet)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createTimesheet'
            );
        }
        // verify the required parameter 'timesheet' is set
        if ($timesheet === null || (is_array($timesheet) && count($timesheet) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $timesheet when calling createTimesheet'
            );
        }
        $resourcePath = '/Timesheets';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollUkObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // body params
        $_tempBody = null;
        if (isset($timesheet)) {
            $_tempBody = $timesheet;
        }
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollUkObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'POST',
            $this->config->getHostPayrollUk() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createTimesheetLine
     * Creates a new timesheet line for a specific timesheet using a unique timesheet ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $timesheet_id Identifier for the timesheet (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\TimesheetLine $timesheet_line timesheet_line (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollUk\TimesheetLineObject|\XeroAPI\XeroPHP\Models\PayrollUk\Problem
     */
    public function createTimesheetLine($xero_tenant_id, $timesheet_id, $timesheet_line)
    {
        list($response) = $this->createTimesheetLineWithHttpInfo($xero_tenant_id, $timesheet_id, $timesheet_line);
        return $response;
    }
    /**
     * Operation createTimesheetLineWithHttpInfo
     * Creates a new timesheet line for a specific timesheet using a unique timesheet ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $timesheet_id Identifier for the timesheet (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\TimesheetLine $timesheet_line (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollUk\TimesheetLineObject|\XeroAPI\XeroPHP\Models\PayrollUk\Problem, HTTP status code, HTTP response headers (array of strings)
     */
    public function createTimesheetLineWithHttpInfo($xero_tenant_id, $timesheet_id, $timesheet_line)
    {
        $request = $this->createTimesheetLineRequest($xero_tenant_id, $timesheet_id, $timesheet_line);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollUk\TimesheetLineObject' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollUk\TimesheetLineObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\XeroAPI\XeroPHP\Models\PayrollUk\Problem' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollUk\Problem', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\TimesheetLineObject';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollUkObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollUk\TimesheetLineObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = PayrollUkObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollUk\Problem',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation createTimesheetLineAsync
     * Creates a new timesheet line for a specific timesheet using a unique timesheet ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $timesheet_id Identifier for the timesheet (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\TimesheetLine $timesheet_line (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createTimesheetLineAsync($xero_tenant_id, $timesheet_id, $timesheet_line)
    {
        return $this->createTimesheetLineAsyncWithHttpInfo($xero_tenant_id, $timesheet_id, $timesheet_line)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation createTimesheetLineAsyncWithHttpInfo
     * Creates a new timesheet line for a specific timesheet using a unique timesheet ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $timesheet_id Identifier for the timesheet (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\TimesheetLine $timesheet_line (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function createTimesheetLineAsyncWithHttpInfo($xero_tenant_id, $timesheet_id, $timesheet_line)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\TimesheetLineObject';
        $request = $this->createTimesheetLineRequest($xero_tenant_id, $timesheet_id, $timesheet_line);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createTimesheetLine'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $timesheet_id Identifier for the timesheet (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\TimesheetLine $timesheet_line (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function createTimesheetLineRequest($xero_tenant_id, $timesheet_id, $timesheet_line)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling createTimesheetLine'
            );
        }
        // verify the required parameter 'timesheet_id' is set
        if ($timesheet_id === null || (is_array($timesheet_id) && count($timesheet_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $timesheet_id when calling createTimesheetLine'
            );
        }
        // verify the required parameter 'timesheet_line' is set
        if ($timesheet_line === null || (is_array($timesheet_line) && count($timesheet_line) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $timesheet_line when calling createTimesheetLine'
            );
        }
        $resourcePath = '/Timesheets/{TimesheetID}/Lines';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollUkObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // path params
        if ($timesheet_id !== null) {
            $resourcePath = str_replace(
                '{' . 'TimesheetID' . '}',
                PayrollUkObjectSerializer::toPathValue($timesheet_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if (isset($timesheet_line)) {
            $_tempBody = $timesheet_line;
        }
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollUkObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'POST',
            $this->config->getHostPayrollUk() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteEmployeeEarningsTemplate
     * Deletes a specific employee's earnings template record
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  string $pay_template_earning_id Id for single pay template earnings object (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteEmployeeEarningsTemplate($xero_tenant_id, $employee_id, $pay_template_earning_id)
    {
        $this->deleteEmployeeEarningsTemplateWithHttpInfo($xero_tenant_id, $employee_id, $pay_template_earning_id);
    }
    /**
     * Operation deleteEmployeeEarningsTemplateWithHttpInfo
     * Deletes a specific employee's earnings template record
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  string $pay_template_earning_id Id for single pay template earnings object (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteEmployeeEarningsTemplateWithHttpInfo($xero_tenant_id, $employee_id, $pay_template_earning_id)
    {
        $request = $this->deleteEmployeeEarningsTemplateRequest($xero_tenant_id, $employee_id, $pay_template_earning_id);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }
    /**
     * Operation deleteEmployeeEarningsTemplateAsync
     * Deletes a specific employee's earnings template record
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  string $pay_template_earning_id Id for single pay template earnings object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteEmployeeEarningsTemplateAsync($xero_tenant_id, $employee_id, $pay_template_earning_id)
    {
        return $this->deleteEmployeeEarningsTemplateAsyncWithHttpInfo($xero_tenant_id, $employee_id, $pay_template_earning_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation deleteEmployeeEarningsTemplateAsyncWithHttpInfo
     * Deletes a specific employee's earnings template record
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  string $pay_template_earning_id Id for single pay template earnings object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function deleteEmployeeEarningsTemplateAsyncWithHttpInfo($xero_tenant_id, $employee_id, $pay_template_earning_id)
    {
        $returnType = '';
        $request = $this->deleteEmployeeEarningsTemplateRequest($xero_tenant_id, $employee_id, $pay_template_earning_id);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteEmployeeEarningsTemplate'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  string $pay_template_earning_id Id for single pay template earnings object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function deleteEmployeeEarningsTemplateRequest($xero_tenant_id, $employee_id, $pay_template_earning_id)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling deleteEmployeeEarningsTemplate'
            );
        }
        // verify the required parameter 'employee_id' is set
        if ($employee_id === null || (is_array($employee_id) && count($employee_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $employee_id when calling deleteEmployeeEarningsTemplate'
            );
        }
        // verify the required parameter 'pay_template_earning_id' is set
        if ($pay_template_earning_id === null || (is_array($pay_template_earning_id) && count($pay_template_earning_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $pay_template_earning_id when calling deleteEmployeeEarningsTemplate'
            );
        }
        $resourcePath = '/Employees/{EmployeeID}/PayTemplates/earnings/{PayTemplateEarningID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollUkObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // path params
        if ($employee_id !== null) {
            $resourcePath = str_replace(
                '{' . 'EmployeeID' . '}',
                PayrollUkObjectSerializer::toPathValue($employee_id),
                $resourcePath
            );
        }
        // path params
        if ($pay_template_earning_id !== null) {
            $resourcePath = str_replace(
                '{' . 'PayTemplateEarningID' . '}',
                PayrollUkObjectSerializer::toPathValue($pay_template_earning_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                []
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                [],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollUkObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'DELETE',
            $this->config->getHostPayrollUk() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteEmployeeLeave
     * Deletes a specific employee's leave record
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  string $leave_id Leave id for single object (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollUk\EmployeeLeaveObject
     */
    public function deleteEmployeeLeave($xero_tenant_id, $employee_id, $leave_id)
    {
        list($response) = $this->deleteEmployeeLeaveWithHttpInfo($xero_tenant_id, $employee_id, $leave_id);
        return $response;
    }
    /**
     * Operation deleteEmployeeLeaveWithHttpInfo
     * Deletes a specific employee's leave record
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  string $leave_id Leave id for single object (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollUk\EmployeeLeaveObject, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteEmployeeLeaveWithHttpInfo($xero_tenant_id, $employee_id, $leave_id)
    {
        $request = $this->deleteEmployeeLeaveRequest($xero_tenant_id, $employee_id, $leave_id);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollUk\EmployeeLeaveObject' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollUk\EmployeeLeaveObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\EmployeeLeaveObject';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollUkObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollUk\EmployeeLeaveObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation deleteEmployeeLeaveAsync
     * Deletes a specific employee's leave record
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  string $leave_id Leave id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteEmployeeLeaveAsync($xero_tenant_id, $employee_id, $leave_id)
    {
        return $this->deleteEmployeeLeaveAsyncWithHttpInfo($xero_tenant_id, $employee_id, $leave_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation deleteEmployeeLeaveAsyncWithHttpInfo
     * Deletes a specific employee's leave record
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  string $leave_id Leave id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function deleteEmployeeLeaveAsyncWithHttpInfo($xero_tenant_id, $employee_id, $leave_id)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\EmployeeLeaveObject';
        $request = $this->deleteEmployeeLeaveRequest($xero_tenant_id, $employee_id, $leave_id);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteEmployeeLeave'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  string $leave_id Leave id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function deleteEmployeeLeaveRequest($xero_tenant_id, $employee_id, $leave_id)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling deleteEmployeeLeave'
            );
        }
        // verify the required parameter 'employee_id' is set
        if ($employee_id === null || (is_array($employee_id) && count($employee_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $employee_id when calling deleteEmployeeLeave'
            );
        }
        // verify the required parameter 'leave_id' is set
        if ($leave_id === null || (is_array($leave_id) && count($leave_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $leave_id when calling deleteEmployeeLeave'
            );
        }
        $resourcePath = '/Employees/{EmployeeID}/Leave/{LeaveID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollUkObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // path params
        if ($employee_id !== null) {
            $resourcePath = str_replace(
                '{' . 'EmployeeID' . '}',
                PayrollUkObjectSerializer::toPathValue($employee_id),
                $resourcePath
            );
        }
        // path params
        if ($leave_id !== null) {
            $resourcePath = str_replace(
                '{' . 'LeaveID' . '}',
                PayrollUkObjectSerializer::toPathValue($leave_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollUkObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'DELETE',
            $this->config->getHostPayrollUk() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteEmployeeSalaryAndWage
     * Deletes a salary and wages record for a specific employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  string $salary_and_wages_id Id for single salary and wages object (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteEmployeeSalaryAndWage($xero_tenant_id, $employee_id, $salary_and_wages_id)
    {
        $this->deleteEmployeeSalaryAndWageWithHttpInfo($xero_tenant_id, $employee_id, $salary_and_wages_id);
    }
    /**
     * Operation deleteEmployeeSalaryAndWageWithHttpInfo
     * Deletes a salary and wages record for a specific employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  string $salary_and_wages_id Id for single salary and wages object (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteEmployeeSalaryAndWageWithHttpInfo($xero_tenant_id, $employee_id, $salary_and_wages_id)
    {
        $request = $this->deleteEmployeeSalaryAndWageRequest($xero_tenant_id, $employee_id, $salary_and_wages_id);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            return [null, $statusCode, $response->getHeaders()];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }
    /**
     * Operation deleteEmployeeSalaryAndWageAsync
     * Deletes a salary and wages record for a specific employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  string $salary_and_wages_id Id for single salary and wages object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteEmployeeSalaryAndWageAsync($xero_tenant_id, $employee_id, $salary_and_wages_id)
    {
        return $this->deleteEmployeeSalaryAndWageAsyncWithHttpInfo($xero_tenant_id, $employee_id, $salary_and_wages_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation deleteEmployeeSalaryAndWageAsyncWithHttpInfo
     * Deletes a salary and wages record for a specific employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  string $salary_and_wages_id Id for single salary and wages object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function deleteEmployeeSalaryAndWageAsyncWithHttpInfo($xero_tenant_id, $employee_id, $salary_and_wages_id)
    {
        $returnType = '';
        $request = $this->deleteEmployeeSalaryAndWageRequest($xero_tenant_id, $employee_id, $salary_and_wages_id);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteEmployeeSalaryAndWage'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  string $salary_and_wages_id Id for single salary and wages object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function deleteEmployeeSalaryAndWageRequest($xero_tenant_id, $employee_id, $salary_and_wages_id)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling deleteEmployeeSalaryAndWage'
            );
        }
        // verify the required parameter 'employee_id' is set
        if ($employee_id === null || (is_array($employee_id) && count($employee_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $employee_id when calling deleteEmployeeSalaryAndWage'
            );
        }
        // verify the required parameter 'salary_and_wages_id' is set
        if ($salary_and_wages_id === null || (is_array($salary_and_wages_id) && count($salary_and_wages_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $salary_and_wages_id when calling deleteEmployeeSalaryAndWage'
            );
        }
        $resourcePath = '/Employees/{EmployeeID}/SalaryAndWages/{SalaryAndWagesID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollUkObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // path params
        if ($employee_id !== null) {
            $resourcePath = str_replace(
                '{' . 'EmployeeID' . '}',
                PayrollUkObjectSerializer::toPathValue($employee_id),
                $resourcePath
            );
        }
        // path params
        if ($salary_and_wages_id !== null) {
            $resourcePath = str_replace(
                '{' . 'SalaryAndWagesID' . '}',
                PayrollUkObjectSerializer::toPathValue($salary_and_wages_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                []
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                [],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollUkObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'DELETE',
            $this->config->getHostPayrollUk() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteTimesheet
     * Deletes a specific timesheet
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $timesheet_id Identifier for the timesheet (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollUk\TimesheetLine|\XeroAPI\XeroPHP\Models\PayrollUk\Problem
     */
    public function deleteTimesheet($xero_tenant_id, $timesheet_id)
    {
        list($response) = $this->deleteTimesheetWithHttpInfo($xero_tenant_id, $timesheet_id);
        return $response;
    }
    /**
     * Operation deleteTimesheetWithHttpInfo
     * Deletes a specific timesheet
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $timesheet_id Identifier for the timesheet (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollUk\TimesheetLine|\XeroAPI\XeroPHP\Models\PayrollUk\Problem, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteTimesheetWithHttpInfo($xero_tenant_id, $timesheet_id)
    {
        $request = $this->deleteTimesheetRequest($xero_tenant_id, $timesheet_id);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollUk\TimesheetLine' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollUk\TimesheetLine', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\XeroAPI\XeroPHP\Models\PayrollUk\Problem' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollUk\Problem', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\TimesheetLine';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollUkObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollUk\TimesheetLine',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = PayrollUkObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollUk\Problem',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation deleteTimesheetAsync
     * Deletes a specific timesheet
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $timesheet_id Identifier for the timesheet (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteTimesheetAsync($xero_tenant_id, $timesheet_id)
    {
        return $this->deleteTimesheetAsyncWithHttpInfo($xero_tenant_id, $timesheet_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation deleteTimesheetAsyncWithHttpInfo
     * Deletes a specific timesheet
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $timesheet_id Identifier for the timesheet (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function deleteTimesheetAsyncWithHttpInfo($xero_tenant_id, $timesheet_id)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\TimesheetLine';
        $request = $this->deleteTimesheetRequest($xero_tenant_id, $timesheet_id);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteTimesheet'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $timesheet_id Identifier for the timesheet (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function deleteTimesheetRequest($xero_tenant_id, $timesheet_id)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling deleteTimesheet'
            );
        }
        // verify the required parameter 'timesheet_id' is set
        if ($timesheet_id === null || (is_array($timesheet_id) && count($timesheet_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $timesheet_id when calling deleteTimesheet'
            );
        }
        $resourcePath = '/Timesheets/{TimesheetID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollUkObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // path params
        if ($timesheet_id !== null) {
            $resourcePath = str_replace(
                '{' . 'TimesheetID' . '}',
                PayrollUkObjectSerializer::toPathValue($timesheet_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollUkObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'DELETE',
            $this->config->getHostPayrollUk() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteTimesheetLine
     * Deletes a specific timesheet line
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $timesheet_id Identifier for the timesheet (required)
     * @param  string $timesheet_line_id Identifier for the timesheet line (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollUk\TimesheetLine|\XeroAPI\XeroPHP\Models\PayrollUk\Problem
     */
    public function deleteTimesheetLine($xero_tenant_id, $timesheet_id, $timesheet_line_id)
    {
        list($response) = $this->deleteTimesheetLineWithHttpInfo($xero_tenant_id, $timesheet_id, $timesheet_line_id);
        return $response;
    }
    /**
     * Operation deleteTimesheetLineWithHttpInfo
     * Deletes a specific timesheet line
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $timesheet_id Identifier for the timesheet (required)
     * @param  string $timesheet_line_id Identifier for the timesheet line (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollUk\TimesheetLine|\XeroAPI\XeroPHP\Models\PayrollUk\Problem, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteTimesheetLineWithHttpInfo($xero_tenant_id, $timesheet_id, $timesheet_line_id)
    {
        $request = $this->deleteTimesheetLineRequest($xero_tenant_id, $timesheet_id, $timesheet_line_id);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollUk\TimesheetLine' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollUk\TimesheetLine', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\XeroAPI\XeroPHP\Models\PayrollUk\Problem' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollUk\Problem', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\TimesheetLine';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollUkObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollUk\TimesheetLine',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = PayrollUkObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollUk\Problem',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation deleteTimesheetLineAsync
     * Deletes a specific timesheet line
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $timesheet_id Identifier for the timesheet (required)
     * @param  string $timesheet_line_id Identifier for the timesheet line (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteTimesheetLineAsync($xero_tenant_id, $timesheet_id, $timesheet_line_id)
    {
        return $this->deleteTimesheetLineAsyncWithHttpInfo($xero_tenant_id, $timesheet_id, $timesheet_line_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation deleteTimesheetLineAsyncWithHttpInfo
     * Deletes a specific timesheet line
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $timesheet_id Identifier for the timesheet (required)
     * @param  string $timesheet_line_id Identifier for the timesheet line (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function deleteTimesheetLineAsyncWithHttpInfo($xero_tenant_id, $timesheet_id, $timesheet_line_id)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\TimesheetLine';
        $request = $this->deleteTimesheetLineRequest($xero_tenant_id, $timesheet_id, $timesheet_line_id);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteTimesheetLine'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $timesheet_id Identifier for the timesheet (required)
     * @param  string $timesheet_line_id Identifier for the timesheet line (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function deleteTimesheetLineRequest($xero_tenant_id, $timesheet_id, $timesheet_line_id)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling deleteTimesheetLine'
            );
        }
        // verify the required parameter 'timesheet_id' is set
        if ($timesheet_id === null || (is_array($timesheet_id) && count($timesheet_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $timesheet_id when calling deleteTimesheetLine'
            );
        }
        // verify the required parameter 'timesheet_line_id' is set
        if ($timesheet_line_id === null || (is_array($timesheet_line_id) && count($timesheet_line_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $timesheet_line_id when calling deleteTimesheetLine'
            );
        }
        $resourcePath = '/Timesheets/{TimesheetID}/Lines/{TimesheetLineID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollUkObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // path params
        if ($timesheet_id !== null) {
            $resourcePath = str_replace(
                '{' . 'TimesheetID' . '}',
                PayrollUkObjectSerializer::toPathValue($timesheet_id),
                $resourcePath
            );
        }
        // path params
        if ($timesheet_line_id !== null) {
            $resourcePath = str_replace(
                '{' . 'TimesheetLineID' . '}',
                PayrollUkObjectSerializer::toPathValue($timesheet_line_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollUkObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'DELETE',
            $this->config->getHostPayrollUk() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getBenefit
     * Retrieves a specific benefit by using a unique benefit ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $id Identifier for the benefit (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollUk\BenefitObject
     */
    public function getBenefit($xero_tenant_id, $id)
    {
        list($response) = $this->getBenefitWithHttpInfo($xero_tenant_id, $id);
        return $response;
    }
    /**
     * Operation getBenefitWithHttpInfo
     * Retrieves a specific benefit by using a unique benefit ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $id Identifier for the benefit (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollUk\BenefitObject, HTTP status code, HTTP response headers (array of strings)
     */
    public function getBenefitWithHttpInfo($xero_tenant_id, $id)
    {
        $request = $this->getBenefitRequest($xero_tenant_id, $id);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollUk\BenefitObject' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollUk\BenefitObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\BenefitObject';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollUkObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollUk\BenefitObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getBenefitAsync
     * Retrieves a specific benefit by using a unique benefit ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $id Identifier for the benefit (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getBenefitAsync($xero_tenant_id, $id)
    {
        return $this->getBenefitAsyncWithHttpInfo($xero_tenant_id, $id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getBenefitAsyncWithHttpInfo
     * Retrieves a specific benefit by using a unique benefit ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $id Identifier for the benefit (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getBenefitAsyncWithHttpInfo($xero_tenant_id, $id)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\BenefitObject';
        $request = $this->getBenefitRequest($xero_tenant_id, $id);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getBenefit'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $id Identifier for the benefit (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getBenefitRequest($xero_tenant_id, $id)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getBenefit'
            );
        }
        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling getBenefit'
            );
        }
        $resourcePath = '/Benefits/{id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollUkObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                PayrollUkObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollUkObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHostPayrollUk() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getBenefits
     * Retrieves employee benefits
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollUk\Benefits
     */
    public function getBenefits($xero_tenant_id, $page = null)
    {
        list($response) = $this->getBenefitsWithHttpInfo($xero_tenant_id, $page);
        return $response;
    }
    /**
     * Operation getBenefitsWithHttpInfo
     * Retrieves employee benefits
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollUk\Benefits, HTTP status code, HTTP response headers (array of strings)
     */
    public function getBenefitsWithHttpInfo($xero_tenant_id, $page = null)
    {
        $request = $this->getBenefitsRequest($xero_tenant_id, $page);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollUk\Benefits' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollUk\Benefits', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\Benefits';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollUkObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollUk\Benefits',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getBenefitsAsync
     * Retrieves employee benefits
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getBenefitsAsync($xero_tenant_id, $page = null)
    {
        return $this->getBenefitsAsyncWithHttpInfo($xero_tenant_id, $page)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getBenefitsAsyncWithHttpInfo
     * Retrieves employee benefits
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getBenefitsAsyncWithHttpInfo($xero_tenant_id, $page = null)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\Benefits';
        $request = $this->getBenefitsRequest($xero_tenant_id, $page);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getBenefits'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getBenefitsRequest($xero_tenant_id, $page = null)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getBenefits'
            );
        }
        $resourcePath = '/Benefits';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // query params
        if ($page !== null) {
            $queryParams['page'] = PayrollUkObjectSerializer::toQueryValue($page);
        }
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollUkObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollUkObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHostPayrollUk() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getDeduction
     * Retrieves a specific deduction by using a unique deduction ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $deduction_id Identifier for the deduction (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollUk\DeductionObject
     */
    public function getDeduction($xero_tenant_id, $deduction_id)
    {
        list($response) = $this->getDeductionWithHttpInfo($xero_tenant_id, $deduction_id);
        return $response;
    }
    /**
     * Operation getDeductionWithHttpInfo
     * Retrieves a specific deduction by using a unique deduction ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $deduction_id Identifier for the deduction (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollUk\DeductionObject, HTTP status code, HTTP response headers (array of strings)
     */
    public function getDeductionWithHttpInfo($xero_tenant_id, $deduction_id)
    {
        $request = $this->getDeductionRequest($xero_tenant_id, $deduction_id);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollUk\DeductionObject' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollUk\DeductionObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\DeductionObject';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollUkObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollUk\DeductionObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getDeductionAsync
     * Retrieves a specific deduction by using a unique deduction ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $deduction_id Identifier for the deduction (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getDeductionAsync($xero_tenant_id, $deduction_id)
    {
        return $this->getDeductionAsyncWithHttpInfo($xero_tenant_id, $deduction_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getDeductionAsyncWithHttpInfo
     * Retrieves a specific deduction by using a unique deduction ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $deduction_id Identifier for the deduction (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getDeductionAsyncWithHttpInfo($xero_tenant_id, $deduction_id)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\DeductionObject';
        $request = $this->getDeductionRequest($xero_tenant_id, $deduction_id);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getDeduction'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $deduction_id Identifier for the deduction (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getDeductionRequest($xero_tenant_id, $deduction_id)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getDeduction'
            );
        }
        // verify the required parameter 'deduction_id' is set
        if ($deduction_id === null || (is_array($deduction_id) && count($deduction_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $deduction_id when calling getDeduction'
            );
        }
        $resourcePath = '/Deductions/{deductionId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollUkObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // path params
        if ($deduction_id !== null) {
            $resourcePath = str_replace(
                '{' . 'deductionId' . '}',
                PayrollUkObjectSerializer::toPathValue($deduction_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollUkObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHostPayrollUk() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getDeductions
     * Retrieves deductions
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollUk\Deductions
     */
    public function getDeductions($xero_tenant_id, $page = null)
    {
        list($response) = $this->getDeductionsWithHttpInfo($xero_tenant_id, $page);
        return $response;
    }
    /**
     * Operation getDeductionsWithHttpInfo
     * Retrieves deductions
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollUk\Deductions, HTTP status code, HTTP response headers (array of strings)
     */
    public function getDeductionsWithHttpInfo($xero_tenant_id, $page = null)
    {
        $request = $this->getDeductionsRequest($xero_tenant_id, $page);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollUk\Deductions' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollUk\Deductions', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\Deductions';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollUkObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollUk\Deductions',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getDeductionsAsync
     * Retrieves deductions
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getDeductionsAsync($xero_tenant_id, $page = null)
    {
        return $this->getDeductionsAsyncWithHttpInfo($xero_tenant_id, $page)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getDeductionsAsyncWithHttpInfo
     * Retrieves deductions
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getDeductionsAsyncWithHttpInfo($xero_tenant_id, $page = null)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\Deductions';
        $request = $this->getDeductionsRequest($xero_tenant_id, $page);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getDeductions'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getDeductionsRequest($xero_tenant_id, $page = null)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getDeductions'
            );
        }
        $resourcePath = '/Deductions';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // query params
        if ($page !== null) {
            $queryParams['page'] = PayrollUkObjectSerializer::toQueryValue($page);
        }
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollUkObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollUkObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHostPayrollUk() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getEarningsOrder
     * Retrieves a specific earnings orders by using a unique earnings orders id
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $id Identifier for the deduction (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollUk\EarningsOrderObject
     */
    public function getEarningsOrder($xero_tenant_id, $id)
    {
        list($response) = $this->getEarningsOrderWithHttpInfo($xero_tenant_id, $id);
        return $response;
    }
    /**
     * Operation getEarningsOrderWithHttpInfo
     * Retrieves a specific earnings orders by using a unique earnings orders id
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $id Identifier for the deduction (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollUk\EarningsOrderObject, HTTP status code, HTTP response headers (array of strings)
     */
    public function getEarningsOrderWithHttpInfo($xero_tenant_id, $id)
    {
        $request = $this->getEarningsOrderRequest($xero_tenant_id, $id);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollUk\EarningsOrderObject' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollUk\EarningsOrderObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\EarningsOrderObject';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollUkObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollUk\EarningsOrderObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getEarningsOrderAsync
     * Retrieves a specific earnings orders by using a unique earnings orders id
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $id Identifier for the deduction (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getEarningsOrderAsync($xero_tenant_id, $id)
    {
        return $this->getEarningsOrderAsyncWithHttpInfo($xero_tenant_id, $id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getEarningsOrderAsyncWithHttpInfo
     * Retrieves a specific earnings orders by using a unique earnings orders id
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $id Identifier for the deduction (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getEarningsOrderAsyncWithHttpInfo($xero_tenant_id, $id)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\EarningsOrderObject';
        $request = $this->getEarningsOrderRequest($xero_tenant_id, $id);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getEarningsOrder'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $id Identifier for the deduction (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getEarningsOrderRequest($xero_tenant_id, $id)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getEarningsOrder'
            );
        }
        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling getEarningsOrder'
            );
        }
        $resourcePath = '/EarningsOrders/{id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollUkObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                PayrollUkObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollUkObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHostPayrollUk() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getEarningsOrders
     * Retrieves earnings orders
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollUk\EarningsOrders
     */
    public function getEarningsOrders($xero_tenant_id, $page = null)
    {
        list($response) = $this->getEarningsOrdersWithHttpInfo($xero_tenant_id, $page);
        return $response;
    }
    /**
     * Operation getEarningsOrdersWithHttpInfo
     * Retrieves earnings orders
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollUk\EarningsOrders, HTTP status code, HTTP response headers (array of strings)
     */
    public function getEarningsOrdersWithHttpInfo($xero_tenant_id, $page = null)
    {
        $request = $this->getEarningsOrdersRequest($xero_tenant_id, $page);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollUk\EarningsOrders' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollUk\EarningsOrders', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\EarningsOrders';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollUkObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollUk\EarningsOrders',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getEarningsOrdersAsync
     * Retrieves earnings orders
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getEarningsOrdersAsync($xero_tenant_id, $page = null)
    {
        return $this->getEarningsOrdersAsyncWithHttpInfo($xero_tenant_id, $page)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getEarningsOrdersAsyncWithHttpInfo
     * Retrieves earnings orders
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getEarningsOrdersAsyncWithHttpInfo($xero_tenant_id, $page = null)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\EarningsOrders';
        $request = $this->getEarningsOrdersRequest($xero_tenant_id, $page);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getEarningsOrders'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getEarningsOrdersRequest($xero_tenant_id, $page = null)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getEarningsOrders'
            );
        }
        $resourcePath = '/EarningsOrders';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // query params
        if ($page !== null) {
            $queryParams['page'] = PayrollUkObjectSerializer::toQueryValue($page);
        }
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollUkObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollUkObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHostPayrollUk() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getEarningsRate
     * Retrieves a specific earnings rates by using a unique earnings rate id
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $earnings_rate_id Identifier for the earnings rate (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollUk\EarningsRateObject
     */
    public function getEarningsRate($xero_tenant_id, $earnings_rate_id)
    {
        list($response) = $this->getEarningsRateWithHttpInfo($xero_tenant_id, $earnings_rate_id);
        return $response;
    }
    /**
     * Operation getEarningsRateWithHttpInfo
     * Retrieves a specific earnings rates by using a unique earnings rate id
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $earnings_rate_id Identifier for the earnings rate (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollUk\EarningsRateObject, HTTP status code, HTTP response headers (array of strings)
     */
    public function getEarningsRateWithHttpInfo($xero_tenant_id, $earnings_rate_id)
    {
        $request = $this->getEarningsRateRequest($xero_tenant_id, $earnings_rate_id);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollUk\EarningsRateObject' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollUk\EarningsRateObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\EarningsRateObject';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollUkObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollUk\EarningsRateObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getEarningsRateAsync
     * Retrieves a specific earnings rates by using a unique earnings rate id
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $earnings_rate_id Identifier for the earnings rate (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getEarningsRateAsync($xero_tenant_id, $earnings_rate_id)
    {
        return $this->getEarningsRateAsyncWithHttpInfo($xero_tenant_id, $earnings_rate_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getEarningsRateAsyncWithHttpInfo
     * Retrieves a specific earnings rates by using a unique earnings rate id
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $earnings_rate_id Identifier for the earnings rate (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getEarningsRateAsyncWithHttpInfo($xero_tenant_id, $earnings_rate_id)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\EarningsRateObject';
        $request = $this->getEarningsRateRequest($xero_tenant_id, $earnings_rate_id);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getEarningsRate'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $earnings_rate_id Identifier for the earnings rate (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getEarningsRateRequest($xero_tenant_id, $earnings_rate_id)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getEarningsRate'
            );
        }
        // verify the required parameter 'earnings_rate_id' is set
        if ($earnings_rate_id === null || (is_array($earnings_rate_id) && count($earnings_rate_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $earnings_rate_id when calling getEarningsRate'
            );
        }
        $resourcePath = '/EarningsRates/{EarningsRateID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollUkObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // path params
        if ($earnings_rate_id !== null) {
            $resourcePath = str_replace(
                '{' . 'EarningsRateID' . '}',
                PayrollUkObjectSerializer::toPathValue($earnings_rate_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollUkObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHostPayrollUk() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getEarningsRates
     * Retrieves earnings rates
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollUk\EarningsRates
     */
    public function getEarningsRates($xero_tenant_id, $page = null)
    {
        list($response) = $this->getEarningsRatesWithHttpInfo($xero_tenant_id, $page);
        return $response;
    }
    /**
     * Operation getEarningsRatesWithHttpInfo
     * Retrieves earnings rates
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollUk\EarningsRates, HTTP status code, HTTP response headers (array of strings)
     */
    public function getEarningsRatesWithHttpInfo($xero_tenant_id, $page = null)
    {
        $request = $this->getEarningsRatesRequest($xero_tenant_id, $page);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollUk\EarningsRates' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollUk\EarningsRates', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\EarningsRates';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollUkObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollUk\EarningsRates',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getEarningsRatesAsync
     * Retrieves earnings rates
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getEarningsRatesAsync($xero_tenant_id, $page = null)
    {
        return $this->getEarningsRatesAsyncWithHttpInfo($xero_tenant_id, $page)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getEarningsRatesAsyncWithHttpInfo
     * Retrieves earnings rates
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getEarningsRatesAsyncWithHttpInfo($xero_tenant_id, $page = null)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\EarningsRates';
        $request = $this->getEarningsRatesRequest($xero_tenant_id, $page);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getEarningsRates'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getEarningsRatesRequest($xero_tenant_id, $page = null)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getEarningsRates'
            );
        }
        $resourcePath = '/EarningsRates';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // query params
        if ($page !== null) {
            $queryParams['page'] = PayrollUkObjectSerializer::toQueryValue($page);
        }
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollUkObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollUkObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHostPayrollUk() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getEmployee
     * Retrieves specific employees by using a unique employee ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollUk\EmployeeObject
     */
    public function getEmployee($xero_tenant_id, $employee_id)
    {
        list($response) = $this->getEmployeeWithHttpInfo($xero_tenant_id, $employee_id);
        return $response;
    }
    /**
     * Operation getEmployeeWithHttpInfo
     * Retrieves specific employees by using a unique employee ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollUk\EmployeeObject, HTTP status code, HTTP response headers (array of strings)
     */
    public function getEmployeeWithHttpInfo($xero_tenant_id, $employee_id)
    {
        $request = $this->getEmployeeRequest($xero_tenant_id, $employee_id);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollUk\EmployeeObject' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollUk\EmployeeObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\EmployeeObject';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollUkObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollUk\EmployeeObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getEmployeeAsync
     * Retrieves specific employees by using a unique employee ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getEmployeeAsync($xero_tenant_id, $employee_id)
    {
        return $this->getEmployeeAsyncWithHttpInfo($xero_tenant_id, $employee_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getEmployeeAsyncWithHttpInfo
     * Retrieves specific employees by using a unique employee ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getEmployeeAsyncWithHttpInfo($xero_tenant_id, $employee_id)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\EmployeeObject';
        $request = $this->getEmployeeRequest($xero_tenant_id, $employee_id);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getEmployee'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getEmployeeRequest($xero_tenant_id, $employee_id)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getEmployee'
            );
        }
        // verify the required parameter 'employee_id' is set
        if ($employee_id === null || (is_array($employee_id) && count($employee_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $employee_id when calling getEmployee'
            );
        }
        $resourcePath = '/Employees/{EmployeeID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollUkObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // path params
        if ($employee_id !== null) {
            $resourcePath = str_replace(
                '{' . 'EmployeeID' . '}',
                PayrollUkObjectSerializer::toPathValue($employee_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollUkObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHostPayrollUk() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getEmployeeLeave
     * Retrieves a specific employee's leave record using a unique employee ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  string $leave_id Leave id for single object (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollUk\EmployeeLeaveObject
     */
    public function getEmployeeLeave($xero_tenant_id, $employee_id, $leave_id)
    {
        list($response) = $this->getEmployeeLeaveWithHttpInfo($xero_tenant_id, $employee_id, $leave_id);
        return $response;
    }
    /**
     * Operation getEmployeeLeaveWithHttpInfo
     * Retrieves a specific employee's leave record using a unique employee ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  string $leave_id Leave id for single object (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollUk\EmployeeLeaveObject, HTTP status code, HTTP response headers (array of strings)
     */
    public function getEmployeeLeaveWithHttpInfo($xero_tenant_id, $employee_id, $leave_id)
    {
        $request = $this->getEmployeeLeaveRequest($xero_tenant_id, $employee_id, $leave_id);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollUk\EmployeeLeaveObject' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollUk\EmployeeLeaveObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\EmployeeLeaveObject';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollUkObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollUk\EmployeeLeaveObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getEmployeeLeaveAsync
     * Retrieves a specific employee's leave record using a unique employee ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  string $leave_id Leave id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getEmployeeLeaveAsync($xero_tenant_id, $employee_id, $leave_id)
    {
        return $this->getEmployeeLeaveAsyncWithHttpInfo($xero_tenant_id, $employee_id, $leave_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getEmployeeLeaveAsyncWithHttpInfo
     * Retrieves a specific employee's leave record using a unique employee ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  string $leave_id Leave id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getEmployeeLeaveAsyncWithHttpInfo($xero_tenant_id, $employee_id, $leave_id)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\EmployeeLeaveObject';
        $request = $this->getEmployeeLeaveRequest($xero_tenant_id, $employee_id, $leave_id);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getEmployeeLeave'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  string $leave_id Leave id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getEmployeeLeaveRequest($xero_tenant_id, $employee_id, $leave_id)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getEmployeeLeave'
            );
        }
        // verify the required parameter 'employee_id' is set
        if ($employee_id === null || (is_array($employee_id) && count($employee_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $employee_id when calling getEmployeeLeave'
            );
        }
        // verify the required parameter 'leave_id' is set
        if ($leave_id === null || (is_array($leave_id) && count($leave_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $leave_id when calling getEmployeeLeave'
            );
        }
        $resourcePath = '/Employees/{EmployeeID}/Leave/{LeaveID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollUkObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // path params
        if ($employee_id !== null) {
            $resourcePath = str_replace(
                '{' . 'EmployeeID' . '}',
                PayrollUkObjectSerializer::toPathValue($employee_id),
                $resourcePath
            );
        }
        // path params
        if ($leave_id !== null) {
            $resourcePath = str_replace(
                '{' . 'LeaveID' . '}',
                PayrollUkObjectSerializer::toPathValue($leave_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollUkObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHostPayrollUk() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getEmployeeLeaveBalances
     * Retrieves a specific employee's leave balances using a unique employee ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollUk\EmployeeLeaveBalances
     */
    public function getEmployeeLeaveBalances($xero_tenant_id, $employee_id)
    {
        list($response) = $this->getEmployeeLeaveBalancesWithHttpInfo($xero_tenant_id, $employee_id);
        return $response;
    }
    /**
     * Operation getEmployeeLeaveBalancesWithHttpInfo
     * Retrieves a specific employee's leave balances using a unique employee ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollUk\EmployeeLeaveBalances, HTTP status code, HTTP response headers (array of strings)
     */
    public function getEmployeeLeaveBalancesWithHttpInfo($xero_tenant_id, $employee_id)
    {
        $request = $this->getEmployeeLeaveBalancesRequest($xero_tenant_id, $employee_id);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollUk\EmployeeLeaveBalances' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollUk\EmployeeLeaveBalances', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\EmployeeLeaveBalances';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollUkObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollUk\EmployeeLeaveBalances',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getEmployeeLeaveBalancesAsync
     * Retrieves a specific employee's leave balances using a unique employee ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getEmployeeLeaveBalancesAsync($xero_tenant_id, $employee_id)
    {
        return $this->getEmployeeLeaveBalancesAsyncWithHttpInfo($xero_tenant_id, $employee_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getEmployeeLeaveBalancesAsyncWithHttpInfo
     * Retrieves a specific employee's leave balances using a unique employee ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getEmployeeLeaveBalancesAsyncWithHttpInfo($xero_tenant_id, $employee_id)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\EmployeeLeaveBalances';
        $request = $this->getEmployeeLeaveBalancesRequest($xero_tenant_id, $employee_id);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getEmployeeLeaveBalances'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getEmployeeLeaveBalancesRequest($xero_tenant_id, $employee_id)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getEmployeeLeaveBalances'
            );
        }
        // verify the required parameter 'employee_id' is set
        if ($employee_id === null || (is_array($employee_id) && count($employee_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $employee_id when calling getEmployeeLeaveBalances'
            );
        }
        $resourcePath = '/Employees/{EmployeeID}/LeaveBalances';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollUkObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // path params
        if ($employee_id !== null) {
            $resourcePath = str_replace(
                '{' . 'EmployeeID' . '}',
                PayrollUkObjectSerializer::toPathValue($employee_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollUkObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHostPayrollUk() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getEmployeeLeavePeriods
     * Retrieves a specific employee's leave periods using a unique employee ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \DateTime $start_date Filter by start date (optional)
     * @param  \DateTime $end_date Filter by end date (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollUk\LeavePeriods|\XeroAPI\XeroPHP\Models\PayrollUk\Problem
     */
    public function getEmployeeLeavePeriods($xero_tenant_id, $employee_id, $start_date = null, $end_date = null)
    {
        list($response) = $this->getEmployeeLeavePeriodsWithHttpInfo($xero_tenant_id, $employee_id, $start_date, $end_date);
        return $response;
    }
    /**
     * Operation getEmployeeLeavePeriodsWithHttpInfo
     * Retrieves a specific employee's leave periods using a unique employee ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \DateTime $start_date Filter by start date (optional)
     * @param  \DateTime $end_date Filter by end date (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollUk\LeavePeriods|\XeroAPI\XeroPHP\Models\PayrollUk\Problem, HTTP status code, HTTP response headers (array of strings)
     */
    public function getEmployeeLeavePeriodsWithHttpInfo($xero_tenant_id, $employee_id, $start_date = null, $end_date = null)
    {
        $request = $this->getEmployeeLeavePeriodsRequest($xero_tenant_id, $employee_id, $start_date, $end_date);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollUk\LeavePeriods' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollUk\LeavePeriods', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\XeroAPI\XeroPHP\Models\PayrollUk\Problem' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollUk\Problem', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\LeavePeriods';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollUkObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollUk\LeavePeriods',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = PayrollUkObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollUk\Problem',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getEmployeeLeavePeriodsAsync
     * Retrieves a specific employee's leave periods using a unique employee ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \DateTime $start_date Filter by start date (optional)
     * @param  \DateTime $end_date Filter by end date (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getEmployeeLeavePeriodsAsync($xero_tenant_id, $employee_id, $start_date = null, $end_date = null)
    {
        return $this->getEmployeeLeavePeriodsAsyncWithHttpInfo($xero_tenant_id, $employee_id, $start_date, $end_date)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getEmployeeLeavePeriodsAsyncWithHttpInfo
     * Retrieves a specific employee's leave periods using a unique employee ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \DateTime $start_date Filter by start date (optional)
     * @param  \DateTime $end_date Filter by end date (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getEmployeeLeavePeriodsAsyncWithHttpInfo($xero_tenant_id, $employee_id, $start_date = null, $end_date = null)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\LeavePeriods';
        $request = $this->getEmployeeLeavePeriodsRequest($xero_tenant_id, $employee_id, $start_date, $end_date);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getEmployeeLeavePeriods'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \DateTime $start_date Filter by start date (optional)
     * @param  \DateTime $end_date Filter by end date (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getEmployeeLeavePeriodsRequest($xero_tenant_id, $employee_id, $start_date = null, $end_date = null)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getEmployeeLeavePeriods'
            );
        }
        // verify the required parameter 'employee_id' is set
        if ($employee_id === null || (is_array($employee_id) && count($employee_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $employee_id when calling getEmployeeLeavePeriods'
            );
        }
        $resourcePath = '/Employees/{EmployeeID}/LeavePeriods';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // query params
        if ($start_date !== null) {
            $queryParams['startDate'] = PayrollUkObjectSerializer::toQueryValue($start_date);
        }
        // query params
        if ($end_date !== null) {
            $queryParams['endDate'] = PayrollUkObjectSerializer::toQueryValue($end_date);
        }
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollUkObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // path params
        if ($employee_id !== null) {
            $resourcePath = str_replace(
                '{' . 'EmployeeID' . '}',
                PayrollUkObjectSerializer::toPathValue($employee_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollUkObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHostPayrollUk() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getEmployeeLeaveTypes
     * Retrieves a specific employee's leave types using a unique employee ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollUk\EmployeeLeaveTypes|\XeroAPI\XeroPHP\Models\PayrollUk\Problem
     */
    public function getEmployeeLeaveTypes($xero_tenant_id, $employee_id)
    {
        list($response) = $this->getEmployeeLeaveTypesWithHttpInfo($xero_tenant_id, $employee_id);
        return $response;
    }
    /**
     * Operation getEmployeeLeaveTypesWithHttpInfo
     * Retrieves a specific employee's leave types using a unique employee ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollUk\EmployeeLeaveTypes|\XeroAPI\XeroPHP\Models\PayrollUk\Problem, HTTP status code, HTTP response headers (array of strings)
     */
    public function getEmployeeLeaveTypesWithHttpInfo($xero_tenant_id, $employee_id)
    {
        $request = $this->getEmployeeLeaveTypesRequest($xero_tenant_id, $employee_id);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollUk\EmployeeLeaveTypes' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollUk\EmployeeLeaveTypes', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\XeroAPI\XeroPHP\Models\PayrollUk\Problem' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollUk\Problem', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\EmployeeLeaveTypes';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollUkObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollUk\EmployeeLeaveTypes',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = PayrollUkObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollUk\Problem',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getEmployeeLeaveTypesAsync
     * Retrieves a specific employee's leave types using a unique employee ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getEmployeeLeaveTypesAsync($xero_tenant_id, $employee_id)
    {
        return $this->getEmployeeLeaveTypesAsyncWithHttpInfo($xero_tenant_id, $employee_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getEmployeeLeaveTypesAsyncWithHttpInfo
     * Retrieves a specific employee's leave types using a unique employee ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getEmployeeLeaveTypesAsyncWithHttpInfo($xero_tenant_id, $employee_id)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\EmployeeLeaveTypes';
        $request = $this->getEmployeeLeaveTypesRequest($xero_tenant_id, $employee_id);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getEmployeeLeaveTypes'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getEmployeeLeaveTypesRequest($xero_tenant_id, $employee_id)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getEmployeeLeaveTypes'
            );
        }
        // verify the required parameter 'employee_id' is set
        if ($employee_id === null || (is_array($employee_id) && count($employee_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $employee_id when calling getEmployeeLeaveTypes'
            );
        }
        $resourcePath = '/Employees/{EmployeeID}/LeaveTypes';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollUkObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // path params
        if ($employee_id !== null) {
            $resourcePath = str_replace(
                '{' . 'EmployeeID' . '}',
                PayrollUkObjectSerializer::toPathValue($employee_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollUkObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHostPayrollUk() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getEmployeeLeaves
     * Retrieves a specific employee's leave records using a unique employee ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollUk\EmployeeLeaves
     */
    public function getEmployeeLeaves($xero_tenant_id, $employee_id)
    {
        list($response) = $this->getEmployeeLeavesWithHttpInfo($xero_tenant_id, $employee_id);
        return $response;
    }
    /**
     * Operation getEmployeeLeavesWithHttpInfo
     * Retrieves a specific employee's leave records using a unique employee ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollUk\EmployeeLeaves, HTTP status code, HTTP response headers (array of strings)
     */
    public function getEmployeeLeavesWithHttpInfo($xero_tenant_id, $employee_id)
    {
        $request = $this->getEmployeeLeavesRequest($xero_tenant_id, $employee_id);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollUk\EmployeeLeaves' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollUk\EmployeeLeaves', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\EmployeeLeaves';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollUkObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollUk\EmployeeLeaves',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getEmployeeLeavesAsync
     * Retrieves a specific employee's leave records using a unique employee ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getEmployeeLeavesAsync($xero_tenant_id, $employee_id)
    {
        return $this->getEmployeeLeavesAsyncWithHttpInfo($xero_tenant_id, $employee_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getEmployeeLeavesAsyncWithHttpInfo
     * Retrieves a specific employee's leave records using a unique employee ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getEmployeeLeavesAsyncWithHttpInfo($xero_tenant_id, $employee_id)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\EmployeeLeaves';
        $request = $this->getEmployeeLeavesRequest($xero_tenant_id, $employee_id);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getEmployeeLeaves'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getEmployeeLeavesRequest($xero_tenant_id, $employee_id)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getEmployeeLeaves'
            );
        }
        // verify the required parameter 'employee_id' is set
        if ($employee_id === null || (is_array($employee_id) && count($employee_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $employee_id when calling getEmployeeLeaves'
            );
        }
        $resourcePath = '/Employees/{EmployeeID}/Leave';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollUkObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // path params
        if ($employee_id !== null) {
            $resourcePath = str_replace(
                '{' . 'EmployeeID' . '}',
                PayrollUkObjectSerializer::toPathValue($employee_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollUkObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHostPayrollUk() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getEmployeeOpeningBalances
     * Retrieves a specific employee's openingbalances using a unique employee ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollUk\EmployeeOpeningBalancesObject
     */
    public function getEmployeeOpeningBalances($xero_tenant_id, $employee_id)
    {
        list($response) = $this->getEmployeeOpeningBalancesWithHttpInfo($xero_tenant_id, $employee_id);
        return $response;
    }
    /**
     * Operation getEmployeeOpeningBalancesWithHttpInfo
     * Retrieves a specific employee's openingbalances using a unique employee ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollUk\EmployeeOpeningBalancesObject, HTTP status code, HTTP response headers (array of strings)
     */
    public function getEmployeeOpeningBalancesWithHttpInfo($xero_tenant_id, $employee_id)
    {
        $request = $this->getEmployeeOpeningBalancesRequest($xero_tenant_id, $employee_id);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollUk\EmployeeOpeningBalancesObject' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollUk\EmployeeOpeningBalancesObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\EmployeeOpeningBalancesObject';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollUkObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollUk\EmployeeOpeningBalancesObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getEmployeeOpeningBalancesAsync
     * Retrieves a specific employee's openingbalances using a unique employee ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getEmployeeOpeningBalancesAsync($xero_tenant_id, $employee_id)
    {
        return $this->getEmployeeOpeningBalancesAsyncWithHttpInfo($xero_tenant_id, $employee_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getEmployeeOpeningBalancesAsyncWithHttpInfo
     * Retrieves a specific employee's openingbalances using a unique employee ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getEmployeeOpeningBalancesAsyncWithHttpInfo($xero_tenant_id, $employee_id)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\EmployeeOpeningBalancesObject';
        $request = $this->getEmployeeOpeningBalancesRequest($xero_tenant_id, $employee_id);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getEmployeeOpeningBalances'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getEmployeeOpeningBalancesRequest($xero_tenant_id, $employee_id)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getEmployeeOpeningBalances'
            );
        }
        // verify the required parameter 'employee_id' is set
        if ($employee_id === null || (is_array($employee_id) && count($employee_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $employee_id when calling getEmployeeOpeningBalances'
            );
        }
        $resourcePath = '/Employees/{EmployeeID}/ukopeningbalances';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollUkObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // path params
        if ($employee_id !== null) {
            $resourcePath = str_replace(
                '{' . 'EmployeeID' . '}',
                PayrollUkObjectSerializer::toPathValue($employee_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollUkObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHostPayrollUk() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getEmployeePayTemplate
     * Retrieves a specific employee pay templates using a unique employee ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollUk\EmployeePayTemplateObject|\XeroAPI\XeroPHP\Models\PayrollUk\Problem
     */
    public function getEmployeePayTemplate($xero_tenant_id, $employee_id)
    {
        list($response) = $this->getEmployeePayTemplateWithHttpInfo($xero_tenant_id, $employee_id);
        return $response;
    }
    /**
     * Operation getEmployeePayTemplateWithHttpInfo
     * Retrieves a specific employee pay templates using a unique employee ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollUk\EmployeePayTemplateObject|\XeroAPI\XeroPHP\Models\PayrollUk\Problem, HTTP status code, HTTP response headers (array of strings)
     */
    public function getEmployeePayTemplateWithHttpInfo($xero_tenant_id, $employee_id)
    {
        $request = $this->getEmployeePayTemplateRequest($xero_tenant_id, $employee_id);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollUk\EmployeePayTemplateObject' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollUk\EmployeePayTemplateObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\XeroAPI\XeroPHP\Models\PayrollUk\Problem' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollUk\Problem', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\EmployeePayTemplateObject';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollUkObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollUk\EmployeePayTemplateObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = PayrollUkObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollUk\Problem',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getEmployeePayTemplateAsync
     * Retrieves a specific employee pay templates using a unique employee ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getEmployeePayTemplateAsync($xero_tenant_id, $employee_id)
    {
        return $this->getEmployeePayTemplateAsyncWithHttpInfo($xero_tenant_id, $employee_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getEmployeePayTemplateAsyncWithHttpInfo
     * Retrieves a specific employee pay templates using a unique employee ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getEmployeePayTemplateAsyncWithHttpInfo($xero_tenant_id, $employee_id)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\EmployeePayTemplateObject';
        $request = $this->getEmployeePayTemplateRequest($xero_tenant_id, $employee_id);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getEmployeePayTemplate'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getEmployeePayTemplateRequest($xero_tenant_id, $employee_id)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getEmployeePayTemplate'
            );
        }
        // verify the required parameter 'employee_id' is set
        if ($employee_id === null || (is_array($employee_id) && count($employee_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $employee_id when calling getEmployeePayTemplate'
            );
        }
        $resourcePath = '/Employees/{EmployeeID}/PayTemplates';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollUkObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // path params
        if ($employee_id !== null) {
            $resourcePath = str_replace(
                '{' . 'EmployeeID' . '}',
                PayrollUkObjectSerializer::toPathValue($employee_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollUkObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHostPayrollUk() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getEmployeePaymentMethod
     * Retrieves a specific employee's payment method using a unique employee ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollUk\PaymentMethodObject|\XeroAPI\XeroPHP\Models\PayrollUk\Problem
     */
    public function getEmployeePaymentMethod($xero_tenant_id, $employee_id)
    {
        list($response) = $this->getEmployeePaymentMethodWithHttpInfo($xero_tenant_id, $employee_id);
        return $response;
    }
    /**
     * Operation getEmployeePaymentMethodWithHttpInfo
     * Retrieves a specific employee's payment method using a unique employee ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollUk\PaymentMethodObject|\XeroAPI\XeroPHP\Models\PayrollUk\Problem, HTTP status code, HTTP response headers (array of strings)
     */
    public function getEmployeePaymentMethodWithHttpInfo($xero_tenant_id, $employee_id)
    {
        $request = $this->getEmployeePaymentMethodRequest($xero_tenant_id, $employee_id);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollUk\PaymentMethodObject' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollUk\PaymentMethodObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\XeroAPI\XeroPHP\Models\PayrollUk\Problem' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollUk\Problem', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\PaymentMethodObject';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollUkObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollUk\PaymentMethodObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = PayrollUkObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollUk\Problem',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getEmployeePaymentMethodAsync
     * Retrieves a specific employee's payment method using a unique employee ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getEmployeePaymentMethodAsync($xero_tenant_id, $employee_id)
    {
        return $this->getEmployeePaymentMethodAsyncWithHttpInfo($xero_tenant_id, $employee_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getEmployeePaymentMethodAsyncWithHttpInfo
     * Retrieves a specific employee's payment method using a unique employee ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getEmployeePaymentMethodAsyncWithHttpInfo($xero_tenant_id, $employee_id)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\PaymentMethodObject';
        $request = $this->getEmployeePaymentMethodRequest($xero_tenant_id, $employee_id);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getEmployeePaymentMethod'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getEmployeePaymentMethodRequest($xero_tenant_id, $employee_id)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getEmployeePaymentMethod'
            );
        }
        // verify the required parameter 'employee_id' is set
        if ($employee_id === null || (is_array($employee_id) && count($employee_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $employee_id when calling getEmployeePaymentMethod'
            );
        }
        $resourcePath = '/Employees/{EmployeeID}/PaymentMethods';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollUkObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // path params
        if ($employee_id !== null) {
            $resourcePath = str_replace(
                '{' . 'EmployeeID' . '}',
                PayrollUkObjectSerializer::toPathValue($employee_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollUkObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHostPayrollUk() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getEmployeeSalaryAndWage
     * Retrieves a specific salary and wages record for a specific employee using a unique salary and wage id
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  string $salary_and_wages_id Id for single pay template earnings object (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollUk\SalaryAndWages
     */
    public function getEmployeeSalaryAndWage($xero_tenant_id, $employee_id, $salary_and_wages_id)
    {
        list($response) = $this->getEmployeeSalaryAndWageWithHttpInfo($xero_tenant_id, $employee_id, $salary_and_wages_id);
        return $response;
    }
    /**
     * Operation getEmployeeSalaryAndWageWithHttpInfo
     * Retrieves a specific salary and wages record for a specific employee using a unique salary and wage id
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  string $salary_and_wages_id Id for single pay template earnings object (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollUk\SalaryAndWages, HTTP status code, HTTP response headers (array of strings)
     */
    public function getEmployeeSalaryAndWageWithHttpInfo($xero_tenant_id, $employee_id, $salary_and_wages_id)
    {
        $request = $this->getEmployeeSalaryAndWageRequest($xero_tenant_id, $employee_id, $salary_and_wages_id);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollUk\SalaryAndWages' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollUk\SalaryAndWages', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\SalaryAndWages';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollUkObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollUk\SalaryAndWages',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getEmployeeSalaryAndWageAsync
     * Retrieves a specific salary and wages record for a specific employee using a unique salary and wage id
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  string $salary_and_wages_id Id for single pay template earnings object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getEmployeeSalaryAndWageAsync($xero_tenant_id, $employee_id, $salary_and_wages_id)
    {
        return $this->getEmployeeSalaryAndWageAsyncWithHttpInfo($xero_tenant_id, $employee_id, $salary_and_wages_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getEmployeeSalaryAndWageAsyncWithHttpInfo
     * Retrieves a specific salary and wages record for a specific employee using a unique salary and wage id
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  string $salary_and_wages_id Id for single pay template earnings object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getEmployeeSalaryAndWageAsyncWithHttpInfo($xero_tenant_id, $employee_id, $salary_and_wages_id)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\SalaryAndWages';
        $request = $this->getEmployeeSalaryAndWageRequest($xero_tenant_id, $employee_id, $salary_and_wages_id);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getEmployeeSalaryAndWage'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  string $salary_and_wages_id Id for single pay template earnings object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getEmployeeSalaryAndWageRequest($xero_tenant_id, $employee_id, $salary_and_wages_id)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getEmployeeSalaryAndWage'
            );
        }
        // verify the required parameter 'employee_id' is set
        if ($employee_id === null || (is_array($employee_id) && count($employee_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $employee_id when calling getEmployeeSalaryAndWage'
            );
        }
        // verify the required parameter 'salary_and_wages_id' is set
        if ($salary_and_wages_id === null || (is_array($salary_and_wages_id) && count($salary_and_wages_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $salary_and_wages_id when calling getEmployeeSalaryAndWage'
            );
        }
        $resourcePath = '/Employees/{EmployeeID}/SalaryAndWages/{SalaryAndWagesID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollUkObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // path params
        if ($employee_id !== null) {
            $resourcePath = str_replace(
                '{' . 'EmployeeID' . '}',
                PayrollUkObjectSerializer::toPathValue($employee_id),
                $resourcePath
            );
        }
        // path params
        if ($salary_and_wages_id !== null) {
            $resourcePath = str_replace(
                '{' . 'SalaryAndWagesID' . '}',
                PayrollUkObjectSerializer::toPathValue($salary_and_wages_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollUkObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHostPayrollUk() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getEmployeeSalaryAndWages
     * Retrieves a specific employee's salary and wages by using a unique employee ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollUk\SalaryAndWages|\XeroAPI\XeroPHP\Models\PayrollUk\Problem
     */
    public function getEmployeeSalaryAndWages($xero_tenant_id, $employee_id, $page = null)
    {
        list($response) = $this->getEmployeeSalaryAndWagesWithHttpInfo($xero_tenant_id, $employee_id, $page);
        return $response;
    }
    /**
     * Operation getEmployeeSalaryAndWagesWithHttpInfo
     * Retrieves a specific employee's salary and wages by using a unique employee ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollUk\SalaryAndWages|\XeroAPI\XeroPHP\Models\PayrollUk\Problem, HTTP status code, HTTP response headers (array of strings)
     */
    public function getEmployeeSalaryAndWagesWithHttpInfo($xero_tenant_id, $employee_id, $page = null)
    {
        $request = $this->getEmployeeSalaryAndWagesRequest($xero_tenant_id, $employee_id, $page);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollUk\SalaryAndWages' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollUk\SalaryAndWages', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\XeroAPI\XeroPHP\Models\PayrollUk\Problem' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollUk\Problem', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\SalaryAndWages';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollUkObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollUk\SalaryAndWages',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = PayrollUkObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollUk\Problem',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getEmployeeSalaryAndWagesAsync
     * Retrieves a specific employee's salary and wages by using a unique employee ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getEmployeeSalaryAndWagesAsync($xero_tenant_id, $employee_id, $page = null)
    {
        return $this->getEmployeeSalaryAndWagesAsyncWithHttpInfo($xero_tenant_id, $employee_id, $page)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getEmployeeSalaryAndWagesAsyncWithHttpInfo
     * Retrieves a specific employee's salary and wages by using a unique employee ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getEmployeeSalaryAndWagesAsyncWithHttpInfo($xero_tenant_id, $employee_id, $page = null)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\SalaryAndWages';
        $request = $this->getEmployeeSalaryAndWagesRequest($xero_tenant_id, $employee_id, $page);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getEmployeeSalaryAndWages'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getEmployeeSalaryAndWagesRequest($xero_tenant_id, $employee_id, $page = null)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getEmployeeSalaryAndWages'
            );
        }
        // verify the required parameter 'employee_id' is set
        if ($employee_id === null || (is_array($employee_id) && count($employee_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $employee_id when calling getEmployeeSalaryAndWages'
            );
        }
        $resourcePath = '/Employees/{EmployeeID}/SalaryAndWages';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // query params
        if ($page !== null) {
            $queryParams['page'] = PayrollUkObjectSerializer::toQueryValue($page);
        }
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollUkObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // path params
        if ($employee_id !== null) {
            $resourcePath = str_replace(
                '{' . 'EmployeeID' . '}',
                PayrollUkObjectSerializer::toPathValue($employee_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollUkObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHostPayrollUk() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getEmployeeStatutoryLeaveBalances
     * Retrieves a specific employee's leave balances using a unique employee ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  string $leave_type Filter by the type of statutory leave (optional)
     * @param  \DateTime $as_of_date The date from which to calculate balance remaining. If not specified, current date UTC is used. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollUk\EmployeeStatutoryLeaveBalanceObject
     */
    public function getEmployeeStatutoryLeaveBalances($xero_tenant_id, $employee_id, $leave_type = null, $as_of_date = null)
    {
        list($response) = $this->getEmployeeStatutoryLeaveBalancesWithHttpInfo($xero_tenant_id, $employee_id, $leave_type, $as_of_date);
        return $response;
    }
    /**
     * Operation getEmployeeStatutoryLeaveBalancesWithHttpInfo
     * Retrieves a specific employee's leave balances using a unique employee ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  string $leave_type Filter by the type of statutory leave (optional)
     * @param  \DateTime $as_of_date The date from which to calculate balance remaining. If not specified, current date UTC is used. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollUk\EmployeeStatutoryLeaveBalanceObject, HTTP status code, HTTP response headers (array of strings)
     */
    public function getEmployeeStatutoryLeaveBalancesWithHttpInfo($xero_tenant_id, $employee_id, $leave_type = null, $as_of_date = null)
    {
        $request = $this->getEmployeeStatutoryLeaveBalancesRequest($xero_tenant_id, $employee_id, $leave_type, $as_of_date);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollUk\EmployeeStatutoryLeaveBalanceObject' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollUk\EmployeeStatutoryLeaveBalanceObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\EmployeeStatutoryLeaveBalanceObject';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollUkObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollUk\EmployeeStatutoryLeaveBalanceObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getEmployeeStatutoryLeaveBalancesAsync
     * Retrieves a specific employee's leave balances using a unique employee ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  string $leave_type Filter by the type of statutory leave (optional)
     * @param  \DateTime $as_of_date The date from which to calculate balance remaining. If not specified, current date UTC is used. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getEmployeeStatutoryLeaveBalancesAsync($xero_tenant_id, $employee_id, $leave_type = null, $as_of_date = null)
    {
        return $this->getEmployeeStatutoryLeaveBalancesAsyncWithHttpInfo($xero_tenant_id, $employee_id, $leave_type, $as_of_date)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getEmployeeStatutoryLeaveBalancesAsyncWithHttpInfo
     * Retrieves a specific employee's leave balances using a unique employee ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  string $leave_type Filter by the type of statutory leave (optional)
     * @param  \DateTime $as_of_date The date from which to calculate balance remaining. If not specified, current date UTC is used. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getEmployeeStatutoryLeaveBalancesAsyncWithHttpInfo($xero_tenant_id, $employee_id, $leave_type = null, $as_of_date = null)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\EmployeeStatutoryLeaveBalanceObject';
        $request = $this->getEmployeeStatutoryLeaveBalancesRequest($xero_tenant_id, $employee_id, $leave_type, $as_of_date);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getEmployeeStatutoryLeaveBalances'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  string $leave_type Filter by the type of statutory leave (optional)
     * @param  \DateTime $as_of_date The date from which to calculate balance remaining. If not specified, current date UTC is used. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getEmployeeStatutoryLeaveBalancesRequest($xero_tenant_id, $employee_id, $leave_type = null, $as_of_date = null)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getEmployeeStatutoryLeaveBalances'
            );
        }
        // verify the required parameter 'employee_id' is set
        if ($employee_id === null || (is_array($employee_id) && count($employee_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $employee_id when calling getEmployeeStatutoryLeaveBalances'
            );
        }
        $resourcePath = '/Employees/{EmployeeID}/StatutoryLeaveBalance';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // query params
        if ($leave_type !== null) {
            $queryParams['LeaveType'] = PayrollUkObjectSerializer::toQueryValue($leave_type);
        }
        // query params
        if ($as_of_date !== null) {
            $queryParams['AsOfDate'] = PayrollUkObjectSerializer::toQueryValue($as_of_date);
        }
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollUkObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // path params
        if ($employee_id !== null) {
            $resourcePath = str_replace(
                '{' . 'EmployeeID' . '}',
                PayrollUkObjectSerializer::toPathValue($employee_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollUkObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHostPayrollUk() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getEmployeeStatutorySickLeave
     * Retrieves a statutory sick leave for an employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $statutory_sick_leave_id Statutory sick leave id for single object (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollUk\EmployeeStatutorySickLeaveObject
     */
    public function getEmployeeStatutorySickLeave($xero_tenant_id, $statutory_sick_leave_id)
    {
        list($response) = $this->getEmployeeStatutorySickLeaveWithHttpInfo($xero_tenant_id, $statutory_sick_leave_id);
        return $response;
    }
    /**
     * Operation getEmployeeStatutorySickLeaveWithHttpInfo
     * Retrieves a statutory sick leave for an employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $statutory_sick_leave_id Statutory sick leave id for single object (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollUk\EmployeeStatutorySickLeaveObject, HTTP status code, HTTP response headers (array of strings)
     */
    public function getEmployeeStatutorySickLeaveWithHttpInfo($xero_tenant_id, $statutory_sick_leave_id)
    {
        $request = $this->getEmployeeStatutorySickLeaveRequest($xero_tenant_id, $statutory_sick_leave_id);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollUk\EmployeeStatutorySickLeaveObject' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollUk\EmployeeStatutorySickLeaveObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\EmployeeStatutorySickLeaveObject';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollUkObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollUk\EmployeeStatutorySickLeaveObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getEmployeeStatutorySickLeaveAsync
     * Retrieves a statutory sick leave for an employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $statutory_sick_leave_id Statutory sick leave id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getEmployeeStatutorySickLeaveAsync($xero_tenant_id, $statutory_sick_leave_id)
    {
        return $this->getEmployeeStatutorySickLeaveAsyncWithHttpInfo($xero_tenant_id, $statutory_sick_leave_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getEmployeeStatutorySickLeaveAsyncWithHttpInfo
     * Retrieves a statutory sick leave for an employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $statutory_sick_leave_id Statutory sick leave id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getEmployeeStatutorySickLeaveAsyncWithHttpInfo($xero_tenant_id, $statutory_sick_leave_id)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\EmployeeStatutorySickLeaveObject';
        $request = $this->getEmployeeStatutorySickLeaveRequest($xero_tenant_id, $statutory_sick_leave_id);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getEmployeeStatutorySickLeave'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $statutory_sick_leave_id Statutory sick leave id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getEmployeeStatutorySickLeaveRequest($xero_tenant_id, $statutory_sick_leave_id)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getEmployeeStatutorySickLeave'
            );
        }
        // verify the required parameter 'statutory_sick_leave_id' is set
        if ($statutory_sick_leave_id === null || (is_array($statutory_sick_leave_id) && count($statutory_sick_leave_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $statutory_sick_leave_id when calling getEmployeeStatutorySickLeave'
            );
        }
        $resourcePath = '/StatutoryLeaves/Sick/{StatutorySickLeaveID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollUkObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // path params
        if ($statutory_sick_leave_id !== null) {
            $resourcePath = str_replace(
                '{' . 'StatutorySickLeaveID' . '}',
                PayrollUkObjectSerializer::toPathValue($statutory_sick_leave_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollUkObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHostPayrollUk() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getEmployeeTax
     * Retrieves tax records for a specific employee using a unique employee ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollUk\EmployeeTaxObject
     */
    public function getEmployeeTax($xero_tenant_id, $employee_id)
    {
        list($response) = $this->getEmployeeTaxWithHttpInfo($xero_tenant_id, $employee_id);
        return $response;
    }
    /**
     * Operation getEmployeeTaxWithHttpInfo
     * Retrieves tax records for a specific employee using a unique employee ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollUk\EmployeeTaxObject, HTTP status code, HTTP response headers (array of strings)
     */
    public function getEmployeeTaxWithHttpInfo($xero_tenant_id, $employee_id)
    {
        $request = $this->getEmployeeTaxRequest($xero_tenant_id, $employee_id);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollUk\EmployeeTaxObject' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollUk\EmployeeTaxObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\EmployeeTaxObject';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollUkObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollUk\EmployeeTaxObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getEmployeeTaxAsync
     * Retrieves tax records for a specific employee using a unique employee ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getEmployeeTaxAsync($xero_tenant_id, $employee_id)
    {
        return $this->getEmployeeTaxAsyncWithHttpInfo($xero_tenant_id, $employee_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getEmployeeTaxAsyncWithHttpInfo
     * Retrieves tax records for a specific employee using a unique employee ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getEmployeeTaxAsyncWithHttpInfo($xero_tenant_id, $employee_id)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\EmployeeTaxObject';
        $request = $this->getEmployeeTaxRequest($xero_tenant_id, $employee_id);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getEmployeeTax'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getEmployeeTaxRequest($xero_tenant_id, $employee_id)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getEmployeeTax'
            );
        }
        // verify the required parameter 'employee_id' is set
        if ($employee_id === null || (is_array($employee_id) && count($employee_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $employee_id when calling getEmployeeTax'
            );
        }
        $resourcePath = '/Employees/{EmployeeID}/Tax';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollUkObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // path params
        if ($employee_id !== null) {
            $resourcePath = str_replace(
                '{' . 'EmployeeID' . '}',
                PayrollUkObjectSerializer::toPathValue($employee_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollUkObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHostPayrollUk() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getEmployees
     * Retrieves employees
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $filter Filter by first name and/or lastname (optional)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollUk\Employees|\XeroAPI\XeroPHP\Models\PayrollUk\Problem
     */
    public function getEmployees($xero_tenant_id, $filter = null, $page = null)
    {
        list($response) = $this->getEmployeesWithHttpInfo($xero_tenant_id, $filter, $page);
        return $response;
    }
    /**
     * Operation getEmployeesWithHttpInfo
     * Retrieves employees
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $filter Filter by first name and/or lastname (optional)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollUk\Employees|\XeroAPI\XeroPHP\Models\PayrollUk\Problem, HTTP status code, HTTP response headers (array of strings)
     */
    public function getEmployeesWithHttpInfo($xero_tenant_id, $filter = null, $page = null)
    {
        $request = $this->getEmployeesRequest($xero_tenant_id, $filter, $page);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollUk\Employees' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollUk\Employees', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\XeroAPI\XeroPHP\Models\PayrollUk\Problem' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollUk\Problem', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\Employees';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollUkObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollUk\Employees',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = PayrollUkObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollUk\Problem',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getEmployeesAsync
     * Retrieves employees
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $filter Filter by first name and/or lastname (optional)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getEmployeesAsync($xero_tenant_id, $filter = null, $page = null)
    {
        return $this->getEmployeesAsyncWithHttpInfo($xero_tenant_id, $filter, $page)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getEmployeesAsyncWithHttpInfo
     * Retrieves employees
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $filter Filter by first name and/or lastname (optional)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getEmployeesAsyncWithHttpInfo($xero_tenant_id, $filter = null, $page = null)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\Employees';
        $request = $this->getEmployeesRequest($xero_tenant_id, $filter, $page);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getEmployees'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $filter Filter by first name and/or lastname (optional)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getEmployeesRequest($xero_tenant_id, $filter = null, $page = null)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getEmployees'
            );
        }
        $resourcePath = '/Employees';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // query params
        if ($filter !== null) {
            $queryParams['filter'] = PayrollUkObjectSerializer::toQueryValue($filter);
        }
        // query params
        if ($page !== null) {
            $queryParams['page'] = PayrollUkObjectSerializer::toQueryValue($page);
        }
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollUkObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollUkObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHostPayrollUk() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getLeaveType
     * Retrieves a specific leave type by using a unique leave type ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $leave_type_id Identifier for the leave type (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollUk\LeaveTypeObject
     */
    public function getLeaveType($xero_tenant_id, $leave_type_id)
    {
        list($response) = $this->getLeaveTypeWithHttpInfo($xero_tenant_id, $leave_type_id);
        return $response;
    }
    /**
     * Operation getLeaveTypeWithHttpInfo
     * Retrieves a specific leave type by using a unique leave type ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $leave_type_id Identifier for the leave type (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollUk\LeaveTypeObject, HTTP status code, HTTP response headers (array of strings)
     */
    public function getLeaveTypeWithHttpInfo($xero_tenant_id, $leave_type_id)
    {
        $request = $this->getLeaveTypeRequest($xero_tenant_id, $leave_type_id);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollUk\LeaveTypeObject' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollUk\LeaveTypeObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\LeaveTypeObject';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollUkObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollUk\LeaveTypeObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getLeaveTypeAsync
     * Retrieves a specific leave type by using a unique leave type ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $leave_type_id Identifier for the leave type (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getLeaveTypeAsync($xero_tenant_id, $leave_type_id)
    {
        return $this->getLeaveTypeAsyncWithHttpInfo($xero_tenant_id, $leave_type_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getLeaveTypeAsyncWithHttpInfo
     * Retrieves a specific leave type by using a unique leave type ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $leave_type_id Identifier for the leave type (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getLeaveTypeAsyncWithHttpInfo($xero_tenant_id, $leave_type_id)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\LeaveTypeObject';
        $request = $this->getLeaveTypeRequest($xero_tenant_id, $leave_type_id);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getLeaveType'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $leave_type_id Identifier for the leave type (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getLeaveTypeRequest($xero_tenant_id, $leave_type_id)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getLeaveType'
            );
        }
        // verify the required parameter 'leave_type_id' is set
        if ($leave_type_id === null || (is_array($leave_type_id) && count($leave_type_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $leave_type_id when calling getLeaveType'
            );
        }
        $resourcePath = '/LeaveTypes/{LeaveTypeID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollUkObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // path params
        if ($leave_type_id !== null) {
            $resourcePath = str_replace(
                '{' . 'LeaveTypeID' . '}',
                PayrollUkObjectSerializer::toPathValue($leave_type_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollUkObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHostPayrollUk() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getLeaveTypes
     * Retrieves leave types
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @param  bool $active_only Filters leave types by active status. By default the API returns all leave types. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollUk\LeaveTypes
     */
    public function getLeaveTypes($xero_tenant_id, $page = null, $active_only = null)
    {
        list($response) = $this->getLeaveTypesWithHttpInfo($xero_tenant_id, $page, $active_only);
        return $response;
    }
    /**
     * Operation getLeaveTypesWithHttpInfo
     * Retrieves leave types
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @param  bool $active_only Filters leave types by active status. By default the API returns all leave types. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollUk\LeaveTypes, HTTP status code, HTTP response headers (array of strings)
     */
    public function getLeaveTypesWithHttpInfo($xero_tenant_id, $page = null, $active_only = null)
    {
        $request = $this->getLeaveTypesRequest($xero_tenant_id, $page, $active_only);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollUk\LeaveTypes' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollUk\LeaveTypes', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\LeaveTypes';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollUkObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollUk\LeaveTypes',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getLeaveTypesAsync
     * Retrieves leave types
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @param  bool $active_only Filters leave types by active status. By default the API returns all leave types. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getLeaveTypesAsync($xero_tenant_id, $page = null, $active_only = null)
    {
        return $this->getLeaveTypesAsyncWithHttpInfo($xero_tenant_id, $page, $active_only)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getLeaveTypesAsyncWithHttpInfo
     * Retrieves leave types
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @param  bool $active_only Filters leave types by active status. By default the API returns all leave types. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getLeaveTypesAsyncWithHttpInfo($xero_tenant_id, $page = null, $active_only = null)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\LeaveTypes';
        $request = $this->getLeaveTypesRequest($xero_tenant_id, $page, $active_only);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getLeaveTypes'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @param  bool $active_only Filters leave types by active status. By default the API returns all leave types. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getLeaveTypesRequest($xero_tenant_id, $page = null, $active_only = null)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getLeaveTypes'
            );
        }
        $resourcePath = '/LeaveTypes';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // query params
        if ($page !== null) {
            $queryParams['page'] = PayrollUkObjectSerializer::toQueryValue($page);
        }
        // query params
        if ($active_only !== null) {
            $queryParams['ActiveOnly'] = $active_only ? 'true' : 'false';
        }
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollUkObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollUkObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHostPayrollUk() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getPayRun
     * Retrieves a specific pay run by using a unique pay run ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $pay_run_id Identifier for the pay run (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollUk\PayRunObject
     */
    public function getPayRun($xero_tenant_id, $pay_run_id)
    {
        list($response) = $this->getPayRunWithHttpInfo($xero_tenant_id, $pay_run_id);
        return $response;
    }
    /**
     * Operation getPayRunWithHttpInfo
     * Retrieves a specific pay run by using a unique pay run ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $pay_run_id Identifier for the pay run (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollUk\PayRunObject, HTTP status code, HTTP response headers (array of strings)
     */
    public function getPayRunWithHttpInfo($xero_tenant_id, $pay_run_id)
    {
        $request = $this->getPayRunRequest($xero_tenant_id, $pay_run_id);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollUk\PayRunObject' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollUk\PayRunObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\PayRunObject';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollUkObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollUk\PayRunObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getPayRunAsync
     * Retrieves a specific pay run by using a unique pay run ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $pay_run_id Identifier for the pay run (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getPayRunAsync($xero_tenant_id, $pay_run_id)
    {
        return $this->getPayRunAsyncWithHttpInfo($xero_tenant_id, $pay_run_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getPayRunAsyncWithHttpInfo
     * Retrieves a specific pay run by using a unique pay run ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $pay_run_id Identifier for the pay run (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getPayRunAsyncWithHttpInfo($xero_tenant_id, $pay_run_id)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\PayRunObject';
        $request = $this->getPayRunRequest($xero_tenant_id, $pay_run_id);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getPayRun'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $pay_run_id Identifier for the pay run (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getPayRunRequest($xero_tenant_id, $pay_run_id)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getPayRun'
            );
        }
        // verify the required parameter 'pay_run_id' is set
        if ($pay_run_id === null || (is_array($pay_run_id) && count($pay_run_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $pay_run_id when calling getPayRun'
            );
        }
        $resourcePath = '/PayRuns/{PayRunID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollUkObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // path params
        if ($pay_run_id !== null) {
            $resourcePath = str_replace(
                '{' . 'PayRunID' . '}',
                PayrollUkObjectSerializer::toPathValue($pay_run_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollUkObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHostPayrollUk() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getPayRunCalendar
     * Retrieves a specific payrun calendar by using a unique payrun calendar ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $pay_run_calendar_id Identifier for the payrun calendars (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollUk\PayRunCalendarObject
     */
    public function getPayRunCalendar($xero_tenant_id, $pay_run_calendar_id)
    {
        list($response) = $this->getPayRunCalendarWithHttpInfo($xero_tenant_id, $pay_run_calendar_id);
        return $response;
    }
    /**
     * Operation getPayRunCalendarWithHttpInfo
     * Retrieves a specific payrun calendar by using a unique payrun calendar ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $pay_run_calendar_id Identifier for the payrun calendars (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollUk\PayRunCalendarObject, HTTP status code, HTTP response headers (array of strings)
     */
    public function getPayRunCalendarWithHttpInfo($xero_tenant_id, $pay_run_calendar_id)
    {
        $request = $this->getPayRunCalendarRequest($xero_tenant_id, $pay_run_calendar_id);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollUk\PayRunCalendarObject' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollUk\PayRunCalendarObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\PayRunCalendarObject';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollUkObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollUk\PayRunCalendarObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getPayRunCalendarAsync
     * Retrieves a specific payrun calendar by using a unique payrun calendar ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $pay_run_calendar_id Identifier for the payrun calendars (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getPayRunCalendarAsync($xero_tenant_id, $pay_run_calendar_id)
    {
        return $this->getPayRunCalendarAsyncWithHttpInfo($xero_tenant_id, $pay_run_calendar_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getPayRunCalendarAsyncWithHttpInfo
     * Retrieves a specific payrun calendar by using a unique payrun calendar ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $pay_run_calendar_id Identifier for the payrun calendars (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getPayRunCalendarAsyncWithHttpInfo($xero_tenant_id, $pay_run_calendar_id)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\PayRunCalendarObject';
        $request = $this->getPayRunCalendarRequest($xero_tenant_id, $pay_run_calendar_id);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getPayRunCalendar'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $pay_run_calendar_id Identifier for the payrun calendars (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getPayRunCalendarRequest($xero_tenant_id, $pay_run_calendar_id)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getPayRunCalendar'
            );
        }
        // verify the required parameter 'pay_run_calendar_id' is set
        if ($pay_run_calendar_id === null || (is_array($pay_run_calendar_id) && count($pay_run_calendar_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $pay_run_calendar_id when calling getPayRunCalendar'
            );
        }
        $resourcePath = '/PayRunCalendars/{PayRunCalendarID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollUkObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // path params
        if ($pay_run_calendar_id !== null) {
            $resourcePath = str_replace(
                '{' . 'PayRunCalendarID' . '}',
                PayrollUkObjectSerializer::toPathValue($pay_run_calendar_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollUkObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHostPayrollUk() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getPayRunCalendars
     * Retrieves payrun calendars
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollUk\PayRunCalendars
     */
    public function getPayRunCalendars($xero_tenant_id, $page = null)
    {
        list($response) = $this->getPayRunCalendarsWithHttpInfo($xero_tenant_id, $page);
        return $response;
    }
    /**
     * Operation getPayRunCalendarsWithHttpInfo
     * Retrieves payrun calendars
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollUk\PayRunCalendars, HTTP status code, HTTP response headers (array of strings)
     */
    public function getPayRunCalendarsWithHttpInfo($xero_tenant_id, $page = null)
    {
        $request = $this->getPayRunCalendarsRequest($xero_tenant_id, $page);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollUk\PayRunCalendars' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollUk\PayRunCalendars', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\PayRunCalendars';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollUkObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollUk\PayRunCalendars',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getPayRunCalendarsAsync
     * Retrieves payrun calendars
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getPayRunCalendarsAsync($xero_tenant_id, $page = null)
    {
        return $this->getPayRunCalendarsAsyncWithHttpInfo($xero_tenant_id, $page)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getPayRunCalendarsAsyncWithHttpInfo
     * Retrieves payrun calendars
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getPayRunCalendarsAsyncWithHttpInfo($xero_tenant_id, $page = null)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\PayRunCalendars';
        $request = $this->getPayRunCalendarsRequest($xero_tenant_id, $page);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getPayRunCalendars'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getPayRunCalendarsRequest($xero_tenant_id, $page = null)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getPayRunCalendars'
            );
        }
        $resourcePath = '/PayRunCalendars';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // query params
        if ($page !== null) {
            $queryParams['page'] = PayrollUkObjectSerializer::toQueryValue($page);
        }
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollUkObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollUkObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHostPayrollUk() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getPayRuns
     * Retrieves pay runs
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @param  string $status By default get payruns will return all the payruns for an organization. You can add GET https://api.xero.com/payroll.xro/2.0/payRuns?statu&#x3D;{PayRunStatus} to filter the payruns by status. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollUk\PayRuns
     */
    public function getPayRuns($xero_tenant_id, $page = null, $status = null)
    {
        list($response) = $this->getPayRunsWithHttpInfo($xero_tenant_id, $page, $status);
        return $response;
    }
    /**
     * Operation getPayRunsWithHttpInfo
     * Retrieves pay runs
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @param  string $status By default get payruns will return all the payruns for an organization. You can add GET https://api.xero.com/payroll.xro/2.0/payRuns?statu&#x3D;{PayRunStatus} to filter the payruns by status. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollUk\PayRuns, HTTP status code, HTTP response headers (array of strings)
     */
    public function getPayRunsWithHttpInfo($xero_tenant_id, $page = null, $status = null)
    {
        $request = $this->getPayRunsRequest($xero_tenant_id, $page, $status);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollUk\PayRuns' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollUk\PayRuns', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\PayRuns';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollUkObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollUk\PayRuns',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getPayRunsAsync
     * Retrieves pay runs
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @param  string $status By default get payruns will return all the payruns for an organization. You can add GET https://api.xero.com/payroll.xro/2.0/payRuns?statu&#x3D;{PayRunStatus} to filter the payruns by status. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getPayRunsAsync($xero_tenant_id, $page = null, $status = null)
    {
        return $this->getPayRunsAsyncWithHttpInfo($xero_tenant_id, $page, $status)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getPayRunsAsyncWithHttpInfo
     * Retrieves pay runs
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @param  string $status By default get payruns will return all the payruns for an organization. You can add GET https://api.xero.com/payroll.xro/2.0/payRuns?statu&#x3D;{PayRunStatus} to filter the payruns by status. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getPayRunsAsyncWithHttpInfo($xero_tenant_id, $page = null, $status = null)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\PayRuns';
        $request = $this->getPayRunsRequest($xero_tenant_id, $page, $status);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getPayRuns'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @param  string $status By default get payruns will return all the payruns for an organization. You can add GET https://api.xero.com/payroll.xro/2.0/payRuns?statu&#x3D;{PayRunStatus} to filter the payruns by status. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getPayRunsRequest($xero_tenant_id, $page = null, $status = null)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getPayRuns'
            );
        }
        $resourcePath = '/PayRuns';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // query params
        if ($page !== null) {
            $queryParams['page'] = PayrollUkObjectSerializer::toQueryValue($page);
        }
        // query params
        if ($status !== null) {
            $queryParams['status'] = PayrollUkObjectSerializer::toQueryValue($status);
        }
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollUkObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollUkObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHostPayrollUk() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getPaySlip
     * Retrieves a specific payslip by using a unique payslip ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $payslip_id Identifier for the payslip (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollUk\PayslipObject
     */
    public function getPaySlip($xero_tenant_id, $payslip_id)
    {
        list($response) = $this->getPaySlipWithHttpInfo($xero_tenant_id, $payslip_id);
        return $response;
    }
    /**
     * Operation getPaySlipWithHttpInfo
     * Retrieves a specific payslip by using a unique payslip ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $payslip_id Identifier for the payslip (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollUk\PayslipObject, HTTP status code, HTTP response headers (array of strings)
     */
    public function getPaySlipWithHttpInfo($xero_tenant_id, $payslip_id)
    {
        $request = $this->getPaySlipRequest($xero_tenant_id, $payslip_id);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollUk\PayslipObject' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollUk\PayslipObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\PayslipObject';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollUkObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollUk\PayslipObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getPaySlipAsync
     * Retrieves a specific payslip by using a unique payslip ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $payslip_id Identifier for the payslip (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getPaySlipAsync($xero_tenant_id, $payslip_id)
    {
        return $this->getPaySlipAsyncWithHttpInfo($xero_tenant_id, $payslip_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getPaySlipAsyncWithHttpInfo
     * Retrieves a specific payslip by using a unique payslip ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $payslip_id Identifier for the payslip (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getPaySlipAsyncWithHttpInfo($xero_tenant_id, $payslip_id)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\PayslipObject';
        $request = $this->getPaySlipRequest($xero_tenant_id, $payslip_id);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getPaySlip'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $payslip_id Identifier for the payslip (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getPaySlipRequest($xero_tenant_id, $payslip_id)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getPaySlip'
            );
        }
        // verify the required parameter 'payslip_id' is set
        if ($payslip_id === null || (is_array($payslip_id) && count($payslip_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $payslip_id when calling getPaySlip'
            );
        }
        $resourcePath = '/Payslips/{PayslipID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollUkObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // path params
        if ($payslip_id !== null) {
            $resourcePath = str_replace(
                '{' . 'PayslipID' . '}',
                PayrollUkObjectSerializer::toPathValue($payslip_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollUkObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHostPayrollUk() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getPaySlips
     * Retrieves payslips
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $pay_run_id PayrunID which specifies the containing payrun of payslips to retrieve. By default, the API does not group payslips by payrun. (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollUk\Payslips
     */
    public function getPaySlips($xero_tenant_id, $pay_run_id, $page = null)
    {
        list($response) = $this->getPaySlipsWithHttpInfo($xero_tenant_id, $pay_run_id, $page);
        return $response;
    }
    /**
     * Operation getPaySlipsWithHttpInfo
     * Retrieves payslips
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $pay_run_id PayrunID which specifies the containing payrun of payslips to retrieve. By default, the API does not group payslips by payrun. (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollUk\Payslips, HTTP status code, HTTP response headers (array of strings)
     */
    public function getPaySlipsWithHttpInfo($xero_tenant_id, $pay_run_id, $page = null)
    {
        $request = $this->getPaySlipsRequest($xero_tenant_id, $pay_run_id, $page);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollUk\Payslips' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollUk\Payslips', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\Payslips';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollUkObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollUk\Payslips',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getPaySlipsAsync
     * Retrieves payslips
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $pay_run_id PayrunID which specifies the containing payrun of payslips to retrieve. By default, the API does not group payslips by payrun. (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getPaySlipsAsync($xero_tenant_id, $pay_run_id, $page = null)
    {
        return $this->getPaySlipsAsyncWithHttpInfo($xero_tenant_id, $pay_run_id, $page)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getPaySlipsAsyncWithHttpInfo
     * Retrieves payslips
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $pay_run_id PayrunID which specifies the containing payrun of payslips to retrieve. By default, the API does not group payslips by payrun. (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getPaySlipsAsyncWithHttpInfo($xero_tenant_id, $pay_run_id, $page = null)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\Payslips';
        $request = $this->getPaySlipsRequest($xero_tenant_id, $pay_run_id, $page);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getPaySlips'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $pay_run_id PayrunID which specifies the containing payrun of payslips to retrieve. By default, the API does not group payslips by payrun. (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getPaySlipsRequest($xero_tenant_id, $pay_run_id, $page = null)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getPaySlips'
            );
        }
        // verify the required parameter 'pay_run_id' is set
        if ($pay_run_id === null || (is_array($pay_run_id) && count($pay_run_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $pay_run_id when calling getPaySlips'
            );
        }
        $resourcePath = '/Payslips';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // query params
        if ($page !== null) {
            $queryParams['page'] = PayrollUkObjectSerializer::toQueryValue($page);
        }
        // query params
        if ($pay_run_id !== null) {
            $queryParams['PayRunID'] = PayrollUkObjectSerializer::toQueryValue($pay_run_id);
        }
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollUkObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollUkObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHostPayrollUk() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getReimbursement
     * Retrieves a specific reimbursement by using a unique reimbursement id
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $reimbursement_id Identifier for the reimbursement (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollUk\ReimbursementObject
     */
    public function getReimbursement($xero_tenant_id, $reimbursement_id)
    {
        list($response) = $this->getReimbursementWithHttpInfo($xero_tenant_id, $reimbursement_id);
        return $response;
    }
    /**
     * Operation getReimbursementWithHttpInfo
     * Retrieves a specific reimbursement by using a unique reimbursement id
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $reimbursement_id Identifier for the reimbursement (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollUk\ReimbursementObject, HTTP status code, HTTP response headers (array of strings)
     */
    public function getReimbursementWithHttpInfo($xero_tenant_id, $reimbursement_id)
    {
        $request = $this->getReimbursementRequest($xero_tenant_id, $reimbursement_id);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollUk\ReimbursementObject' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollUk\ReimbursementObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\ReimbursementObject';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollUkObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollUk\ReimbursementObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getReimbursementAsync
     * Retrieves a specific reimbursement by using a unique reimbursement id
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $reimbursement_id Identifier for the reimbursement (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getReimbursementAsync($xero_tenant_id, $reimbursement_id)
    {
        return $this->getReimbursementAsyncWithHttpInfo($xero_tenant_id, $reimbursement_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getReimbursementAsyncWithHttpInfo
     * Retrieves a specific reimbursement by using a unique reimbursement id
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $reimbursement_id Identifier for the reimbursement (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getReimbursementAsyncWithHttpInfo($xero_tenant_id, $reimbursement_id)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\ReimbursementObject';
        $request = $this->getReimbursementRequest($xero_tenant_id, $reimbursement_id);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getReimbursement'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $reimbursement_id Identifier for the reimbursement (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getReimbursementRequest($xero_tenant_id, $reimbursement_id)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getReimbursement'
            );
        }
        // verify the required parameter 'reimbursement_id' is set
        if ($reimbursement_id === null || (is_array($reimbursement_id) && count($reimbursement_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $reimbursement_id when calling getReimbursement'
            );
        }
        $resourcePath = '/Reimbursements/{ReimbursementID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollUkObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // path params
        if ($reimbursement_id !== null) {
            $resourcePath = str_replace(
                '{' . 'ReimbursementID' . '}',
                PayrollUkObjectSerializer::toPathValue($reimbursement_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollUkObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHostPayrollUk() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getReimbursements
     * Retrieves reimbursements
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollUk\Reimbursements
     */
    public function getReimbursements($xero_tenant_id, $page = null)
    {
        list($response) = $this->getReimbursementsWithHttpInfo($xero_tenant_id, $page);
        return $response;
    }
    /**
     * Operation getReimbursementsWithHttpInfo
     * Retrieves reimbursements
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollUk\Reimbursements, HTTP status code, HTTP response headers (array of strings)
     */
    public function getReimbursementsWithHttpInfo($xero_tenant_id, $page = null)
    {
        $request = $this->getReimbursementsRequest($xero_tenant_id, $page);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollUk\Reimbursements' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollUk\Reimbursements', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\Reimbursements';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollUkObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollUk\Reimbursements',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getReimbursementsAsync
     * Retrieves reimbursements
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getReimbursementsAsync($xero_tenant_id, $page = null)
    {
        return $this->getReimbursementsAsyncWithHttpInfo($xero_tenant_id, $page)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getReimbursementsAsyncWithHttpInfo
     * Retrieves reimbursements
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getReimbursementsAsyncWithHttpInfo($xero_tenant_id, $page = null)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\Reimbursements';
        $request = $this->getReimbursementsRequest($xero_tenant_id, $page);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getReimbursements'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getReimbursementsRequest($xero_tenant_id, $page = null)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getReimbursements'
            );
        }
        $resourcePath = '/Reimbursements';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // query params
        if ($page !== null) {
            $queryParams['page'] = PayrollUkObjectSerializer::toQueryValue($page);
        }
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollUkObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollUkObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHostPayrollUk() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getSettings
     * Retrieves payroll settings
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollUk\Settings
     */
    public function getSettings($xero_tenant_id)
    {
        list($response) = $this->getSettingsWithHttpInfo($xero_tenant_id);
        return $response;
    }
    /**
     * Operation getSettingsWithHttpInfo
     * Retrieves payroll settings
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollUk\Settings, HTTP status code, HTTP response headers (array of strings)
     */
    public function getSettingsWithHttpInfo($xero_tenant_id)
    {
        $request = $this->getSettingsRequest($xero_tenant_id);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollUk\Settings' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollUk\Settings', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\Settings';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollUkObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollUk\Settings',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getSettingsAsync
     * Retrieves payroll settings
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSettingsAsync($xero_tenant_id)
    {
        return $this->getSettingsAsyncWithHttpInfo($xero_tenant_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getSettingsAsyncWithHttpInfo
     * Retrieves payroll settings
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getSettingsAsyncWithHttpInfo($xero_tenant_id)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\Settings';
        $request = $this->getSettingsRequest($xero_tenant_id);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getSettings'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getSettingsRequest($xero_tenant_id)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getSettings'
            );
        }
        $resourcePath = '/Settings';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollUkObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollUkObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHostPayrollUk() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getStatutoryLeaveSummary
     * Retrieves a specific employee's summary of statutory leaves using a unique employee ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  bool $active_only Filter response with leaves that are currently active or yet to be taken. If not specified, all leaves (past, current, and future scheduled) are returned (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollUk\EmployeeStatutoryLeavesSummaries
     */
    public function getStatutoryLeaveSummary($xero_tenant_id, $employee_id, $active_only = null)
    {
        list($response) = $this->getStatutoryLeaveSummaryWithHttpInfo($xero_tenant_id, $employee_id, $active_only);
        return $response;
    }
    /**
     * Operation getStatutoryLeaveSummaryWithHttpInfo
     * Retrieves a specific employee's summary of statutory leaves using a unique employee ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  bool $active_only Filter response with leaves that are currently active or yet to be taken. If not specified, all leaves (past, current, and future scheduled) are returned (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollUk\EmployeeStatutoryLeavesSummaries, HTTP status code, HTTP response headers (array of strings)
     */
    public function getStatutoryLeaveSummaryWithHttpInfo($xero_tenant_id, $employee_id, $active_only = null)
    {
        $request = $this->getStatutoryLeaveSummaryRequest($xero_tenant_id, $employee_id, $active_only);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollUk\EmployeeStatutoryLeavesSummaries' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollUk\EmployeeStatutoryLeavesSummaries', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\EmployeeStatutoryLeavesSummaries';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollUkObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollUk\EmployeeStatutoryLeavesSummaries',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getStatutoryLeaveSummaryAsync
     * Retrieves a specific employee's summary of statutory leaves using a unique employee ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  bool $active_only Filter response with leaves that are currently active or yet to be taken. If not specified, all leaves (past, current, and future scheduled) are returned (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getStatutoryLeaveSummaryAsync($xero_tenant_id, $employee_id, $active_only = null)
    {
        return $this->getStatutoryLeaveSummaryAsyncWithHttpInfo($xero_tenant_id, $employee_id, $active_only)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getStatutoryLeaveSummaryAsyncWithHttpInfo
     * Retrieves a specific employee's summary of statutory leaves using a unique employee ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  bool $active_only Filter response with leaves that are currently active or yet to be taken. If not specified, all leaves (past, current, and future scheduled) are returned (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getStatutoryLeaveSummaryAsyncWithHttpInfo($xero_tenant_id, $employee_id, $active_only = null)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\EmployeeStatutoryLeavesSummaries';
        $request = $this->getStatutoryLeaveSummaryRequest($xero_tenant_id, $employee_id, $active_only);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getStatutoryLeaveSummary'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  bool $active_only Filter response with leaves that are currently active or yet to be taken. If not specified, all leaves (past, current, and future scheduled) are returned (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getStatutoryLeaveSummaryRequest($xero_tenant_id, $employee_id, $active_only = null)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getStatutoryLeaveSummary'
            );
        }
        // verify the required parameter 'employee_id' is set
        if ($employee_id === null || (is_array($employee_id) && count($employee_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $employee_id when calling getStatutoryLeaveSummary'
            );
        }
        $resourcePath = '/StatutoryLeaves/Summary/{EmployeeID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // query params
        if ($active_only !== null) {
            $queryParams['activeOnly'] = $active_only ? 'true' : 'false';
        }
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollUkObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // path params
        if ($employee_id !== null) {
            $resourcePath = str_replace(
                '{' . 'EmployeeID' . '}',
                PayrollUkObjectSerializer::toPathValue($employee_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollUkObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHostPayrollUk() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getTimesheet
     * Retrieve a specific timesheet by using a unique timesheet ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $timesheet_id Identifier for the timesheet (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollUk\TimesheetObject
     */
    public function getTimesheet($xero_tenant_id, $timesheet_id)
    {
        list($response) = $this->getTimesheetWithHttpInfo($xero_tenant_id, $timesheet_id);
        return $response;
    }
    /**
     * Operation getTimesheetWithHttpInfo
     * Retrieve a specific timesheet by using a unique timesheet ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $timesheet_id Identifier for the timesheet (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollUk\TimesheetObject, HTTP status code, HTTP response headers (array of strings)
     */
    public function getTimesheetWithHttpInfo($xero_tenant_id, $timesheet_id)
    {
        $request = $this->getTimesheetRequest($xero_tenant_id, $timesheet_id);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollUk\TimesheetObject' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollUk\TimesheetObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\TimesheetObject';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollUkObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollUk\TimesheetObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getTimesheetAsync
     * Retrieve a specific timesheet by using a unique timesheet ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $timesheet_id Identifier for the timesheet (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getTimesheetAsync($xero_tenant_id, $timesheet_id)
    {
        return $this->getTimesheetAsyncWithHttpInfo($xero_tenant_id, $timesheet_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getTimesheetAsyncWithHttpInfo
     * Retrieve a specific timesheet by using a unique timesheet ID
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $timesheet_id Identifier for the timesheet (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getTimesheetAsyncWithHttpInfo($xero_tenant_id, $timesheet_id)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\TimesheetObject';
        $request = $this->getTimesheetRequest($xero_tenant_id, $timesheet_id);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getTimesheet'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $timesheet_id Identifier for the timesheet (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getTimesheetRequest($xero_tenant_id, $timesheet_id)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getTimesheet'
            );
        }
        // verify the required parameter 'timesheet_id' is set
        if ($timesheet_id === null || (is_array($timesheet_id) && count($timesheet_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $timesheet_id when calling getTimesheet'
            );
        }
        $resourcePath = '/Timesheets/{TimesheetID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollUkObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // path params
        if ($timesheet_id !== null) {
            $resourcePath = str_replace(
                '{' . 'TimesheetID' . '}',
                PayrollUkObjectSerializer::toPathValue($timesheet_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollUkObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHostPayrollUk() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getTimesheets
     * Retrieves timesheets
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @param  string $filter Filter by first name and/or lastname (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollUk\Timesheets
     */
    public function getTimesheets($xero_tenant_id, $page = null, $filter = null)
    {
        list($response) = $this->getTimesheetsWithHttpInfo($xero_tenant_id, $page, $filter);
        return $response;
    }
    /**
     * Operation getTimesheetsWithHttpInfo
     * Retrieves timesheets
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @param  string $filter Filter by first name and/or lastname (optional)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollUk\Timesheets, HTTP status code, HTTP response headers (array of strings)
     */
    public function getTimesheetsWithHttpInfo($xero_tenant_id, $page = null, $filter = null)
    {
        $request = $this->getTimesheetsRequest($xero_tenant_id, $page, $filter);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollUk\Timesheets' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollUk\Timesheets', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\Timesheets';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollUkObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollUk\Timesheets',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getTimesheetsAsync
     * Retrieves timesheets
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @param  string $filter Filter by first name and/or lastname (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getTimesheetsAsync($xero_tenant_id, $page = null, $filter = null)
    {
        return $this->getTimesheetsAsyncWithHttpInfo($xero_tenant_id, $page, $filter)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getTimesheetsAsyncWithHttpInfo
     * Retrieves timesheets
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @param  string $filter Filter by first name and/or lastname (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getTimesheetsAsyncWithHttpInfo($xero_tenant_id, $page = null, $filter = null)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\Timesheets';
        $request = $this->getTimesheetsRequest($xero_tenant_id, $page, $filter);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getTimesheets'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  int $page Page number which specifies the set of records to retrieve. By default the number of the records per set is 100. (optional)
     * @param  string $filter Filter by first name and/or lastname (optional)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getTimesheetsRequest($xero_tenant_id, $page = null, $filter = null)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getTimesheets'
            );
        }
        $resourcePath = '/Timesheets';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // query params
        if ($page !== null) {
            $queryParams['page'] = PayrollUkObjectSerializer::toQueryValue($page);
        }
        // query params
        if ($filter !== null) {
            $queryParams['filter'] = PayrollUkObjectSerializer::toQueryValue($filter);
        }
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollUkObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollUkObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHostPayrollUk() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getTrackingCategories
     * Retrieves tracking categories
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollUk\TrackingCategories
     */
    public function getTrackingCategories($xero_tenant_id)
    {
        list($response) = $this->getTrackingCategoriesWithHttpInfo($xero_tenant_id);
        return $response;
    }
    /**
     * Operation getTrackingCategoriesWithHttpInfo
     * Retrieves tracking categories
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollUk\TrackingCategories, HTTP status code, HTTP response headers (array of strings)
     */
    public function getTrackingCategoriesWithHttpInfo($xero_tenant_id)
    {
        $request = $this->getTrackingCategoriesRequest($xero_tenant_id);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollUk\TrackingCategories' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollUk\TrackingCategories', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\TrackingCategories';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollUkObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollUk\TrackingCategories',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation getTrackingCategoriesAsync
     * Retrieves tracking categories
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getTrackingCategoriesAsync($xero_tenant_id)
    {
        return $this->getTrackingCategoriesAsyncWithHttpInfo($xero_tenant_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation getTrackingCategoriesAsyncWithHttpInfo
     * Retrieves tracking categories
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function getTrackingCategoriesAsyncWithHttpInfo($xero_tenant_id)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\TrackingCategories';
        $request = $this->getTrackingCategoriesRequest($xero_tenant_id);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getTrackingCategories'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function getTrackingCategoriesRequest($xero_tenant_id)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling getTrackingCategories'
            );
        }
        $resourcePath = '/Settings/trackingCategories';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollUkObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollUkObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHostPayrollUk() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation revertTimesheet
     * Reverts a specific timesheet to draft
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $timesheet_id Identifier for the timesheet (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollUk\TimesheetObject|\XeroAPI\XeroPHP\Models\PayrollUk\Problem
     */
    public function revertTimesheet($xero_tenant_id, $timesheet_id)
    {
        list($response) = $this->revertTimesheetWithHttpInfo($xero_tenant_id, $timesheet_id);
        return $response;
    }
    /**
     * Operation revertTimesheetWithHttpInfo
     * Reverts a specific timesheet to draft
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $timesheet_id Identifier for the timesheet (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollUk\TimesheetObject|\XeroAPI\XeroPHP\Models\PayrollUk\Problem, HTTP status code, HTTP response headers (array of strings)
     */
    public function revertTimesheetWithHttpInfo($xero_tenant_id, $timesheet_id)
    {
        $request = $this->revertTimesheetRequest($xero_tenant_id, $timesheet_id);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollUk\TimesheetObject' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollUk\TimesheetObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\XeroAPI\XeroPHP\Models\PayrollUk\Problem' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollUk\Problem', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\TimesheetObject';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollUkObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollUk\TimesheetObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = PayrollUkObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollUk\Problem',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation revertTimesheetAsync
     * Reverts a specific timesheet to draft
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $timesheet_id Identifier for the timesheet (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function revertTimesheetAsync($xero_tenant_id, $timesheet_id)
    {
        return $this->revertTimesheetAsyncWithHttpInfo($xero_tenant_id, $timesheet_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation revertTimesheetAsyncWithHttpInfo
     * Reverts a specific timesheet to draft
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $timesheet_id Identifier for the timesheet (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function revertTimesheetAsyncWithHttpInfo($xero_tenant_id, $timesheet_id)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\TimesheetObject';
        $request = $this->revertTimesheetRequest($xero_tenant_id, $timesheet_id);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'revertTimesheet'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $timesheet_id Identifier for the timesheet (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function revertTimesheetRequest($xero_tenant_id, $timesheet_id)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling revertTimesheet'
            );
        }
        // verify the required parameter 'timesheet_id' is set
        if ($timesheet_id === null || (is_array($timesheet_id) && count($timesheet_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $timesheet_id when calling revertTimesheet'
            );
        }
        $resourcePath = '/Timesheets/{TimesheetID}/RevertToDraft';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollUkObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // path params
        if ($timesheet_id !== null) {
            $resourcePath = str_replace(
                '{' . 'TimesheetID' . '}',
                PayrollUkObjectSerializer::toPathValue($timesheet_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollUkObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'POST',
            $this->config->getHostPayrollUk() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateEmployee
     * Updates a specific employee's detail
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\Employee $employee employee (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollUk\EmployeeObject|\XeroAPI\XeroPHP\Models\PayrollUk\Problem
     */
    public function updateEmployee($xero_tenant_id, $employee_id, $employee)
    {
        list($response) = $this->updateEmployeeWithHttpInfo($xero_tenant_id, $employee_id, $employee);
        return $response;
    }
    /**
     * Operation updateEmployeeWithHttpInfo
     * Updates a specific employee's detail
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\Employee $employee (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollUk\EmployeeObject|\XeroAPI\XeroPHP\Models\PayrollUk\Problem, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateEmployeeWithHttpInfo($xero_tenant_id, $employee_id, $employee)
    {
        $request = $this->updateEmployeeRequest($xero_tenant_id, $employee_id, $employee);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollUk\EmployeeObject' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollUk\EmployeeObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\XeroAPI\XeroPHP\Models\PayrollUk\Problem' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollUk\Problem', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\EmployeeObject';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollUkObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollUk\EmployeeObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = PayrollUkObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollUk\Problem',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation updateEmployeeAsync
     * Updates a specific employee's detail
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\Employee $employee (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateEmployeeAsync($xero_tenant_id, $employee_id, $employee)
    {
        return $this->updateEmployeeAsyncWithHttpInfo($xero_tenant_id, $employee_id, $employee)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation updateEmployeeAsyncWithHttpInfo
     * Updates a specific employee's detail
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\Employee $employee (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function updateEmployeeAsyncWithHttpInfo($xero_tenant_id, $employee_id, $employee)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\EmployeeObject';
        $request = $this->updateEmployeeRequest($xero_tenant_id, $employee_id, $employee);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateEmployee'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\Employee $employee (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function updateEmployeeRequest($xero_tenant_id, $employee_id, $employee)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling updateEmployee'
            );
        }
        // verify the required parameter 'employee_id' is set
        if ($employee_id === null || (is_array($employee_id) && count($employee_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $employee_id when calling updateEmployee'
            );
        }
        // verify the required parameter 'employee' is set
        if ($employee === null || (is_array($employee) && count($employee) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $employee when calling updateEmployee'
            );
        }
        $resourcePath = '/Employees/{EmployeeID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollUkObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // path params
        if ($employee_id !== null) {
            $resourcePath = str_replace(
                '{' . 'EmployeeID' . '}',
                PayrollUkObjectSerializer::toPathValue($employee_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if (isset($employee)) {
            $_tempBody = $employee;
        }
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollUkObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'PUT',
            $this->config->getHostPayrollUk() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateEmployeeEarningsTemplate
     * Updates a specific employee's earnings template records
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  string $pay_template_earning_id Id for single pay template earnings object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\EarningsTemplate $earnings_template earnings_template (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollUk\EarningsTemplateObject|\XeroAPI\XeroPHP\Models\PayrollUk\Problem
     */
    public function updateEmployeeEarningsTemplate($xero_tenant_id, $employee_id, $pay_template_earning_id, $earnings_template)
    {
        list($response) = $this->updateEmployeeEarningsTemplateWithHttpInfo($xero_tenant_id, $employee_id, $pay_template_earning_id, $earnings_template);
        return $response;
    }
    /**
     * Operation updateEmployeeEarningsTemplateWithHttpInfo
     * Updates a specific employee's earnings template records
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  string $pay_template_earning_id Id for single pay template earnings object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\EarningsTemplate $earnings_template (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollUk\EarningsTemplateObject|\XeroAPI\XeroPHP\Models\PayrollUk\Problem, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateEmployeeEarningsTemplateWithHttpInfo($xero_tenant_id, $employee_id, $pay_template_earning_id, $earnings_template)
    {
        $request = $this->updateEmployeeEarningsTemplateRequest($xero_tenant_id, $employee_id, $pay_template_earning_id, $earnings_template);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollUk\EarningsTemplateObject' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollUk\EarningsTemplateObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\XeroAPI\XeroPHP\Models\PayrollUk\Problem' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollUk\Problem', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\EarningsTemplateObject';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollUkObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollUk\EarningsTemplateObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = PayrollUkObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollUk\Problem',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation updateEmployeeEarningsTemplateAsync
     * Updates a specific employee's earnings template records
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  string $pay_template_earning_id Id for single pay template earnings object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\EarningsTemplate $earnings_template (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateEmployeeEarningsTemplateAsync($xero_tenant_id, $employee_id, $pay_template_earning_id, $earnings_template)
    {
        return $this->updateEmployeeEarningsTemplateAsyncWithHttpInfo($xero_tenant_id, $employee_id, $pay_template_earning_id, $earnings_template)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation updateEmployeeEarningsTemplateAsyncWithHttpInfo
     * Updates a specific employee's earnings template records
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  string $pay_template_earning_id Id for single pay template earnings object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\EarningsTemplate $earnings_template (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function updateEmployeeEarningsTemplateAsyncWithHttpInfo($xero_tenant_id, $employee_id, $pay_template_earning_id, $earnings_template)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\EarningsTemplateObject';
        $request = $this->updateEmployeeEarningsTemplateRequest($xero_tenant_id, $employee_id, $pay_template_earning_id, $earnings_template);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateEmployeeEarningsTemplate'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  string $pay_template_earning_id Id for single pay template earnings object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\EarningsTemplate $earnings_template (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function updateEmployeeEarningsTemplateRequest($xero_tenant_id, $employee_id, $pay_template_earning_id, $earnings_template)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling updateEmployeeEarningsTemplate'
            );
        }
        // verify the required parameter 'employee_id' is set
        if ($employee_id === null || (is_array($employee_id) && count($employee_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $employee_id when calling updateEmployeeEarningsTemplate'
            );
        }
        // verify the required parameter 'pay_template_earning_id' is set
        if ($pay_template_earning_id === null || (is_array($pay_template_earning_id) && count($pay_template_earning_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $pay_template_earning_id when calling updateEmployeeEarningsTemplate'
            );
        }
        // verify the required parameter 'earnings_template' is set
        if ($earnings_template === null || (is_array($earnings_template) && count($earnings_template) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $earnings_template when calling updateEmployeeEarningsTemplate'
            );
        }
        $resourcePath = '/Employees/{EmployeeID}/PayTemplates/earnings/{PayTemplateEarningID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollUkObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // path params
        if ($employee_id !== null) {
            $resourcePath = str_replace(
                '{' . 'EmployeeID' . '}',
                PayrollUkObjectSerializer::toPathValue($employee_id),
                $resourcePath
            );
        }
        // path params
        if ($pay_template_earning_id !== null) {
            $resourcePath = str_replace(
                '{' . 'PayTemplateEarningID' . '}',
                PayrollUkObjectSerializer::toPathValue($pay_template_earning_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if (isset($earnings_template)) {
            $_tempBody = $earnings_template;
        }
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollUkObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'PUT',
            $this->config->getHostPayrollUk() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateEmployeeLeave
     * Updates a specific employee's leave records
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  string $leave_id Leave id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\EmployeeLeave $employee_leave employee_leave (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollUk\EmployeeLeaveObject|\XeroAPI\XeroPHP\Models\PayrollUk\Problem
     */
    public function updateEmployeeLeave($xero_tenant_id, $employee_id, $leave_id, $employee_leave)
    {
        list($response) = $this->updateEmployeeLeaveWithHttpInfo($xero_tenant_id, $employee_id, $leave_id, $employee_leave);
        return $response;
    }
    /**
     * Operation updateEmployeeLeaveWithHttpInfo
     * Updates a specific employee's leave records
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  string $leave_id Leave id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\EmployeeLeave $employee_leave (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollUk\EmployeeLeaveObject|\XeroAPI\XeroPHP\Models\PayrollUk\Problem, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateEmployeeLeaveWithHttpInfo($xero_tenant_id, $employee_id, $leave_id, $employee_leave)
    {
        $request = $this->updateEmployeeLeaveRequest($xero_tenant_id, $employee_id, $leave_id, $employee_leave);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollUk\EmployeeLeaveObject' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollUk\EmployeeLeaveObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\XeroAPI\XeroPHP\Models\PayrollUk\Problem' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollUk\Problem', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\EmployeeLeaveObject';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollUkObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollUk\EmployeeLeaveObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = PayrollUkObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollUk\Problem',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation updateEmployeeLeaveAsync
     * Updates a specific employee's leave records
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  string $leave_id Leave id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\EmployeeLeave $employee_leave (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateEmployeeLeaveAsync($xero_tenant_id, $employee_id, $leave_id, $employee_leave)
    {
        return $this->updateEmployeeLeaveAsyncWithHttpInfo($xero_tenant_id, $employee_id, $leave_id, $employee_leave)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation updateEmployeeLeaveAsyncWithHttpInfo
     * Updates a specific employee's leave records
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  string $leave_id Leave id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\EmployeeLeave $employee_leave (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function updateEmployeeLeaveAsyncWithHttpInfo($xero_tenant_id, $employee_id, $leave_id, $employee_leave)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\EmployeeLeaveObject';
        $request = $this->updateEmployeeLeaveRequest($xero_tenant_id, $employee_id, $leave_id, $employee_leave);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateEmployeeLeave'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  string $leave_id Leave id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\EmployeeLeave $employee_leave (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function updateEmployeeLeaveRequest($xero_tenant_id, $employee_id, $leave_id, $employee_leave)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling updateEmployeeLeave'
            );
        }
        // verify the required parameter 'employee_id' is set
        if ($employee_id === null || (is_array($employee_id) && count($employee_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $employee_id when calling updateEmployeeLeave'
            );
        }
        // verify the required parameter 'leave_id' is set
        if ($leave_id === null || (is_array($leave_id) && count($leave_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $leave_id when calling updateEmployeeLeave'
            );
        }
        // verify the required parameter 'employee_leave' is set
        if ($employee_leave === null || (is_array($employee_leave) && count($employee_leave) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $employee_leave when calling updateEmployeeLeave'
            );
        }
        $resourcePath = '/Employees/{EmployeeID}/Leave/{LeaveID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollUkObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // path params
        if ($employee_id !== null) {
            $resourcePath = str_replace(
                '{' . 'EmployeeID' . '}',
                PayrollUkObjectSerializer::toPathValue($employee_id),
                $resourcePath
            );
        }
        // path params
        if ($leave_id !== null) {
            $resourcePath = str_replace(
                '{' . 'LeaveID' . '}',
                PayrollUkObjectSerializer::toPathValue($leave_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if (isset($employee_leave)) {
            $_tempBody = $employee_leave;
        }
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollUkObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'PUT',
            $this->config->getHostPayrollUk() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateEmployeeOpeningBalances
     * Updates a specific employee's opening balances
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\EmployeeOpeningBalances $employee_opening_balances employee_opening_balances (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollUk\EmployeeOpeningBalancesObject|\XeroAPI\XeroPHP\Models\PayrollUk\Problem
     */
    public function updateEmployeeOpeningBalances($xero_tenant_id, $employee_id, $employee_opening_balances)
    {
        list($response) = $this->updateEmployeeOpeningBalancesWithHttpInfo($xero_tenant_id, $employee_id, $employee_opening_balances);
        return $response;
    }
    /**
     * Operation updateEmployeeOpeningBalancesWithHttpInfo
     * Updates a specific employee's opening balances
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\EmployeeOpeningBalances $employee_opening_balances (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollUk\EmployeeOpeningBalancesObject|\XeroAPI\XeroPHP\Models\PayrollUk\Problem, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateEmployeeOpeningBalancesWithHttpInfo($xero_tenant_id, $employee_id, $employee_opening_balances)
    {
        $request = $this->updateEmployeeOpeningBalancesRequest($xero_tenant_id, $employee_id, $employee_opening_balances);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollUk\EmployeeOpeningBalancesObject' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollUk\EmployeeOpeningBalancesObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\XeroAPI\XeroPHP\Models\PayrollUk\Problem' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollUk\Problem', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\EmployeeOpeningBalancesObject';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollUkObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollUk\EmployeeOpeningBalancesObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = PayrollUkObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollUk\Problem',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation updateEmployeeOpeningBalancesAsync
     * Updates a specific employee's opening balances
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\EmployeeOpeningBalances $employee_opening_balances (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateEmployeeOpeningBalancesAsync($xero_tenant_id, $employee_id, $employee_opening_balances)
    {
        return $this->updateEmployeeOpeningBalancesAsyncWithHttpInfo($xero_tenant_id, $employee_id, $employee_opening_balances)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation updateEmployeeOpeningBalancesAsyncWithHttpInfo
     * Updates a specific employee's opening balances
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\EmployeeOpeningBalances $employee_opening_balances (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function updateEmployeeOpeningBalancesAsyncWithHttpInfo($xero_tenant_id, $employee_id, $employee_opening_balances)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\EmployeeOpeningBalancesObject';
        $request = $this->updateEmployeeOpeningBalancesRequest($xero_tenant_id, $employee_id, $employee_opening_balances);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateEmployeeOpeningBalances'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\EmployeeOpeningBalances $employee_opening_balances (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function updateEmployeeOpeningBalancesRequest($xero_tenant_id, $employee_id, $employee_opening_balances)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling updateEmployeeOpeningBalances'
            );
        }
        // verify the required parameter 'employee_id' is set
        if ($employee_id === null || (is_array($employee_id) && count($employee_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $employee_id when calling updateEmployeeOpeningBalances'
            );
        }
        // verify the required parameter 'employee_opening_balances' is set
        if ($employee_opening_balances === null || (is_array($employee_opening_balances) && count($employee_opening_balances) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $employee_opening_balances when calling updateEmployeeOpeningBalances'
            );
        }
        $resourcePath = '/Employees/{EmployeeID}/ukopeningbalances';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollUkObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // path params
        if ($employee_id !== null) {
            $resourcePath = str_replace(
                '{' . 'EmployeeID' . '}',
                PayrollUkObjectSerializer::toPathValue($employee_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if (isset($employee_opening_balances)) {
            $_tempBody = $employee_opening_balances;
        }
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollUkObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'PUT',
            $this->config->getHostPayrollUk() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateEmployeeSalaryAndWage
     * Updates salary and wages record for a specific employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  string $salary_and_wages_id Id for single pay template earnings object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\SalaryAndWage $salary_and_wage salary_and_wage (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollUk\SalaryAndWageObject|\XeroAPI\XeroPHP\Models\PayrollUk\Problem
     */
    public function updateEmployeeSalaryAndWage($xero_tenant_id, $employee_id, $salary_and_wages_id, $salary_and_wage)
    {
        list($response) = $this->updateEmployeeSalaryAndWageWithHttpInfo($xero_tenant_id, $employee_id, $salary_and_wages_id, $salary_and_wage);
        return $response;
    }
    /**
     * Operation updateEmployeeSalaryAndWageWithHttpInfo
     * Updates salary and wages record for a specific employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  string $salary_and_wages_id Id for single pay template earnings object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\SalaryAndWage $salary_and_wage (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollUk\SalaryAndWageObject|\XeroAPI\XeroPHP\Models\PayrollUk\Problem, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateEmployeeSalaryAndWageWithHttpInfo($xero_tenant_id, $employee_id, $salary_and_wages_id, $salary_and_wage)
    {
        $request = $this->updateEmployeeSalaryAndWageRequest($xero_tenant_id, $employee_id, $salary_and_wages_id, $salary_and_wage);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollUk\SalaryAndWageObject' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollUk\SalaryAndWageObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\XeroAPI\XeroPHP\Models\PayrollUk\Problem' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollUk\Problem', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\SalaryAndWageObject';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollUkObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollUk\SalaryAndWageObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = PayrollUkObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollUk\Problem',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation updateEmployeeSalaryAndWageAsync
     * Updates salary and wages record for a specific employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  string $salary_and_wages_id Id for single pay template earnings object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\SalaryAndWage $salary_and_wage (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateEmployeeSalaryAndWageAsync($xero_tenant_id, $employee_id, $salary_and_wages_id, $salary_and_wage)
    {
        return $this->updateEmployeeSalaryAndWageAsyncWithHttpInfo($xero_tenant_id, $employee_id, $salary_and_wages_id, $salary_and_wage)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation updateEmployeeSalaryAndWageAsyncWithHttpInfo
     * Updates salary and wages record for a specific employee
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  string $salary_and_wages_id Id for single pay template earnings object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\SalaryAndWage $salary_and_wage (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function updateEmployeeSalaryAndWageAsyncWithHttpInfo($xero_tenant_id, $employee_id, $salary_and_wages_id, $salary_and_wage)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\SalaryAndWageObject';
        $request = $this->updateEmployeeSalaryAndWageRequest($xero_tenant_id, $employee_id, $salary_and_wages_id, $salary_and_wage);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateEmployeeSalaryAndWage'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $employee_id Employee id for single object (required)
     * @param  string $salary_and_wages_id Id for single pay template earnings object (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\SalaryAndWage $salary_and_wage (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function updateEmployeeSalaryAndWageRequest($xero_tenant_id, $employee_id, $salary_and_wages_id, $salary_and_wage)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling updateEmployeeSalaryAndWage'
            );
        }
        // verify the required parameter 'employee_id' is set
        if ($employee_id === null || (is_array($employee_id) && count($employee_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $employee_id when calling updateEmployeeSalaryAndWage'
            );
        }
        // verify the required parameter 'salary_and_wages_id' is set
        if ($salary_and_wages_id === null || (is_array($salary_and_wages_id) && count($salary_and_wages_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $salary_and_wages_id when calling updateEmployeeSalaryAndWage'
            );
        }
        // verify the required parameter 'salary_and_wage' is set
        if ($salary_and_wage === null || (is_array($salary_and_wage) && count($salary_and_wage) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $salary_and_wage when calling updateEmployeeSalaryAndWage'
            );
        }
        $resourcePath = '/Employees/{EmployeeID}/SalaryAndWages/{SalaryAndWagesID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollUkObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // path params
        if ($employee_id !== null) {
            $resourcePath = str_replace(
                '{' . 'EmployeeID' . '}',
                PayrollUkObjectSerializer::toPathValue($employee_id),
                $resourcePath
            );
        }
        // path params
        if ($salary_and_wages_id !== null) {
            $resourcePath = str_replace(
                '{' . 'SalaryAndWagesID' . '}',
                PayrollUkObjectSerializer::toPathValue($salary_and_wages_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if (isset($salary_and_wage)) {
            $_tempBody = $salary_and_wage;
        }
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollUkObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'PUT',
            $this->config->getHostPayrollUk() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updatePayRun
     * Updates a specific pay run
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $pay_run_id Identifier for the pay run (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\PayRun $pay_run pay_run (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollUk\PayRunObject|\XeroAPI\XeroPHP\Models\PayrollUk\Problem
     */
    public function updatePayRun($xero_tenant_id, $pay_run_id, $pay_run)
    {
        list($response) = $this->updatePayRunWithHttpInfo($xero_tenant_id, $pay_run_id, $pay_run);
        return $response;
    }
    /**
     * Operation updatePayRunWithHttpInfo
     * Updates a specific pay run
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $pay_run_id Identifier for the pay run (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\PayRun $pay_run (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollUk\PayRunObject|\XeroAPI\XeroPHP\Models\PayrollUk\Problem, HTTP status code, HTTP response headers (array of strings)
     */
    public function updatePayRunWithHttpInfo($xero_tenant_id, $pay_run_id, $pay_run)
    {
        $request = $this->updatePayRunRequest($xero_tenant_id, $pay_run_id, $pay_run);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollUk\PayRunObject' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollUk\PayRunObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\XeroAPI\XeroPHP\Models\PayrollUk\Problem' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollUk\Problem', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\PayRunObject';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollUkObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollUk\PayRunObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = PayrollUkObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollUk\Problem',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation updatePayRunAsync
     * Updates a specific pay run
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $pay_run_id Identifier for the pay run (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\PayRun $pay_run (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updatePayRunAsync($xero_tenant_id, $pay_run_id, $pay_run)
    {
        return $this->updatePayRunAsyncWithHttpInfo($xero_tenant_id, $pay_run_id, $pay_run)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation updatePayRunAsyncWithHttpInfo
     * Updates a specific pay run
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $pay_run_id Identifier for the pay run (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\PayRun $pay_run (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function updatePayRunAsyncWithHttpInfo($xero_tenant_id, $pay_run_id, $pay_run)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\PayRunObject';
        $request = $this->updatePayRunRequest($xero_tenant_id, $pay_run_id, $pay_run);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updatePayRun'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $pay_run_id Identifier for the pay run (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\PayRun $pay_run (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function updatePayRunRequest($xero_tenant_id, $pay_run_id, $pay_run)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling updatePayRun'
            );
        }
        // verify the required parameter 'pay_run_id' is set
        if ($pay_run_id === null || (is_array($pay_run_id) && count($pay_run_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $pay_run_id when calling updatePayRun'
            );
        }
        // verify the required parameter 'pay_run' is set
        if ($pay_run === null || (is_array($pay_run) && count($pay_run) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $pay_run when calling updatePayRun'
            );
        }
        $resourcePath = '/PayRuns/{PayRunID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollUkObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // path params
        if ($pay_run_id !== null) {
            $resourcePath = str_replace(
                '{' . 'PayRunID' . '}',
                PayrollUkObjectSerializer::toPathValue($pay_run_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if (isset($pay_run)) {
            $_tempBody = $pay_run;
        }
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollUkObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'PUT',
            $this->config->getHostPayrollUk() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateTimesheetLine
     * Updates a specific timesheet line for a specific timesheet
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $timesheet_id Identifier for the timesheet (required)
     * @param  string $timesheet_line_id Identifier for the timesheet line (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\TimesheetLine $timesheet_line timesheet_line (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \XeroAPI\XeroPHP\Models\PayrollUk\TimesheetLineObject|\XeroAPI\XeroPHP\Models\PayrollUk\Problem
     */
    public function updateTimesheetLine($xero_tenant_id, $timesheet_id, $timesheet_line_id, $timesheet_line)
    {
        list($response) = $this->updateTimesheetLineWithHttpInfo($xero_tenant_id, $timesheet_id, $timesheet_line_id, $timesheet_line);
        return $response;
    }
    /**
     * Operation updateTimesheetLineWithHttpInfo
     * Updates a specific timesheet line for a specific timesheet
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $timesheet_id Identifier for the timesheet (required)
     * @param  string $timesheet_line_id Identifier for the timesheet line (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\TimesheetLine $timesheet_line (required)
     * @throws \XeroAPI\XeroPHP\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \XeroAPI\XeroPHP\Models\PayrollUk\TimesheetLineObject|\XeroAPI\XeroPHP\Models\PayrollUk\Problem, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateTimesheetLineWithHttpInfo($xero_tenant_id, $timesheet_id, $timesheet_line_id, $timesheet_line)
    {
        $request = $this->updateTimesheetLineRequest($xero_tenant_id, $timesheet_id, $timesheet_line_id, $timesheet_line);
        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }
            $statusCode = $response->getStatusCode();
            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }
            $responseBody = $response->getBody();
            switch($statusCode) {
                case 200:
                    if ('\XeroAPI\XeroPHP\Models\PayrollUk\TimesheetLineObject' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollUk\TimesheetLineObject', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                case 400:
                    if ('\XeroAPI\XeroPHP\Models\PayrollUk\Problem' === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, '\XeroAPI\XeroPHP\Models\PayrollUk\Problem', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }
            $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\TimesheetLineObject';
            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
            }
            return [
                PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = PayrollUkObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollUk\TimesheetLineObject',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = PayrollUkObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\XeroAPI\XeroPHP\Models\PayrollUk\Problem',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }
    /**
     * Operation updateTimesheetLineAsync
     * Updates a specific timesheet line for a specific timesheet
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $timesheet_id Identifier for the timesheet (required)
     * @param  string $timesheet_line_id Identifier for the timesheet line (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\TimesheetLine $timesheet_line (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateTimesheetLineAsync($xero_tenant_id, $timesheet_id, $timesheet_line_id, $timesheet_line)
    {
        return $this->updateTimesheetLineAsyncWithHttpInfo($xero_tenant_id, $timesheet_id, $timesheet_line_id, $timesheet_line)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }
    /**
     * Operation updateTimesheetLineAsyncWithHttpInfo
     * Updates a specific timesheet line for a specific timesheet
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $timesheet_id Identifier for the timesheet (required)
     * @param  string $timesheet_line_id Identifier for the timesheet line (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\TimesheetLine $timesheet_line (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface */
    public function updateTimesheetLineAsyncWithHttpInfo($xero_tenant_id, $timesheet_id, $timesheet_line_id, $timesheet_line)
    {
        $returnType = '\XeroAPI\XeroPHP\Models\PayrollUk\TimesheetLineObject';
        $request = $this->updateTimesheetLineRequest($xero_tenant_id, $timesheet_id, $timesheet_line_id, $timesheet_line);
        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                    }
                    return [
                        PayrollUkObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateTimesheetLine'
     * @param  string $xero_tenant_id Xero identifier for Tenant (required)
     * @param  string $timesheet_id Identifier for the timesheet (required)
     * @param  string $timesheet_line_id Identifier for the timesheet line (required)
     * @param  \XeroAPI\XeroPHP\Models\PayrollUk\TimesheetLine $timesheet_line (required)
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request  */
    protected function updateTimesheetLineRequest($xero_tenant_id, $timesheet_id, $timesheet_line_id, $timesheet_line)
    {
        // verify the required parameter 'xero_tenant_id' is set
        if ($xero_tenant_id === null || (is_array($xero_tenant_id) && count($xero_tenant_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $xero_tenant_id when calling updateTimesheetLine'
            );
        }
        // verify the required parameter 'timesheet_id' is set
        if ($timesheet_id === null || (is_array($timesheet_id) && count($timesheet_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $timesheet_id when calling updateTimesheetLine'
            );
        }
        // verify the required parameter 'timesheet_line_id' is set
        if ($timesheet_line_id === null || (is_array($timesheet_line_id) && count($timesheet_line_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $timesheet_line_id when calling updateTimesheetLine'
            );
        }
        // verify the required parameter 'timesheet_line' is set
        if ($timesheet_line === null || (is_array($timesheet_line) && count($timesheet_line) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $timesheet_line when calling updateTimesheetLine'
            );
        }
        $resourcePath = '/Timesheets/{TimesheetID}/Lines/{TimesheetLineID}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;
        // header params
        if ($xero_tenant_id !== null) {
            $headerParams['Xero-Tenant-Id'] = PayrollUkObjectSerializer::toHeaderValue($xero_tenant_id);
        }
        // path params
        if ($timesheet_id !== null) {
            $resourcePath = str_replace(
                '{' . 'TimesheetID' . '}',
                PayrollUkObjectSerializer::toPathValue($timesheet_id),
                $resourcePath
            );
        }
        // path params
        if ($timesheet_line_id !== null) {
            $resourcePath = str_replace(
                '{' . 'TimesheetLineID' . '}',
                PayrollUkObjectSerializer::toPathValue($timesheet_line_id),
                $resourcePath
            );
        }
        // body params
        $_tempBody = null;
        if (isset($timesheet_line)) {
            $_tempBody = $timesheet_line;
        }
        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }
        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(PayrollUkObjectSerializer::sanitizeForSerialization($_tempBody));
            } else {
                $httpBody = $_tempBody;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [
                    [
                        'Content-type' => 'multipart/form-data',
                    ]
                ];
                
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp\Psr7\build_query($formParams);
            }
        }
        // this endpoint requires OAuth (access token)
        if ($this->config->getAccessToken() !== null) {
            $headers['Authorization'] = 'Bearer ' . $this->config->getAccessToken();
        }
        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }
        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );
        $query = \GuzzleHttp\Psr7\build_query($queryParams);
        return new Request(
            'PUT',
            $this->config->getHostPayrollUk() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
