@extends('layouts.auth')

@section('content')
<div class="auth-container d-md-flex align-items-center">
    <div class="container">
        <div class="row">
            <div class="col-md-12 col-lg-10 offset-lg-1">
                <div class="bg-white p-2">
                    <div class="row no-gutters">
                        <div class="col-md-6">
                            <div class="card card-signin p-3">
                                <div class="card-body">
                                    <img class="logo" src="{{ get_logo() }}">

                                    <h6 class="py-4">{{ _lang('Login To Your Account') }}</h6>

                                    @if(Session::has('error'))
                                        <div class="alert alert-danger text-center">
                                            <strong>{{ session('error') }}</strong>
                                        </div>
                                    @endif

                                    @if(Session::has('registration_success'))
                                        <div class="alert alert-success text-center">
                                            <strong>{{ session('registration_success') }}</strong>
                                        </div>
                                    @endif

                                    <form method="POST" class="form-signin" action="{{ route('login') }}">
                                        @csrf

                                        <div class="form-group row">
                                            <div class="col-md-12">
                                                <input id="email" type="email" class="form-control{{ $errors->has('email') ? ' is-invalid' : '' }}" name="email" value="{{ old('email') }}" placeholder="{{ _lang('Email') }}" required autofocus>

                                                @if ($errors->has('email'))
                                                    <span class="invalid-feedback">
                                                        <strong>{{ $errors->first('email') }}</strong>
                                                    </span>
                                                @endif
                                            </div>
                                        </div>

                                        <div class="form-group row">
                                            <div class="col-md-12">

                                                <input id="password" type="password" class="form-control{{ $errors->has('password') ? ' is-invalid' : '' }}" name="password" placeholder="{{ _lang('Password') }}" required>

                                                @if ($errors->has('password'))
                                                    <span class="invalid-feedback">
                                                        <strong>{{ $errors->first('password') }}</strong>
                                                    </span>
                                                @endif
                                            </div>
                                        </div>

                                        <div class="form-group row">
                                            <div class="col-md-12">
                                                <input type="hidden" name="g-recaptcha-response" id="recaptcha">
                                                @if ($errors->has('g-recaptcha-response'))
                                                    <span class="invalid-feedback">
                                                        <strong>{{ $errors->first('g-recaptcha-response') }}</strong>
                                                    </span>
                                                @endif
                                            </div>
                                        </div>

                                        <div class="form-group row">
                                            <div class="col-md-12">
                                                <div class="custom-control custom-checkbox mb-2">
                                                    <input type="checkbox" name="remember" class="custom-control-input" id="remember" {{ old('remember') ? 'checked' : '' }}>
                                                    <label class="custom-control-label" for="remember">{{ _lang('Remember Me') }}</label>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="form-group row mb-0">
                                            <div class="col-md-12">

                                                <button type="submit" class="btn btn-login btn-block">
                                                    {{ _lang('Login') }}
                                                </button>

                                                @if(get_option('allow_singup') == 'yes')
                                                <a class="btn btn-register btn-block" href="{{ route('register') }}">
                                                    {{ _lang('Create Your Account') }}
                                                </a>
                                                @endif

                                                @if(get_option('google_login') == 'enabled')
                                                    <a href="{{ url('/login/google') }}" class="btn btn-google btn-block"> {{ _lang('Continue With Google') }}</a>
                                                @endif

                                                @if(get_option('facebook_login') == 'enabled')
                                                    <a href="{{ url('/login/facebook') }}" class="btn btn-facebook btn-block"> {{ _lang('Continue With Facebook') }}</a>
                                                @endif

                                            </div>
                                        </div>


                                        <div class="form-group row mt-3">
                                            <div class="col-md-12 text-center">
                                                <a class="btn-link" href="{{ route('password.request') }}">
                                                    {{ _lang('Forgot Password?') }}
                                                </a>
                                            </div>
                                        </div>
                                    </form>

                                    <div class="footer-links text-center">
                                        @if(get_option('website_enable', 'yes') == 'yes')
                                        <a href="{{ url('/' . get_option('privacy_policy_page')) }}" target="_blank">{{ _lang('Privacy Policy') }}</a>
                                        &nbsp;
                                        <a href="{{ url('/' . get_option('terms_condition_page')) }}" target="_blank">{{ _lang('Terms & Condition') }}</a>
                                        @else
                                        <a href="{{ get_option('privacy_policy_page_url') }}" target="_blank">{{ _lang('Privacy Policy') }}</a>
                                        &nbsp;
                                        <a href="{{ get_option('terms_condition_page_url') }}" target="_blank">{{ _lang('Terms & Condition') }}</a>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6 d-none d-md-block">
                            <div id="auth-bg" class="d-flex align-items-center justify-content-center">
                                <div class="px-5">
                                    <p class="mb-1 font-weight-light">{{ _lang('WELCOME TO') }}</p>
                                    <h2 class="font-weight-bold">{{ get_option('site_title', config('app.name')) }}</h2>

                                    <div class="divider"></div>

                                    <p>{{ _lang('Enter your registered email and password and login into your account') }}</p>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@if(get_option('enable_recaptcha', 0) == 1)
<script src="https://www.google.com/recaptcha/api.js?render={{ get_option('recaptcha_site_key') }}"></script>
<script>
    grecaptcha.ready(function() {
        grecaptcha.execute('{{ get_option('recaptcha_site_key') }}', {action: 'login'}).then(function(token) {
        if (token) {
            document.getElementById('recaptcha').value = token;
        }
        });
    });
</script>
@endif
@endsection
